/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.literal;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.calcite.validate.literal.Literal;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.type.converter.BigDecimalConverter;
import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;

public final class NumericLiteral
extends Literal {
    private final Mode mode;
    private final int bitWidth;

    private NumericLiteral(Object value, SqlTypeName typeName, Mode mode, int bitWidth) {
        super(value, typeName);
        this.mode = mode;
        this.bitWidth = bitWidth;
    }

    public static Literal create(SqlTypeName typeName, Object value) {
        Literal res;
        if (value instanceof BigDecimal && !NumericLiteral.hasDecimalPlaces((BigDecimal)value) && !HazelcastTypeUtils.isNumericInexactType(typeName) && (res = NumericLiteral.tryReduceInteger((BigDecimal)value)) != null) {
            return res;
        }
        if (value instanceof BigDecimal) {
            if (typeName == SqlTypeName.DOUBLE) {
                value = ((BigDecimal)value).doubleValue();
            } else if (typeName == SqlTypeName.REAL) {
                value = Float.valueOf(((BigDecimal)value).floatValue());
            }
        }
        return new NumericLiteral(value, typeName, typeName == SqlTypeName.DOUBLE ? Mode.FRACTIONAL_INEXACT : Mode.FRACTIONAL_EXACT, 0);
    }

    private static Literal tryReduceInteger(BigDecimal value) {
        Number adjustedValue;
        long longValue;
        try {
            longValue = BigDecimalConverter.INSTANCE.asBigint((Object)value);
        }
        catch (QueryException e) {
            assert (e.getMessage().contains("Numeric overflow"));
            return null;
        }
        int bitWidth = HazelcastIntegerType.bitWidthOf(longValue);
        HazelcastIntegerType type = HazelcastIntegerType.create(bitWidth, false);
        switch (type.getSqlTypeName()) {
            case TINYINT: {
                adjustedValue = (byte)longValue;
                break;
            }
            case SMALLINT: {
                adjustedValue = (short)longValue;
                break;
            }
            case INTEGER: {
                adjustedValue = (int)longValue;
                break;
            }
            default: {
                assert (type.getSqlTypeName() == SqlTypeName.BIGINT);
                adjustedValue = longValue;
            }
        }
        return new NumericLiteral(adjustedValue, type.getSqlTypeName(), Mode.INTEGER, bitWidth);
    }

    @Override
    public RelDataType getType(HazelcastTypeFactory typeFactory) {
        switch (this.mode) {
            case INTEGER: {
                return HazelcastIntegerType.create(this.bitWidth, false);
            }
            case FRACTIONAL_EXACT: {
                return typeFactory.createSqlType(SqlTypeName.DECIMAL);
            }
        }
        assert (this.mode == Mode.FRACTIONAL_INEXACT);
        return typeFactory.createSqlType(SqlTypeName.DOUBLE);
    }

    @Override
    public String getStringValue() {
        if (this.mode != Mode.FRACTIONAL_INEXACT) {
            return this.value.toString();
        }
        return Util.toScientificNotation((BigDecimal)BigDecimal.valueOf((Double)this.value).stripTrailingZeros());
    }

    private static boolean hasDecimalPlaces(BigDecimal value) {
        return value.scale() > 0;
    }

    private static enum Mode {
        INTEGER,
        FRACTIONAL_EXACT,
        FRACTIONAL_INEXACT;

    }
}

