/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.schema;

import com.hazelcast.sql.impl.calcite.schema.HazelcastRelOptTable;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import java.util.List;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlNameMatchers;

public class HazelcastCalciteCatalogReader
extends CalciteCatalogReader {
    public HazelcastCalciteCatalogReader(CalciteSchema rootSchema, List<List<String>> schemaPaths, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        super(rootSchema, SqlNameMatchers.withCaseSensitive((config != null && config.caseSensitive() ? 1 : 0) != 0), schemaPaths, typeFactory, config);
    }

    public Prepare.PreparingTable getTable(List<String> names) {
        Prepare.PreparingTable table = super.getTable(names);
        if (table == null) {
            return null;
        }
        return new HazelcastRelOptTable(table);
    }

    public RelDataType getNamedType(SqlIdentifier typeName) {
        if (HazelcastTypeUtils.isObjectIdentifier(typeName)) {
            return this.typeFactory.createSqlType(SqlTypeName.ANY);
        }
        if (HazelcastTypeUtils.isTimestampWithTimeZoneIdentifier(typeName)) {
            return this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        }
        return super.getNamedType(typeName);
    }
}

