/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.parse;

import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlOperatorTable;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.schema.map.AbstractMapTable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorTable;

public final class UnsupportedOperationVisitor
implements SqlVisitor<Void> {
    private static final Resource RESOURCE = (Resource)Resources.create(Resource.class);
    private static final Set<SqlKind> SUPPORTED_KINDS = new HashSet<SqlKind>();
    private static final Set<SqlOperator> SUPPORTED_OPERATORS;
    private final SqlValidatorCatalogReader catalogReader;
    private SqlSelect topLevelSelect;

    public UnsupportedOperationVisitor(SqlValidatorCatalogReader catalogReader) {
        this.catalogReader = catalogReader;
    }

    public Void visit(SqlCall call) {
        this.processCall(call);
        call.getOperator().acceptCall((SqlVisitor)this, call);
        return null;
    }

    public Void visit(SqlNodeList nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            SqlNode node = nodeList.get(i);
            node.accept((SqlVisitor)this);
        }
        return null;
    }

    public Void visit(SqlIdentifier id) {
        Object target;
        HazelcastTable hzTable;
        SqlValidatorTable table = this.catalogReader.getTable((List)id.names);
        if (table != null && (hzTable = (HazelcastTable)((Object)table.unwrap(HazelcastTable.class))) != null && (target = hzTable.getTarget()) != null && !(target instanceof AbstractMapTable)) {
            throw UnsupportedOperationVisitor.error((SqlNode)id, RESOURCE.custom(target.getClass().getSimpleName() + " is not supported"));
        }
        return null;
    }

    public Void visit(SqlDataTypeSpec type) {
        SqlIdentifier typeName;
        if (type.getTypeNameSpec() instanceof SqlUserDefinedTypeNameSpec && (HazelcastTypeUtils.isObjectIdentifier(typeName = type.getTypeName()) || HazelcastTypeUtils.isTimestampWithTimeZoneIdentifier(typeName))) {
            return null;
        }
        if (!(type.getTypeNameSpec() instanceof SqlBasicTypeNameSpec)) {
            throw UnsupportedOperationVisitor.error((SqlNode)type, RESOURCE.custom("Complex type specifications are not supported"));
        }
        typeName = SqlTypeName.get((String)type.getTypeName().getSimple());
        switch (1.$SwitchMap$org$apache$calcite$sql$type$SqlTypeName[typeName.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return null;
            }
        }
        throw UnsupportedOperationVisitor.error((SqlNode)type, RESOURCE.notSupported(typeName.getName()));
    }

    public Void visit(SqlDynamicParam param) {
        return null;
    }

    public Void visit(SqlLiteral literal) {
        SqlTypeName typeName = literal.getTypeName();
        switch (typeName) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case REAL: 
            case DOUBLE: 
            case VARCHAR: 
            case NULL: 
            case CHAR: 
            case ANY: {
                return null;
            }
            case SYMBOL: {
                Object symbolValue = literal.getValue();
                if (symbolValue instanceof SqlTrimFunction.Flag) {
                    return null;
                }
                throw UnsupportedOperationVisitor.error((SqlNode)literal, RESOURCE.custom(symbolValue + " literal is not supported"));
            }
        }
        throw UnsupportedOperationVisitor.error((SqlNode)literal, RESOURCE.custom(typeName + " literals are not supported"));
    }

    public Void visit(SqlIntervalQualifier intervalQualifier) {
        return null;
    }

    private void processCall(SqlCall call) {
        SqlKind kind = call.getKind();
        if (SUPPORTED_KINDS.contains(kind)) {
            return;
        }
        switch (kind) {
            case SELECT: {
                this.processSelect((SqlSelect)call);
                return;
            }
            case DESCENDING: 
            case OTHER: 
            case OTHER_FUNCTION: {
                this.processOther(call);
                break;
            }
            default: {
                throw this.unsupported(call);
            }
        }
    }

    private void processSelect(SqlSelect select) {
        if (select.getGroup() != null && select.getGroup().size() > 0) {
            throw UnsupportedOperationVisitor.unsupported((SqlNode)select.getGroup(), "GROUP BY");
        }
        if (this.topLevelSelect == null) {
            this.topLevelSelect = select;
        } else if (select.getFetch() != null || select.getOffset() != null) {
            throw UnsupportedOperationVisitor.error((SqlNode)select, "FETCH/OFFSET is only supported for the top-level SELECT");
        }
    }

    private void processOther(SqlCall call) {
        SqlOperator operator = call.getOperator();
        if (SUPPORTED_OPERATORS.contains(operator)) {
            return;
        }
        throw UnsupportedOperationVisitor.unsupported((SqlNode)call, operator.getName());
    }

    private CalciteContextException unsupported(SqlCall call) {
        String name = call.getOperator().getName();
        return UnsupportedOperationVisitor.unsupported((SqlNode)call, name.replace("$", "").replace('_', ' '));
    }

    private static CalciteContextException unsupported(SqlNode node, String name) {
        return UnsupportedOperationVisitor.error(node, RESOURCE.notSupported(name));
    }

    private static CalciteContextException error(SqlNode node, Resources.ExInst<SqlValidatorException> err) {
        return SqlUtil.newContextException((SqlParserPos)node.getParserPosition(), err);
    }

    public static CalciteContextException error(SqlNode node, String name) {
        return UnsupportedOperationVisitor.error(node, RESOURCE.custom(name));
    }

    static {
        SUPPORTED_KINDS.add(SqlKind.AND);
        SUPPORTED_KINDS.add(SqlKind.OR);
        SUPPORTED_KINDS.add(SqlKind.NOT);
        SUPPORTED_KINDS.add(SqlKind.PLUS);
        SUPPORTED_KINDS.add(SqlKind.MINUS);
        SUPPORTED_KINDS.add(SqlKind.TIMES);
        SUPPORTED_KINDS.add(SqlKind.DIVIDE);
        SUPPORTED_KINDS.add(SqlKind.MOD);
        SUPPORTED_KINDS.add(SqlKind.MINUS_PREFIX);
        SUPPORTED_KINDS.add(SqlKind.PLUS_PREFIX);
        SUPPORTED_KINDS.add(SqlKind.IS_TRUE);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_TRUE);
        SUPPORTED_KINDS.add(SqlKind.IS_FALSE);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_FALSE);
        SUPPORTED_KINDS.add(SqlKind.IS_NULL);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_NULL);
        SUPPORTED_KINDS.add(SqlKind.EQUALS);
        SUPPORTED_KINDS.add(SqlKind.NOT_EQUALS);
        SUPPORTED_KINDS.add(SqlKind.LESS_THAN);
        SUPPORTED_KINDS.add(SqlKind.GREATER_THAN);
        SUPPORTED_KINDS.add(SqlKind.GREATER_THAN_OR_EQUAL);
        SUPPORTED_KINDS.add(SqlKind.LESS_THAN_OR_EQUAL);
        SUPPORTED_KINDS.add(SqlKind.AS);
        SUPPORTED_KINDS.add(SqlKind.CAST);
        SUPPORTED_KINDS.add(SqlKind.CEIL);
        SUPPORTED_KINDS.add(SqlKind.FLOOR);
        SUPPORTED_KINDS.add(SqlKind.LIKE);
        SUPPORTED_KINDS.add(SqlKind.TRIM);
        SUPPORTED_OPERATORS = new HashSet<SqlOperator>();
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.COS);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.SIN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.TAN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.COT);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ACOS);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ASIN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ATAN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.EXP);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.LN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.LOG10);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.RAND);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ABS);
        SUPPORTED_OPERATORS.add((SqlOperator)SqlStdOperatorTable.PI);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.SIGN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.DEGREES);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.RADIANS);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ROUND);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.TRUNCATE);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ASCII);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.INITCAP);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.CHAR_LENGTH);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.CHARACTER_LENGTH);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.LENGTH);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.LOWER);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.UPPER);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.CONCAT);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.SUBSTRING);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.LTRIM);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.RTRIM);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.BTRIM);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.DESC);
    }

    public static interface Resource {
        @Resources.BaseMessage(value="{0}")
        public Resources.ExInst<SqlValidatorException> custom(String var1);

        @Resources.BaseMessage(value="{0} is not supported")
        public Resources.ExInst<SqlValidatorException> notSupported(String var1);
    }
}

