/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical.index;

import com.hazelcast.config.IndexType;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.query.impl.ComparableIdentifiedDataSerializable;
import com.hazelcast.query.impl.CompositeValue;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTrait;
import com.hazelcast.sql.impl.calcite.opt.logical.MapScanLogicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.MapIndexScanPhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.index.IndexComponentCandidate;
import com.hazelcast.sql.impl.calcite.opt.physical.index.IndexComponentFilter;
import com.hazelcast.sql.impl.calcite.opt.physical.index.IndexRexVisitor;
import com.hazelcast.sql.impl.calcite.opt.physical.index.RelCollationComparator;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.RexToExpressionVisitor;
import com.hazelcast.sql.impl.calcite.schema.HazelcastRelOptTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.exec.scan.index.IndexEqualsFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilterValue;
import com.hazelcast.sql.impl.exec.scan.index.IndexInFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexRangeFilter;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;

public final class IndexResolver {
    private IndexResolver() {
    }

    public static Collection<RelNode> createIndexScans(MapScanLogicalRel scan, DistributionTrait distribution, List<MapTableIndex> indexes) {
        RexNode filter = scan.getTableUnwrapped().getFilter();
        ArrayList<MapTableIndex> supportedIndexes = new ArrayList<MapTableIndex>(indexes.size());
        HashSet<Integer> allIndexedFieldOrdinals = new HashSet<Integer>();
        for (MapTableIndex mapTableIndex : indexes) {
            if (!IndexResolver.isIndexSupported(mapTableIndex)) continue;
            supportedIndexes.add(mapTableIndex);
            allIndexedFieldOrdinals.addAll(mapTableIndex.getFieldOrdinals());
        }
        if (supportedIndexes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RelNode> fullScanRels = new ArrayList<RelNode>(supportedIndexes.size());
        for (MapTableIndex index : supportedIndexes) {
            List<Boolean> ascs;
            RelNode relAscending;
            if (index.getType() != IndexType.SORTED || (relAscending = IndexResolver.createFullIndexScan(scan, distribution, index, ascs = IndexResolver.buildFieldDirections(index, true), true)) == null) continue;
            fullScanRels.add(relAscending);
            RelNode relDescending = IndexResolver.replaceCollationDirection(relAscending, RelFieldCollation.Direction.DESCENDING);
            fullScanRels.add(relDescending);
        }
        Map<RelCollation, RelNode> map = IndexResolver.excludeCoveredCollations(fullScanRels);
        if (filter == null) {
            return map.values();
        }
        List<RexNode> conjunctions = IndexResolver.createConjunctiveFilter(filter);
        Map<Integer, List<IndexComponentCandidate>> candidates = IndexResolver.prepareSingleColumnCandidates(conjunctions, OptUtils.getCluster(scan).getParameterMetadata(), allIndexedFieldOrdinals);
        if (candidates.isEmpty()) {
            return map.values();
        }
        ArrayList<RelNode> rels = new ArrayList<RelNode>(supportedIndexes.size());
        for (MapTableIndex index : supportedIndexes) {
            List<Boolean> ascs;
            RelNode relAscending = IndexResolver.createIndexScan(scan, distribution, index, conjunctions, candidates, ascs = IndexResolver.buildFieldDirections(index, true));
            if (relAscending == null) continue;
            RelCollation relAscCollation = IndexResolver.getCollation(relAscending);
            map.remove(relAscCollation);
            rels.add(relAscending);
            if (relAscCollation.getFieldCollations().size() <= 0) continue;
            RelNode relDescending = IndexResolver.replaceCollationDirection(relAscending, RelFieldCollation.Direction.DESCENDING);
            rels.add(relDescending);
            RelCollation relDescCollation = IndexResolver.getCollation(relDescending);
            map.remove(relDescCollation);
        }
        rels.addAll(map.values());
        return rels;
    }

    private static RelCollation getCollation(RelNode rel) {
        return (RelCollation)rel.getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
    }

    private static RelNode replaceCollationDirection(RelNode rel, RelFieldCollation.Direction direction) {
        RelCollation collation = (RelCollation)rel.getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
        ArrayList<RelFieldCollation> newFields = new ArrayList<RelFieldCollation>(collation.getFieldCollations().size());
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            RelFieldCollation newFieldCollation = new RelFieldCollation(fieldCollation.getFieldIndex(), direction);
            newFields.add(newFieldCollation);
        }
        RelCollation newCollation = RelCollations.of(newFields);
        RelTraitSet traitSet = rel.getTraitSet();
        traitSet = OptUtils.traitPlus(traitSet, (RelTrait)newCollation);
        return rel.copy(traitSet, rel.getInputs());
    }

    private static Map<RelCollation, RelNode> excludeCoveredCollations(List<RelNode> rels) {
        TreeMap<RelCollation, RelNode> relsTreeMap = new TreeMap<RelCollation, RelNode>(RelCollationComparator.INSTANCE);
        for (RelNode rel : rels) {
            relsTreeMap.put((RelCollation)rel.getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE), rel);
        }
        HashMap<RelCollation, RelNode> resultMap = new HashMap<RelCollation, RelNode>();
        Map.Entry prevEntry = null;
        for (Map.Entry entry : relsTreeMap.descendingMap().entrySet()) {
            RelCollation collation = (RelCollation)entry.getKey();
            RelNode relNode = (RelNode)entry.getValue();
            if (prevEntry == null) {
                resultMap.put(collation, relNode);
                prevEntry = entry;
                continue;
            }
            RelCollation prevCollation = (RelCollation)prevEntry.getKey();
            if (prevCollation.satisfies((RelTrait)collation)) continue;
            prevEntry = entry;
            resultMap.put(collation, relNode);
        }
        return resultMap;
    }

    private static List<RexNode> createConjunctiveFilter(RexNode filter) {
        ArrayList<RexNode> conjunctions = new ArrayList<RexNode>(1);
        RelOptUtil.decomposeConjunction((RexNode)filter, conjunctions);
        return conjunctions;
    }

    private static Map<Integer, List<IndexComponentCandidate>> prepareSingleColumnCandidates(List<RexNode> expressions, QueryParameterMetadata parameterMetadata, Set<Integer> allIndexedFieldOrdinals) {
        HashMap<Integer, List<IndexComponentCandidate>> res = new HashMap<Integer, List<IndexComponentCandidate>>();
        for (RexNode expression : expressions) {
            IndexComponentCandidate candidate = IndexResolver.prepareSingleColumnCandidate(expression, parameterMetadata);
            if (candidate == null || !allIndexedFieldOrdinals.contains(candidate.getColumnIndex())) continue;
            res.computeIfAbsent(candidate.getColumnIndex(), k -> new ArrayList()).add(candidate);
        }
        return res;
    }

    private static IndexComponentCandidate prepareSingleColumnCandidate(RexNode exp, QueryParameterMetadata parameterMetadata) {
        SqlKind kind = exp.getKind();
        switch (kind) {
            case IS_TRUE: 
            case IS_FALSE: 
            case IS_NOT_TRUE: 
            case IS_NOT_FALSE: {
                return IndexResolver.prepareSingleColumnCandidateBooleanIsTrueFalse(exp, IndexResolver.removeCastIfPossible((RexNode)((RexCall)exp).getOperands().get(0)), kind);
            }
            case INPUT_REF: {
                return IndexResolver.prepareSingleColumnCandidateBooleanIsTrueFalse(exp, exp, SqlKind.IS_TRUE);
            }
            case NOT: {
                return IndexResolver.prepareSingleColumnCandidateBooleanIsTrueFalse(exp, IndexResolver.removeCastIfPossible((RexNode)((RexCall)exp).getOperands().get(0)), SqlKind.IS_FALSE);
            }
            case IS_NULL: {
                return IndexResolver.prepareSingleColumnCandidateIsNull(exp, IndexResolver.removeCastIfPossible((RexNode)((RexCall)exp).getOperands().get(0)));
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case EQUALS: {
                BiTuple<RexNode, RexNode> operands = IndexResolver.extractComparisonOperands(exp);
                return IndexResolver.prepareSingleColumnCandidateComparison(exp, kind, (RexNode)operands.element1(), (RexNode)operands.element2(), parameterMetadata);
            }
            case OR: {
                return IndexResolver.prepareSingleColumnCandidateOr(exp, ((RexCall)exp).getOperands(), parameterMetadata);
            }
        }
        return null;
    }

    private static IndexComponentCandidate prepareSingleColumnCandidateBooleanIsTrueFalse(RexNode exp, RexNode operand, SqlKind kind) {
        IndexEqualsFilter filter;
        if (operand.getKind() != SqlKind.INPUT_REF) {
            return null;
        }
        if (operand.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
            return null;
        }
        int columnIndex = ((RexInputRef)operand).getIndex();
        switch (kind) {
            case IS_TRUE: {
                filter = new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create((Object)true, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(false)));
                break;
            }
            case IS_FALSE: {
                filter = new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create((Object)false, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(false)));
                break;
            }
            case IS_NOT_TRUE: {
                filter = new IndexInFilter(new IndexFilter[]{new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create((Object)false, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(false))), new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create(null, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(true)))});
                break;
            }
            default: {
                assert (kind == SqlKind.IS_NOT_FALSE);
                filter = new IndexInFilter(new IndexFilter[]{new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create((Object)true, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(false))), new IndexEqualsFilter(new IndexFilterValue(Collections.singletonList(ConstantExpression.create(null, (QueryDataType)QueryDataType.BOOLEAN)), Collections.singletonList(true)))});
            }
        }
        return new IndexComponentCandidate(exp, columnIndex, (IndexFilter)filter);
    }

    private static IndexComponentCandidate prepareSingleColumnCandidateIsNull(RexNode exp, RexNode operand) {
        if (operand.getKind() != SqlKind.INPUT_REF) {
            return null;
        }
        int columnIndex = ((RexInputRef)operand).getIndex();
        QueryDataType type = HazelcastTypeUtils.toHazelcastType(operand.getType().getSqlTypeName());
        IndexFilterValue filterValue = new IndexFilterValue(Collections.singletonList(ConstantExpression.create(null, (QueryDataType)type)), Collections.singletonList(true));
        IndexEqualsFilter filter = new IndexEqualsFilter(filterValue);
        return new IndexComponentCandidate(exp, columnIndex, (IndexFilter)filter);
    }

    private static IndexComponentCandidate prepareSingleColumnCandidateComparison(RexNode exp, SqlKind kind, RexNode operand1, RexNode operand2, QueryParameterMetadata parameterMetadata) {
        IndexEqualsFilter filter;
        if (operand1.getKind() != SqlKind.INPUT_REF && operand2.getKind() == SqlKind.INPUT_REF) {
            kind = IndexResolver.inverseIndexConditionKind(kind);
            RexNode tmp = operand1;
            operand1 = operand2;
            operand2 = tmp;
        }
        if (operand1.getKind() != SqlKind.INPUT_REF) {
            return null;
        }
        int columnIndex = ((RexInputRef)operand1).getIndex();
        if (!IndexRexVisitor.isValid(operand2)) {
            return null;
        }
        Expression<?> filterValue = IndexResolver.convertToExpression(operand2, parameterMetadata);
        if (filterValue == null) {
            return null;
        }
        IndexFilterValue filterValue0 = new IndexFilterValue(Collections.singletonList(filterValue), Collections.singletonList(false));
        switch (kind) {
            case EQUALS: {
                filter = new IndexEqualsFilter(filterValue0);
                break;
            }
            case GREATER_THAN: {
                filter = new IndexRangeFilter(filterValue0, false, null, false);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filter = new IndexRangeFilter(filterValue0, true, null, false);
                break;
            }
            case LESS_THAN: {
                filter = new IndexRangeFilter(null, false, filterValue0, false);
                break;
            }
            default: {
                assert (kind == SqlKind.LESS_THAN_OR_EQUAL);
                filter = new IndexRangeFilter(null, false, filterValue0, true);
            }
        }
        return new IndexComponentCandidate(exp, columnIndex, (IndexFilter)filter);
    }

    private static Expression<?> convertToExpression(RexNode operand, QueryParameterMetadata parameterMetadata) {
        try {
            RexToExpressionVisitor visitor = new RexToExpressionVisitor(FieldTypeProvider.INSTANCE, parameterMetadata);
            return (Expression)operand.accept((RexVisitor)visitor);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static IndexComponentCandidate prepareSingleColumnCandidateOr(RexNode exp, List<RexNode> nodes, QueryParameterMetadata parameterMetadata) {
        Integer columnIndex = null;
        ArrayList<IndexFilter> filters = new ArrayList<IndexFilter>();
        for (RexNode node : nodes) {
            IndexComponentCandidate candidate = IndexResolver.prepareSingleColumnCandidate(node, parameterMetadata);
            if (candidate == null) {
                return null;
            }
            IndexFilter candidateFilter = candidate.getFilter();
            if (!(candidateFilter instanceof IndexEqualsFilter) && !(candidateFilter instanceof IndexInFilter)) {
                return null;
            }
            if (columnIndex == null) {
                columnIndex = candidate.getColumnIndex();
            } else if (columnIndex.intValue() != candidate.getColumnIndex()) {
                return null;
            }
            if (candidateFilter instanceof IndexEqualsFilter) {
                filters.add(candidateFilter);
                continue;
            }
            filters.addAll(((IndexInFilter)candidateFilter).getFilters());
        }
        assert (columnIndex != null);
        IndexInFilter inFilter = new IndexInFilter(filters);
        return new IndexComponentCandidate(exp, columnIndex, (IndexFilter)inFilter);
    }

    public static RelNode createIndexScan(MapScanLogicalRel scan, DistributionTrait distribution, MapTableIndex index, List<RexNode> conjunctions, Map<Integer, List<IndexComponentCandidate>> candidates, List<Boolean> ascs) {
        ArrayList<IndexComponentFilter> filters = new ArrayList<IndexComponentFilter>(index.getFieldOrdinals().size());
        for (int i = 0; i < index.getFieldOrdinals().size(); ++i) {
            IndexComponentFilter filter;
            int fieldOrdinal = (Integer)index.getFieldOrdinals().get(i);
            QueryDataType fieldConverterType = (QueryDataType)index.getFieldConverterTypes().get(i);
            List<IndexComponentCandidate> fieldCandidates = candidates.get(fieldOrdinal);
            if (fieldCandidates == null || (filter = IndexResolver.selectComponentFilter(index.getType(), fieldCandidates, fieldConverterType)) == null) break;
            filters.add(filter);
            if (!(filter.getFilter() instanceof IndexEqualsFilter)) break;
        }
        if (filters.isEmpty()) {
            return null;
        }
        return IndexResolver.createIndexScan(scan, distribution, index, conjunctions, filters, ascs);
    }

    private static MapIndexScanPhysicalRel createIndexScan(MapScanLogicalRel scan, DistributionTrait distribution, MapTableIndex index, List<RexNode> conjunctions, List<IndexComponentFilter> filterDescriptors, List<Boolean> ascs) {
        ArrayList<IndexFilter> filters = new ArrayList<IndexFilter>(filterDescriptors.size());
        ArrayList<QueryDataType> converterTypes = new ArrayList<QueryDataType>(filterDescriptors.size());
        HashSet<RexNode> exps = new HashSet<RexNode>();
        for (IndexComponentFilter filterDescriptor : filterDescriptors) {
            filters.add(filterDescriptor.getFilter());
            converterTypes.add(filterDescriptor.getConverterType());
            exps.addAll(filterDescriptor.getExpressions());
        }
        RexBuilder rexBuilder = scan.getCluster().getRexBuilder();
        RexNode exp = RexUtil.composeConjunction((RexBuilder)rexBuilder, exps);
        List<RexNode> remainderConjunctiveExps = IndexResolver.excludeNodes(conjunctions, exps);
        RexNode remainderExp = remainderConjunctiveExps.isEmpty() ? null : RexUtil.composeConjunction((RexBuilder)rexBuilder, remainderConjunctiveExps);
        RelTraitSet traitSet = OptUtils.toPhysicalConvention(scan.getTraitSet(), distribution);
        RelCollation relCollation = IndexResolver.buildCollationTrait(scan, index, ascs);
        traitSet = OptUtils.traitPlus(traitSet, (RelTrait)relCollation);
        HazelcastRelOptTable originalRelTable = (HazelcastRelOptTable)scan.getTable();
        HazelcastTable originalHazelcastTable = OptUtils.getHazelcastTable(scan);
        HazelcastRelOptTable newRelTable = OptUtils.createRelTable(originalRelTable, originalHazelcastTable.withFilter(null), scan.getCluster().getTypeFactory());
        IndexFilter filter = IndexResolver.composeFilter(filters, index.getType(), index.getComponentsCount());
        if (filter == null) {
            return null;
        }
        return new MapIndexScanPhysicalRel(scan.getCluster(), traitSet, (RelOptTable)newRelTable, index, filter, converterTypes, exp, remainderExp);
    }

    private static RelCollation buildCollationTrait(MapScanLogicalRel scan, MapTableIndex index, List<Boolean> ascs) {
        if (index.getType() != IndexType.SORTED) {
            return RelCollations.of(Collections.emptyList());
        }
        ArrayList<RelFieldCollation> fields = new ArrayList<RelFieldCollation>(index.getFieldOrdinals().size());
        HazelcastTable table = scan.getTableUnwrapped();
        for (int i = 0; i < index.getFieldOrdinals().size(); ++i) {
            Integer indexFieldOrdinal = (Integer)index.getFieldOrdinals().get(i);
            int remappedIndexFieldOrdinal = table.getProjects().indexOf(indexFieldOrdinal);
            if (remappedIndexFieldOrdinal == -1) break;
            RelFieldCollation.Direction direction = ascs.get(i) != false ? RelFieldCollation.Direction.ASCENDING : RelFieldCollation.Direction.DESCENDING;
            RelFieldCollation fieldCollation = new RelFieldCollation(remappedIndexFieldOrdinal, direction);
            fields.add(fieldCollation);
        }
        return RelCollations.of(fields);
    }

    private static List<Boolean> buildFieldDirections(MapTableIndex index, boolean allAscending) {
        ArrayList<Boolean> ascs = new ArrayList<Boolean>(index.getFieldOrdinals().size());
        for (int i = 0; i < index.getFieldOrdinals().size(); ++i) {
            Boolean asc = allAscending ? Boolean.TRUE : Boolean.FALSE;
            ascs.add(asc);
        }
        return ascs;
    }

    private static RelNode createFullIndexScan(MapScanLogicalRel scan, DistributionTrait distribution, MapTableIndex index, List<Boolean> ascs, boolean nonEmptyCollation) {
        assert (IndexResolver.isIndexSupported(index));
        RexNode scanFilter = scan.getTableUnwrapped().getFilter();
        RelTraitSet traitSet = OptUtils.toPhysicalConvention(scan.getTraitSet(), distribution);
        RelCollation relCollation = IndexResolver.buildCollationTrait(scan, index, ascs);
        if (nonEmptyCollation && relCollation.getFieldCollations().size() == 0) {
            return null;
        }
        traitSet = OptUtils.traitPlus(traitSet, (RelTrait)relCollation);
        HazelcastRelOptTable originalRelTable = (HazelcastRelOptTable)scan.getTable();
        HazelcastTable originalHazelcastTable = OptUtils.getHazelcastTable(scan);
        HazelcastRelOptTable newRelTable = OptUtils.createRelTable(originalRelTable, originalHazelcastTable.withFilter(null), scan.getCluster().getTypeFactory());
        return new MapIndexScanPhysicalRel(scan.getCluster(), traitSet, (RelOptTable)newRelTable, index, null, Collections.emptyList(), null, scanFilter);
    }

    public static RelNode createFullIndexScan(MapScanLogicalRel scan, DistributionTrait distribution, List<MapTableIndex> indexes) {
        MapTableIndex firstIndex = null;
        for (MapTableIndex index : indexes) {
            if (!IndexResolver.isIndexSupported(index)) continue;
            firstIndex = index;
            break;
        }
        if (firstIndex == null) {
            return null;
        }
        List<Boolean> ascs = IndexResolver.buildFieldDirections(firstIndex, true);
        return IndexResolver.createFullIndexScan(scan, distribution, firstIndex, ascs, false);
    }

    private static IndexComponentFilter selectComponentFilter(IndexType type, List<IndexComponentCandidate> candidates, QueryDataType converterType) {
        for (IndexComponentCandidate candidate : candidates) {
            if (!(candidate.getFilter() instanceof IndexEqualsFilter)) continue;
            return new IndexComponentFilter(candidate.getFilter(), Collections.singletonList(candidate.getExpression()), converterType);
        }
        for (IndexComponentCandidate candidate : candidates) {
            if (!(candidate.getFilter() instanceof IndexInFilter)) continue;
            return new IndexComponentFilter(candidate.getFilter(), Collections.singletonList(candidate.getExpression()), converterType);
        }
        if (type == IndexType.SORTED) {
            IndexFilterValue from = null;
            boolean fromInclusive = false;
            IndexFilterValue to = null;
            boolean toInclusive = false;
            ArrayList<RexNode> expressions = new ArrayList<RexNode>(2);
            for (IndexComponentCandidate candidate : candidates) {
                if (!(candidate.getFilter() instanceof IndexRangeFilter)) continue;
                IndexRangeFilter candidateFilter = (IndexRangeFilter)candidate.getFilter();
                if (from == null && candidateFilter.getFrom() != null) {
                    from = candidateFilter.getFrom();
                    fromInclusive = candidateFilter.isFromInclusive();
                    expressions.add(candidate.getExpression());
                    continue;
                }
                if (to != null || candidateFilter.getTo() == null) continue;
                to = candidateFilter.getTo();
                toInclusive = candidateFilter.isToInclusive();
                expressions.add(candidate.getExpression());
            }
            if (from != null || to != null) {
                IndexRangeFilter filter = new IndexRangeFilter(from, fromInclusive, to, toInclusive);
                return new IndexComponentFilter((IndexFilter)filter, expressions, converterType);
            }
        }
        return null;
    }

    private static IndexFilter composeFilter(List<IndexFilter> filters, IndexType indexType, int indexComponentsCount) {
        assert (!filters.isEmpty());
        if (indexComponentsCount == 1) {
            assert (filters.size() == 1);
            IndexFilter res = filters.get(0);
            assert (!(res instanceof IndexRangeFilter) || indexType == IndexType.SORTED);
            return res;
        }
        IndexFilter lastFilter = filters.get(filters.size() - 1);
        if (lastFilter instanceof IndexEqualsFilter) {
            return IndexResolver.composeEqualsFilter(filters, (IndexEqualsFilter)lastFilter, indexType, indexComponentsCount);
        }
        if (lastFilter instanceof IndexInFilter) {
            return IndexResolver.composeInFilter(filters, (IndexInFilter)lastFilter, indexType, indexComponentsCount);
        }
        assert (lastFilter instanceof IndexRangeFilter);
        assert (indexType == IndexType.SORTED);
        return IndexResolver.composeRangeFilter(filters, (IndexRangeFilter)lastFilter, indexComponentsCount);
    }

    private static IndexFilter composeEqualsFilter(List<IndexFilter> filters, IndexEqualsFilter lastFilter, IndexType indexType, int indexComponentsCount) {
        ArrayList<Expression> components = new ArrayList<Expression>(filters.size());
        ArrayList<Boolean> allowNulls = new ArrayList<Boolean>(filters.size());
        IndexResolver.fillNonTerminalComponents(filters, components, allowNulls);
        components.addAll(lastFilter.getValue().getComponents());
        allowNulls.addAll(lastFilter.getValue().getAllowNulls());
        if (indexComponentsCount == components.size()) {
            return new IndexEqualsFilter(new IndexFilterValue(components, allowNulls));
        }
        if (indexType == IndexType.HASH) {
            return null;
        }
        ArrayList<Expression> fromComponents = components;
        ArrayList<Expression> toComponents = new ArrayList<Expression>(components);
        ArrayList<Boolean> fromAllowNulls = allowNulls;
        ArrayList<Boolean> toAllowNulls = new ArrayList<Boolean>(fromAllowNulls);
        IndexResolver.addInfiniteRanges(fromComponents, fromAllowNulls, true, toComponents, toAllowNulls, true, indexComponentsCount);
        return new IndexRangeFilter(new IndexFilterValue(fromComponents, fromAllowNulls), true, new IndexFilterValue(toComponents, toAllowNulls), true);
    }

    private static IndexFilter composeInFilter(List<IndexFilter> filters, IndexInFilter lastFilter, IndexType indexType, int indexComponentsCount) {
        ArrayList<IndexFilter> newFilters = new ArrayList<IndexFilter>(lastFilter.getFilters().size());
        for (IndexFilter filter : lastFilter.getFilters()) {
            assert (filter instanceof IndexEqualsFilter);
            IndexFilter newFilter = IndexResolver.composeEqualsFilter(filters, (IndexEqualsFilter)filter, indexType, indexComponentsCount);
            if (newFilter == null) {
                return null;
            }
            newFilters.add(newFilter);
        }
        return new IndexInFilter(newFilters);
    }

    private static IndexFilter composeRangeFilter(List<IndexFilter> filters, IndexRangeFilter lastFilter, int componentsCount) {
        ArrayList<Expression> components = new ArrayList<Expression>(filters.size());
        ArrayList<Boolean> allowNulls = new ArrayList<Boolean>();
        IndexResolver.fillNonTerminalComponents(filters, components, allowNulls);
        ArrayList<Expression> fromComponents = components;
        ArrayList<Expression> toComponents = new ArrayList<Expression>(components);
        ArrayList<Boolean> fromAllowNulls = allowNulls;
        ArrayList<Boolean> toAllowNulls = new ArrayList<Boolean>(fromAllowNulls);
        if (lastFilter.getFrom() != null) {
            fromComponents.add((Expression)lastFilter.getFrom().getComponents().get(0));
            fromAllowNulls.add(false);
        } else if (componentsCount == 1) {
            fromComponents.add((Expression)ConstantExpression.create((Object)CompositeValue.NEGATIVE_INFINITY, (QueryDataType)QueryDataType.OBJECT));
            fromAllowNulls.add(false);
        } else {
            fromComponents.add((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.OBJECT));
            fromAllowNulls.add(true);
        }
        if (lastFilter.getTo() != null) {
            toComponents.add((Expression)lastFilter.getTo().getComponents().get(0));
        } else {
            toComponents.add((Expression)ConstantExpression.create((Object)CompositeValue.POSITIVE_INFINITY, (QueryDataType)QueryDataType.OBJECT));
        }
        toAllowNulls.add(false);
        IndexResolver.addInfiniteRanges(fromComponents, fromAllowNulls, lastFilter.isFromInclusive(), toComponents, toAllowNulls, lastFilter.isToInclusive(), componentsCount);
        return new IndexRangeFilter(new IndexFilterValue(fromComponents, fromAllowNulls), lastFilter.isFromInclusive(), new IndexFilterValue(toComponents, toAllowNulls), lastFilter.isToInclusive());
    }

    private static void fillNonTerminalComponents(List<IndexFilter> filters, List<Expression> components, List<Boolean> allowNulls) {
        for (int i = 0; i < filters.size() - 1; ++i) {
            IndexEqualsFilter filter0 = (IndexEqualsFilter)filters.get(i);
            IndexFilterValue value = filter0.getValue();
            assert (value.getComponents().size() == 1);
            components.add((Expression)value.getComponents().get(0));
            allowNulls.add((Boolean)value.getAllowNulls().get(0));
        }
        assert (components.size() == filters.size() - 1);
        assert (allowNulls.size() == filters.size() - 1);
    }

    private static void addInfiniteRanges(List<Expression> fromComponents, List<Boolean> fromAllowNulls, boolean fromInclusive, List<Expression> toComponents, List<Boolean> toAllowNulls, boolean toInclusive, int componentsCount) {
        int count = componentsCount - fromComponents.size();
        ComparableIdentifiedDataSerializable leftBound = fromInclusive ? CompositeValue.NEGATIVE_INFINITY : CompositeValue.POSITIVE_INFINITY;
        ComparableIdentifiedDataSerializable toBound = toInclusive ? CompositeValue.POSITIVE_INFINITY : CompositeValue.NEGATIVE_INFINITY;
        for (int i = 0; i < count; ++i) {
            fromComponents.add((Expression)ConstantExpression.create((Object)leftBound, (QueryDataType)QueryDataType.OBJECT));
            toComponents.add((Expression)ConstantExpression.create((Object)toBound, (QueryDataType)QueryDataType.OBJECT));
            fromAllowNulls.add(false);
            toAllowNulls.add(false);
        }
    }

    private static SqlKind inverseIndexConditionKind(SqlKind kind) {
        switch (kind) {
            case GREATER_THAN: {
                return SqlKind.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlKind.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlKind.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlKind.GREATER_THAN_OR_EQUAL;
            }
        }
        assert (kind == SqlKind.EQUALS);
        return kind;
    }

    private static boolean isIndexSupported(MapTableIndex index) {
        return index.getType() == IndexType.SORTED || index.getType() == IndexType.HASH;
    }

    private static BiTuple<RexNode, RexNode> extractComparisonOperands(RexNode node) {
        assert (node instanceof RexCall);
        RexCall node0 = (RexCall)node;
        assert (node0.getOperands().size() == 2);
        RexNode operand1 = (RexNode)node0.getOperands().get(0);
        RexNode operand2 = (RexNode)node0.getOperands().get(1);
        RexNode normalizedOperand1 = IndexResolver.removeCastIfPossible(operand1);
        RexNode normalizedOperand2 = IndexResolver.removeCastIfPossible(operand2);
        return BiTuple.of((Object)normalizedOperand1, (Object)normalizedOperand2);
    }

    private static RexNode removeCastIfPossible(RexNode node) {
        RexCall node0;
        RexNode from;
        if (node.getKind() == SqlKind.CAST && (from = (RexNode)(node0 = (RexCall)node).getOperands().get(0)) instanceof RexInputRef) {
            RelDataType toType;
            RelDataType fromType = from.getType();
            if (fromType.equals(toType = node0.getType())) {
                return from;
            }
            QueryDataTypeFamily fromFamily = HazelcastTypeUtils.toHazelcastType(fromType.getSqlTypeName()).getTypeFamily();
            QueryDataTypeFamily toFamily = HazelcastTypeUtils.toHazelcastType(toType.getSqlTypeName()).getTypeFamily();
            if (QueryDataTypeUtils.isNumeric((QueryDataTypeFamily)fromFamily) && QueryDataTypeUtils.isNumeric((QueryDataTypeFamily)toFamily) && toFamily.getPrecedence() > fromFamily.getPrecedence()) {
                return from;
            }
        }
        return node;
    }

    private static List<RexNode> excludeNodes(Collection<RexNode> nodes, Set<RexNode> exclusions) {
        ArrayList<RexNode> res = new ArrayList<RexNode>(nodes.size());
        for (RexNode node : nodes) {
            if (exclusions.contains(node)) continue;
            res.add(node);
        }
        return res;
    }

    private static final class FieldTypeProvider
    implements PlanNodeFieldTypeProvider {
        private static final FieldTypeProvider INSTANCE = new FieldTypeProvider();

        private FieldTypeProvider() {
        }

        public QueryDataType getType(int index) {
            throw new IllegalStateException("The operation should not be called.");
        }
    }
}

