/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite;

import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastRexBuilder
extends RexBuilder {
    public HazelcastRexBuilder(HazelcastTypeFactory typeFactory) {
        super((RelDataTypeFactory)typeFactory);
    }

    public RexNode makeLiteral(Object value, RelDataType type, boolean allowCast) {
        Converter converter;
        if (type.getSqlTypeName() == SqlTypeName.ANY && value instanceof Number && (converter = Converters.getConverter(value.getClass())) != null) {
            QueryDataTypeFamily typeFamily = converter.getTypeFamily();
            if (typeFamily.isNumericInteger()) {
                int bitWidth = HazelcastIntegerType.bitWidthOf(((Number)value).longValue());
                type = HazelcastIntegerType.create(bitWidth, false);
            } else {
                SqlTypeName typeName = HazelcastTypeUtils.toCalciteType(typeFamily);
                type = HazelcastTypeFactory.INSTANCE.createSqlType(typeName);
            }
        }
        return super.makeLiteral(value, type, allowCast);
    }
}

