/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operand;

import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.operand.AbstractOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.param.NumericPrecedenceParameterConverter;
import com.hazelcast.sql.impl.calcite.validate.param.StrictParameterConverter;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;

public final class TypedOperandChecker
extends AbstractOperandChecker {
    public static final TypedOperandChecker BOOLEAN = new TypedOperandChecker(SqlTypeName.BOOLEAN);
    public static final TypedOperandChecker VARCHAR = new TypedOperandChecker(SqlTypeName.VARCHAR);
    public static final TypedOperandChecker TINYINT = new TypedOperandChecker(SqlTypeName.TINYINT);
    public static final TypedOperandChecker SMALLINT = new TypedOperandChecker(SqlTypeName.SMALLINT);
    public static final TypedOperandChecker INTEGER = new TypedOperandChecker(SqlTypeName.INTEGER);
    public static final TypedOperandChecker BIGINT = new TypedOperandChecker(SqlTypeName.BIGINT);
    public static final TypedOperandChecker DECIMAL = new TypedOperandChecker(SqlTypeName.DECIMAL);
    public static final TypedOperandChecker REAL = new TypedOperandChecker(SqlTypeName.REAL);
    public static final TypedOperandChecker DOUBLE = new TypedOperandChecker(SqlTypeName.DOUBLE);
    private final SqlTypeName typeName;
    private final RelDataType type;

    private TypedOperandChecker(SqlTypeName typeName) {
        this.typeName = typeName;
        this.type = null;
    }

    private TypedOperandChecker(RelDataType type) {
        this.typeName = type.getSqlTypeName();
        this.type = type;
    }

    public static TypedOperandChecker forType(RelDataType type) {
        return new TypedOperandChecker(type);
    }

    @Override
    protected boolean matchesTargetType(RelDataType operandType) {
        if (this.type != null) {
            return this.type.equals(operandType);
        }
        return operandType.getSqlTypeName() == this.typeName;
    }

    @Override
    protected RelDataType getTargetType(RelDataTypeFactory factory, boolean nullable) {
        if (this.type != null) {
            return factory.createTypeWithNullability(this.type, nullable);
        }
        return HazelcastTypeUtils.createType(factory, this.typeName, nullable);
    }

    @Override
    protected boolean coerce(HazelcastSqlValidator validator, HazelcastCallBinding callBinding, SqlNode operand, RelDataType operandType, int operandIndex) {
        QueryDataType targetType0 = this.getTargetHazelcastType();
        QueryDataType operandType0 = HazelcastTypeUtils.toHazelcastType(operandType.getSqlTypeName());
        if (!this.isNumeric() || !operandType0.getTypeFamily().isNumeric()) {
            return false;
        }
        if (targetType0.getTypeFamily().getPrecedence() < operandType0.getTypeFamily().getPrecedence()) {
            return false;
        }
        RelDataType newOperandType = this.getTargetType(validator.getTypeFactory(), operandType.isNullable());
        validator.getTypeCoercion().coerceOperandType(callBinding.getScope(), callBinding.getCall(), operandIndex, newOperandType);
        return true;
    }

    @Override
    protected ParameterConverter parameterConverter(SqlDynamicParam operand) {
        QueryDataType hazelcastType = this.getTargetHazelcastType();
        if (this.isNumeric()) {
            return new NumericPrecedenceParameterConverter(operand.getIndex(), operand.getParserPosition(), hazelcastType);
        }
        return new StrictParameterConverter(operand.getIndex(), operand.getParserPosition(), hazelcastType);
    }

    private QueryDataType getTargetHazelcastType() {
        return HazelcastTypeUtils.toHazelcastType(this.typeName);
    }

    public boolean isNumeric() {
        return this.getTargetHazelcastType().getTypeFamily().isNumeric();
    }
}

