/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical;

import com.google.common.collect.ImmutableList;
import com.hazelcast.sql.impl.calcite.opt.HazelcastConventions;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTrait;
import com.hazelcast.sql.impl.calcite.opt.logical.ValuesLogicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.ValuesPhysicalRel;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexLiteral;

public final class ValuesPhysicalRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new ValuesPhysicalRule();

    private ValuesPhysicalRule() {
        super(OptUtils.single(ValuesLogicalRel.class, HazelcastConventions.LOGICAL), ValuesPhysicalRule.class.getSimpleName());
    }

    public void onMatch(RelOptRuleCall call) {
        ValuesLogicalRel logicalValues = (ValuesLogicalRel)call.rel(0);
        DistributionTrait distribution = logicalValues.getHazelcastCluster().getDistributionTraitDef().getTraitReplicated();
        ValuesPhysicalRel transformedValues = new ValuesPhysicalRel(logicalValues.getCluster(), logicalValues.getRowType(), (ImmutableList<ImmutableList<RexLiteral>>)logicalValues.getTuples(), OptUtils.toPhysicalConvention(logicalValues.getTraitSet(), distribution));
        call.transformTo((RelNode)transformedValues);
    }
}

