/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.distribution;

import com.hazelcast.sql.impl.calcite.opt.HazelcastConventions;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTrait;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionType;
import com.hazelcast.sql.impl.calcite.opt.physical.exchange.RootExchangePhysicalRel;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;

public class DistributionTraitDef
extends RelTraitDef<DistributionTrait> {
    private final DistributionTrait traitPartitionedUnknown;
    private final DistributionTrait traitReplicated;
    private final DistributionTrait traitRoot;
    private final DistributionTrait traitAny;
    private final int memberCount;

    public DistributionTraitDef(int memberCount) {
        this.memberCount = memberCount;
        this.traitPartitionedUnknown = this.createTrait(DistributionType.PARTITIONED);
        this.traitReplicated = this.createTrait(DistributionType.REPLICATED);
        this.traitRoot = this.createTrait(DistributionType.ROOT);
        this.traitAny = this.createTrait(DistributionType.ANY);
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public DistributionTrait getTraitPartitionedUnknown() {
        return this.traitPartitionedUnknown;
    }

    public DistributionTrait getTraitReplicated() {
        return this.traitReplicated;
    }

    public DistributionTrait getTraitRoot() {
        return this.traitRoot;
    }

    public Class<DistributionTrait> getTraitClass() {
        return DistributionTrait.class;
    }

    public String getSimpleName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public RelNode convert(RelOptPlanner planner, RelNode rel, DistributionTrait targetTrait, boolean allowInfiniteCostConverters) {
        DistributionTrait currentTrait = OptUtils.getDistribution(rel);
        if (currentTrait.satisfies(targetTrait)) {
            return rel;
        }
        DistributionType currentType = currentTrait.getType();
        DistributionType targetType = targetTrait.getType();
        if (currentType == DistributionType.ANY) {
            return null;
        }
        if (rel.getConvention() != HazelcastConventions.PHYSICAL) {
            return null;
        }
        switch (targetType) {
            case ANY: {
                return rel;
            }
            case ROOT: {
                return this.convertToRoot(planner, rel, currentTrait);
            }
        }
        return null;
    }

    private RelNode convertToRoot(RelOptPlanner planner, RelNode rel, DistributionTrait currentTrait) {
        assert (currentTrait.getType() == DistributionType.PARTITIONED);
        RelCollation collation = (RelCollation)rel.getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
        RelTraitSet traitSet = OptUtils.traitPlus(planner.emptyTraitSet(), this.getTraitRoot(), (RelTrait)collation);
        return new RootExchangePhysicalRel(rel.getCluster(), OptUtils.toPhysicalConvention(traitSet), rel);
    }

    public boolean canConvert(RelOptPlanner planner, DistributionTrait fromTrait, DistributionTrait toTrait) {
        return true;
    }

    public DistributionTrait getDefault() {
        return this.traitAny;
    }

    private DistributionTrait createTrait(DistributionType type) {
        return new DistributionTrait(this, type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DistributionTraitDef that = (DistributionTraitDef)((Object)o);
        return this.memberCount == that.memberCount;
    }

    public int hashCode() {
        return this.memberCount;
    }

    public String toString() {
        return "DistributionTraitDef {memberCount=" + this.memberCount + '}';
    }
}

