/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;

public class ReplaceUnknownOperandTypeInference
implements SqlOperandTypeInference {
    private final SqlTypeName[] typeNames;
    private final SqlTypeName defaultTypeName;

    public ReplaceUnknownOperandTypeInference(SqlTypeName[] typeNames) {
        this(typeNames, null);
    }

    public ReplaceUnknownOperandTypeInference(SqlTypeName defaultTypeName) {
        this(null, defaultTypeName);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ReplaceUnknownOperandTypeInference(SqlTypeName[] typeNames, SqlTypeName defaultTypeName) {
        this.typeNames = typeNames;
        this.defaultTypeName = defaultTypeName;
    }

    public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
        RelDataType unknownType = callBinding.getTypeFactory().createUnknownType();
        for (int i = 0; i < operandTypes.length; ++i) {
            RelDataType newOperandType;
            RelDataType operandType = operandTypes[i];
            if (!operandType.equals(unknownType) || (newOperandType = this.operandType(i, callBinding.getTypeFactory())) == null) continue;
            operandTypes[i] = newOperandType;
        }
    }

    private RelDataType operandType(int index, RelDataTypeFactory typeFactory) {
        SqlTypeName typeName = null;
        if (this.typeNames != null && index < this.typeNames.length) {
            typeName = this.typeNames[index];
        }
        if (typeName == null) {
            typeName = this.defaultTypeName;
        }
        if (typeName != null) {
            return typeFactory.createSqlType(typeName);
        }
        return null;
    }
}

