/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical;

import com.hazelcast.sql.impl.calcite.opt.AbstractMapScanRel;
import com.hazelcast.sql.impl.calcite.opt.cost.CostUtils;
import com.hazelcast.sql.impl.calcite.opt.physical.PhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.PhysicalRelVisitor;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;

public class MapIndexScanPhysicalRel
extends AbstractMapScanRel
implements PhysicalRel {
    private final MapTableIndex index;
    private final IndexFilter indexFilter;
    private final List<QueryDataType> converterTypes;
    private final RexNode indexExp;
    private final RexNode remainderExp;

    public MapIndexScanPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, MapTableIndex index, IndexFilter indexFilter, List<QueryDataType> converterTypes, RexNode indexExp, RexNode remainderExp) {
        super(cluster, traitSet, table);
        this.index = index;
        this.indexFilter = indexFilter;
        this.converterTypes = converterTypes;
        this.indexExp = indexExp;
        this.remainderExp = remainderExp;
    }

    public MapTableIndex getIndex() {
        return this.index;
    }

    public IndexFilter getIndexFilter() {
        return this.indexFilter;
    }

    public List<QueryDataType> getConverterTypes() {
        return this.converterTypes;
    }

    public RexNode getRemainderExp() {
        return this.remainderExp;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new MapIndexScanPhysicalRel(this.getCluster(), traitSet, this.getTable(), this.index, this.indexFilter, this.converterTypes, this.indexExp, this.remainderExp);
    }

    @Override
    public void visit(PhysicalRelVisitor visitor) {
        visitor.onMapIndexScan(this);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("index", (Object)this.index.getName()).item("indexExp", (Object)this.indexExp).item("remainderExp", (Object)this.remainderExp);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        double rowCount = this.table.getRowCount();
        if (this.indexExp != null) {
            rowCount = CostUtils.adjustFilteredRowCount(rowCount, RelMdUtil.guessSelectivity((RexNode)this.indexExp));
        }
        if (this.remainderExp != null) {
            rowCount = CostUtils.adjustFilteredRowCount(rowCount, RelMdUtil.guessSelectivity((RexNode)this.remainderExp));
        }
        return rowCount;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double scanRowCount = this.table.getRowCount();
        if (this.indexExp != null) {
            scanRowCount = CostUtils.adjustFilteredRowCount(scanRowCount, RelMdUtil.guessSelectivity((RexNode)this.indexExp));
        }
        boolean hasFilter = this.remainderExp != null;
        double filterRowCount = scanRowCount;
        if (hasFilter) {
            filterRowCount = CostUtils.adjustFilteredRowCount(filterRowCount, RelMdUtil.guessSelectivity((RexNode)this.remainderExp));
        }
        return this.computeSelfCost(planner, scanRowCount, CostUtils.indexScanCpuMultiplier(this.index.getType()), hasFilter, filterRowCount, this.getTableUnwrapped().getProjects().size());
    }
}

