/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spring.ExposeHazelcastObjects;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public final class HazelcastExposeObjectRegistrar
implements ImportBeanDefinitionRegistrar {
    private final ILogger logger = Logger.getLogger(HazelcastExposeObjectRegistrar.class);
    private final BeanFactory beanFactory;

    public HazelcastExposeObjectRegistrar(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void registerBeanDefinitions(@Nonnull AnnotationMetadata importingClassMetadata, @Nonnull BeanDefinitionRegistry registry) {
        ExposeHazelcastObjects.Configuration annotatedConfiguration = ExposeHazelcastObjects.Configuration.toConfiguration(importingClassMetadata);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Registering additional ExposeHazelcastObjects configuration: %s", (Object)annotatedConfiguration);
        }
        ExposeHazelcastObjects.Configuration hzBeanExportConf = ExposeHazelcastObjects.Configuration.empty();
        String hzBeanExportConfName = "hzBeanExportConf";
        if (registry.containsBeanDefinition(hzBeanExportConfName)) {
            hzBeanExportConf = (ExposeHazelcastObjects.Configuration)this.beanFactory.getBean(hzBeanExportConfName, ExposeHazelcastObjects.Configuration.class);
        } else {
            ExposeHazelcastObjects.Configuration toInsert = hzBeanExportConf;
            registry.registerBeanDefinition(hzBeanExportConfName, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ExposeHazelcastObjects.Configuration.class, () -> toInsert).getBeanDefinition());
        }
        hzBeanExportConf.includeOther(annotatedConfiguration);
    }
}

