/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.AliasedDiscoveryConfig;
import com.hazelcast.config.AutoDetectionConfig;
import com.hazelcast.config.BTreeIndexConfig;
import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.config.PersistentMemoryConfig;
import com.hazelcast.config.PersistentMemoryDirectoryConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.query.impl.IndexUtils;
import com.hazelcast.spring.config.ConfigFactory;
import com.hazelcast.spring.context.SpringManagedContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractHazelcastBeanDefinitionParser
extends AbstractBeanDefinitionParser {

    public static abstract class SpringXmlBuilderHelper
    extends AbstractXmlConfigHelper {
        protected BeanDefinitionBuilder configBuilder;

        protected void handleCommonBeanAttributes(Node node, BeanDefinitionBuilder builder, ParserContext parserContext) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                Node lazyInitAttr = attributes.getNamedItem("lazy-init");
                if (lazyInitAttr != null) {
                    builder.setLazyInit(Boolean.parseBoolean(this.getTextContent(lazyInitAttr)));
                } else {
                    builder.setLazyInit(parserContext.isDefaultLazyInit());
                }
                if (parserContext.isNested()) {
                    BeanDefinition containingBeanDefinition = parserContext.getContainingBeanDefinition();
                    if (containingBeanDefinition != null) {
                        builder.setScope(containingBeanDefinition.getScope());
                    }
                } else {
                    Node scopeNode = attributes.getNamedItem("scope");
                    if (scopeNode != null) {
                        builder.setScope(this.getTextContent(scopeNode));
                    }
                }
                Node dependsOnNode = attributes.getNamedItem("depends-on");
                if (dependsOnNode != null) {
                    String[] dependsOn;
                    for (String dep : dependsOn = this.getTextContent(dependsOnNode).split("[,;]")) {
                        builder.addDependsOn(dep.trim());
                    }
                }
            }
        }

        protected String getTextContent(Node node) {
            return DomConfigHelper.getTextContent((Node)node, (boolean)this.domLevel3);
        }

        protected String getAttribute(Node node, String attName) {
            return DomConfigHelper.getAttribute((Node)node, (String)attName, (boolean)this.domLevel3);
        }

        protected BeanDefinitionBuilder createBeanBuilder(Class<?> clazz) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(clazz);
            builder.setScope(this.configBuilder.getBeanDefinition().getScope());
            builder.setLazyInit(this.configBuilder.getBeanDefinition().isLazyInit());
            return builder;
        }

        protected BeanDefinitionBuilder createBeanBuilder(String className) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)className);
            builder.setScope(this.configBuilder.getBeanDefinition().getScope());
            builder.setLazyInit(this.configBuilder.getBeanDefinition().isLazyInit());
            return builder;
        }

        protected BeanDefinitionBuilder createAndFillBeanBuilder(Node node, Class<?> clazz, String propertyName, BeanDefinitionBuilder parent, String ... exceptPropertyNames) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            this.fillValues(node, builder, exceptPropertyNames);
            parent.addPropertyValue(propertyName, (Object)beanDefinition);
            return builder;
        }

        protected BeanDefinitionBuilder createAndFillListedBean(Node node, Class<?> clazz, String propertyName, ManagedMap<String, AbstractBeanDefinition> managedMap, String ... excludeNames) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            String name = this.getAttribute(node, propertyName);
            builder.addPropertyValue("name", (Object)name);
            this.fillValues(node, builder, excludeNames);
            managedMap.put((Object)name, (Object)beanDefinition);
            return builder;
        }

        protected void fillValues(Node node, BeanDefinitionBuilder builder, String ... excludeNames) {
            HashSet<String> epn = excludeNames != null && excludeNames.length > 0 ? new HashSet<String>(Arrays.asList(excludeNames)) : null;
            this.fillAttributeValues(node, builder, (Collection<String>)epn);
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = this.xmlToJavaName(DomConfigHelper.cleanNodeName((Node)n));
                if (epn != null && epn.contains(name)) continue;
                String value = this.getTextContent(n);
                builder.addPropertyValue(name, (Object)value);
            }
        }

        protected void fillAttributeValues(Node node, BeanDefinitionBuilder builder, String ... excludeNames) {
            HashSet<String> epn = excludeNames != null && excludeNames.length > 0 ? new HashSet<String>(Arrays.asList(excludeNames)) : null;
            this.fillAttributeValues(node, builder, (Collection<String>)epn);
        }

        protected void fillAttributeValues(Node node, BeanDefinitionBuilder builder, Collection<String> epn) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                for (int a = 0; a < attributes.getLength(); ++a) {
                    Node attribute = attributes.item(a);
                    String name = this.xmlToJavaName(attribute.getNodeName());
                    if (epn != null && epn.contains(name)) continue;
                    String value = attribute.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
        }

        protected void handleAliasedDiscoveryStrategy(Node node, BeanDefinitionBuilder builder, String name) {
            NamedNodeMap attributes = node.getAttributes();
            ManagedMap properties = new ManagedMap();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    properties.put(attribute.getNodeName(), attribute.getNodeValue());
                }
            }
            BeanDefinitionBuilder discoveryConfigBuilder = this.createBeanBuilder(AliasedDiscoveryConfig.class);
            discoveryConfigBuilder.getBeanDefinition().setBeanClass(ConfigFactory.class);
            discoveryConfigBuilder.setFactoryMethod("newAliasedDiscoveryConfig");
            discoveryConfigBuilder.addConstructorArgValue((Object)name);
            discoveryConfigBuilder.addConstructorArgValue((Object)properties);
            String propertyName = String.format("%sConfig", name);
            builder.addPropertyValue(propertyName, (Object)discoveryConfigBuilder.getBeanDefinition());
        }

        protected ManagedList<BeanDefinition> parseListeners(Node node, Class<?> listenerConfigClass) {
            ManagedList listeners = new ManagedList();
            String implementationAttr = "implementation";
            for (Node listenerNode : DomConfigHelper.childElements((Node)node)) {
                BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(listenerConfigClass);
                this.fillAttributeValues(listenerNode, listenerConfBuilder, implementationAttr);
                Node implementationNode = listenerNode.getAttributes().getNamedItem(implementationAttr);
                if (implementationNode != null) {
                    listenerConfBuilder.addPropertyReference(implementationAttr, this.getTextContent(implementationNode));
                }
                listeners.add((Object)listenerConfBuilder.getBeanDefinition());
            }
            return listeners;
        }

        protected ManagedList<BeanDefinition> parseProxyFactories(Node node, Class<?> proxyFactoryConfigClass) {
            ManagedList list = new ManagedList();
            for (Node instanceNode : DomConfigHelper.childElements((Node)node)) {
                BeanDefinitionBuilder confBuilder = this.createBeanBuilder(proxyFactoryConfigClass);
                this.fillAttributeValues(instanceNode, confBuilder, new String[0]);
                list.add((Object)confBuilder.getBeanDefinition());
            }
            return list;
        }

        protected void handleDataSerializableFactories(Node node, BeanDefinitionBuilder serializationConfigBuilder) {
            ManagedMap factories = new ManagedMap();
            ManagedMap classNames = new ManagedMap();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"data-serializable-factory".equals(name)) continue;
                NamedNodeMap attributes = child.getAttributes();
                Node implRef = attributes.getNamedItem("implementation");
                Node classNode = attributes.getNamedItem("class-name");
                Node fidNode = attributes.getNamedItem("factory-id");
                if (implRef != null) {
                    factories.put((Object)this.getTextContent(fidNode), (Object)new RuntimeBeanReference(this.getTextContent(implRef)));
                }
                if (classNode == null) continue;
                classNames.put((Object)this.getTextContent(fidNode), (Object)this.getTextContent(classNode));
            }
            serializationConfigBuilder.addPropertyValue("dataSerializableFactoryClasses", (Object)classNames);
            serializationConfigBuilder.addPropertyValue("dataSerializableFactories", (Object)factories);
        }

        protected void handleSerializers(Node node, BeanDefinitionBuilder serializationConfigBuilder) {
            BeanDefinitionBuilder globalSerializerConfigBuilder = null;
            String implementation = "implementation";
            String className = "class-name";
            String typeClassName = "type-class";
            String overrideJavaSerializationName = "override-java-serialization";
            ManagedList serializers = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("global-serializer".equals(name)) {
                    globalSerializerConfigBuilder = this.createGSConfigBuilder(GlobalSerializerConfig.class, child, implementation, className, overrideJavaSerializationName);
                }
                if (!"serializer".equals(name)) continue;
                BeanDefinitionBuilder serializerConfigBuilder = this.createBeanBuilder(SerializerConfig.class);
                this.fillAttributeValues(child, serializerConfigBuilder, new String[0]);
                NamedNodeMap attributes = child.getAttributes();
                Node implRef = attributes.getNamedItem(implementation);
                Node classNode = attributes.getNamedItem(className);
                Node typeClass = attributes.getNamedItem(typeClassName);
                if (typeClass != null) {
                    serializerConfigBuilder.addPropertyValue("typeClassName", (Object)this.getTextContent(typeClass));
                }
                if (implRef != null) {
                    serializerConfigBuilder.addPropertyReference(this.xmlToJavaName(implementation), this.getTextContent(implRef));
                }
                if (classNode != null) {
                    serializerConfigBuilder.addPropertyValue(this.xmlToJavaName(className), (Object)this.getTextContent(classNode));
                }
                serializers.add((Object)serializerConfigBuilder.getBeanDefinition());
            }
            if (globalSerializerConfigBuilder != null) {
                serializationConfigBuilder.addPropertyValue("globalSerializerConfig", (Object)globalSerializerConfigBuilder.getBeanDefinition());
            }
            serializationConfigBuilder.addPropertyValue("serializerConfigs", (Object)serializers);
        }

        private BeanDefinitionBuilder createGSConfigBuilder(Class<GlobalSerializerConfig> globalSerializerConfigClass, Node child, String implementation, String className, String overrideJavaSerializationName) {
            BeanDefinitionBuilder globalSerializerConfigBuilder = this.createBeanBuilder(globalSerializerConfigClass);
            NamedNodeMap attributes = child.getAttributes();
            Node implRef = attributes.getNamedItem(implementation);
            Node classNode = attributes.getNamedItem(className);
            Node overrideJavaSerializationNode = attributes.getNamedItem(overrideJavaSerializationName);
            if (implRef != null) {
                globalSerializerConfigBuilder.addPropertyReference(this.xmlToJavaName(implementation), this.getTextContent(implRef));
            }
            if (classNode != null) {
                globalSerializerConfigBuilder.addPropertyValue(this.xmlToJavaName(className), (Object)this.getTextContent(classNode));
            }
            if (overrideJavaSerializationNode != null) {
                String value = this.getTextContent(overrideJavaSerializationNode);
                globalSerializerConfigBuilder.addPropertyValue(this.xmlToJavaName(overrideJavaSerializationName), (Object)value);
            }
            return globalSerializerConfigBuilder;
        }

        protected void handlePortableFactories(Node node, BeanDefinitionBuilder serializationConfigBuilder) {
            ManagedMap factories = new ManagedMap();
            ManagedMap classNames = new ManagedMap();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"portable-factory".equals(name)) continue;
                NamedNodeMap attributes = child.getAttributes();
                Node implRef = attributes.getNamedItem("implementation");
                Node classNode = attributes.getNamedItem("class-name");
                Node fidNode = attributes.getNamedItem("factory-id");
                if (implRef != null) {
                    factories.put((Object)this.getTextContent(fidNode), (Object)new RuntimeBeanReference(this.getTextContent(implRef)));
                }
                if (classNode == null) continue;
                classNames.put((Object)this.getTextContent(fidNode), (Object)this.getTextContent(classNode));
            }
            serializationConfigBuilder.addPropertyValue("portableFactoryClasses", (Object)classNames);
            serializationConfigBuilder.addPropertyValue("portableFactories", (Object)factories);
        }

        private void handleCompactSerialization(Node compactNode, BeanDefinitionBuilder serializationConfigBuilder) {
            BeanDefinitionBuilder compactSerializationConfigBuilder = this.createBeanBuilder(CompactSerializationConfig.class);
            compactSerializationConfigBuilder.getBeanDefinition().setBeanClass(ConfigFactory.class);
            compactSerializationConfigBuilder.setFactoryMethod("newCompactSerializationConfig");
            ManagedList serializerClassNames = new ManagedList();
            ManagedList compactSerializableClassNames = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)compactNode)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("serializers".equals(name)) {
                    this.handleCompactSerializers(child, (List<String>)serializerClassNames);
                    continue;
                }
                if (!"classes".equals(name)) continue;
                this.handleCompactSerializableClasses(child, (List<String>)compactSerializableClassNames);
            }
            compactSerializationConfigBuilder.addConstructorArgValue((Object)serializerClassNames);
            compactSerializationConfigBuilder.addConstructorArgValue((Object)compactSerializableClassNames);
            AbstractBeanDefinition compactBeanDefinition = compactSerializationConfigBuilder.getBeanDefinition();
            serializationConfigBuilder.addPropertyValue("compactSerializationConfig", (Object)compactBeanDefinition);
        }

        private void handleCompactSerializers(Node compactSerializers, List<String> serializerClassNames) {
            for (Node node : DomConfigHelper.childElements((Node)compactSerializers)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                if (!"serializer".equals(nodeName)) continue;
                String serializerClassName = this.getTextContent(node);
                serializerClassNames.add(serializerClassName);
            }
        }

        private void handleCompactSerializableClasses(Node compactSerializableClasses, List<String> compactSerializableClassNames) {
            for (Node node : DomConfigHelper.childElements((Node)compactSerializableClasses)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                if (!"class".equals(nodeName)) continue;
                String compactSerializableClassName = this.getTextContent(node);
                compactSerializableClassNames.add(compactSerializableClassName);
            }
        }

        protected void handleSerialization(Node node) {
            BeanDefinitionBuilder serializationConfigBuilder = this.createBeanBuilder(SerializationConfig.class);
            AbstractBeanDefinition beanDefinition = serializationConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, serializationConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("data-serializable-factories".equals(nodeName)) {
                    this.handleDataSerializableFactories(child, serializationConfigBuilder);
                    continue;
                }
                if ("portable-factories".equals(nodeName)) {
                    this.handlePortableFactories(child, serializationConfigBuilder);
                    continue;
                }
                if ("serializers".equals(nodeName)) {
                    this.handleSerializers(child, serializationConfigBuilder);
                    continue;
                }
                if ("java-serialization-filter".equals(nodeName)) {
                    this.handleJavaSerializationFilter(child, serializationConfigBuilder, "javaSerializationFilterConfig");
                    continue;
                }
                if (!"compact-serialization".equals(nodeName)) continue;
                this.handleCompactSerialization(child, serializationConfigBuilder);
            }
            this.configBuilder.addPropertyValue("serializationConfig", (Object)beanDefinition);
        }

        protected void handleSocketInterceptorConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder socketInterceptorConfigBuilder = this.createBeanBuilder(SocketInterceptorConfig.class);
            String implAttribute = "implementation";
            this.fillAttributeValues(node, socketInterceptorConfigBuilder, implAttribute);
            Node implNode = node.getAttributes().getNamedItem(implAttribute);
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                socketInterceptorConfigBuilder.addPropertyReference(this.xmlToJavaName(implAttribute), implementation);
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, socketInterceptorConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("socketInterceptorConfig", (Object)socketInterceptorConfigBuilder.getBeanDefinition());
        }

        void handleClusterAttributes(Node node) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                for (int a = 0; a < attributes.getLength(); ++a) {
                    Node att = attributes.item(a);
                    String name = att.getNodeName();
                    String value = att.getNodeValue();
                    if ("name".equals(name)) {
                        this.configBuilder.addPropertyValue("clusterName", (Object)value);
                        continue;
                    }
                    if (!"password".equals(name)) continue;
                    this.configBuilder.addPropertyValue("clusterPassword", (Object)value);
                }
            }
        }

        protected void handleProperties(Node node, BeanDefinitionBuilder beanDefinitionBuilder) {
            ManagedMap properties = this.parseProperties(node);
            beanDefinitionBuilder.addPropertyValue("properties", (Object)properties);
        }

        protected ManagedMap parseProperties(Node node) {
            ManagedMap properties = new ManagedMap();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if (!"property".equals(name)) continue;
                String propertyName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                String value = this.getTextContent(n);
                properties.put((Object)propertyName, (Object)value);
            }
            return properties;
        }

        protected void handleSpringAware() {
            BeanDefinitionBuilder managedContextBeanBuilder = this.createBeanBuilder(SpringManagedContext.class);
            this.configBuilder.addPropertyValue("managedContext", (Object)managedContextBeanBuilder.getBeanDefinition());
        }

        protected BeanDefinition getEvictionConfig(Node node, boolean isNearCache, boolean isIMap) {
            Node size = node.getAttributes().getNamedItem("size");
            Node maxSizePolicy = node.getAttributes().getNamedItem("max-size-policy");
            Node evictionPolicy = node.getAttributes().getNamedItem("eviction-policy");
            Node comparatorClassName = node.getAttributes().getNamedItem("comparator-class-name");
            Node comparatorBean = node.getAttributes().getNamedItem("comparator-bean");
            if (comparatorClassName != null && comparatorBean != null) {
                throw new InvalidConfigurationException("Only one of the `comparator-class-name` and `comparator-bean` attributes can be configured inside eviction configuration!");
            }
            BeanDefinitionBuilder evictionConfigBuilder = this.createBeanBuilder(EvictionConfig.class);
            evictionConfigBuilder.getBeanDefinition().setBeanClass(ConfigFactory.class);
            evictionConfigBuilder.setFactoryMethod("newEvictionConfig");
            String comparatorClassNameValue = null;
            if (comparatorClassName != null) {
                comparatorClassNameValue = this.getTextContent(comparatorClassName);
            }
            evictionConfigBuilder.addConstructorArgValue((Object)this.getTextContent(size));
            evictionConfigBuilder.addConstructorArgValue((Object)this.getTextContent(maxSizePolicy));
            evictionConfigBuilder.addConstructorArgValue((Object)this.getTextContent(evictionPolicy));
            evictionConfigBuilder.addConstructorArgValue((Object)isNearCache);
            evictionConfigBuilder.addConstructorArgValue((Object)isIMap);
            evictionConfigBuilder.addConstructorArgValue((Object)comparatorClassNameValue);
            if (comparatorBean == null) {
                evictionConfigBuilder.addConstructorArgValue(null);
            } else {
                evictionConfigBuilder.addConstructorArgReference(this.getTextContent(comparatorBean));
            }
            return evictionConfigBuilder.getBeanDefinition();
        }

        protected BeanDefinition getPreloaderConfig(Node node) {
            Node enabled = node.getAttributes().getNamedItem("enabled");
            Node directory = node.getAttributes().getNamedItem("directory");
            Node storeInitialDelaySeconds = node.getAttributes().getNamedItem("store-initial-delay-seconds");
            Node storeIntervalSeconds = node.getAttributes().getNamedItem("store-interval-seconds");
            BeanDefinitionBuilder nearCachePreloaderConfigBuilder = this.createBeanBuilder(NearCachePreloaderConfig.class);
            String storeInitialDelaySecondsValue = String.valueOf(600);
            String storeIntervalSecondsValue = String.valueOf(600);
            if (storeInitialDelaySeconds != null) {
                storeInitialDelaySecondsValue = this.getTextContent(storeInitialDelaySeconds);
            }
            if (storeIntervalSeconds != null) {
                storeIntervalSecondsValue = this.getTextContent(storeIntervalSeconds);
            }
            nearCachePreloaderConfigBuilder.addPropertyValue("enabled", (Object)this.getTextContent(enabled));
            nearCachePreloaderConfigBuilder.addPropertyValue("directory", (Object)this.getTextContent(directory));
            nearCachePreloaderConfigBuilder.addPropertyValue("storeInitialDelaySeconds", (Object)storeInitialDelaySecondsValue);
            nearCachePreloaderConfigBuilder.addPropertyValue("storeIntervalSeconds", (Object)storeIntervalSecondsValue);
            return nearCachePreloaderConfigBuilder.getBeanDefinition();
        }

        protected void handleNativeMemory(Node node) {
            BeanDefinitionBuilder nativeMemoryConfigBuilder = this.createBeanBuilder(NativeMemoryConfig.class);
            AbstractBeanDefinition beanDefinition = nativeMemoryConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, nativeMemoryConfigBuilder, "persistentMemoryDirectory");
            ManagedList directories = new ManagedList();
            BeanDefinitionBuilder pmemConfigBuilder = this.createBeanBuilder(PersistentMemoryConfig.class);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("size".equals(nodeName)) {
                    this.handleCapacityConfig(child, nativeMemoryConfigBuilder);
                    continue;
                }
                if ("capacity".equals(nodeName)) {
                    this.handleCapacityConfig(child, nativeMemoryConfigBuilder);
                    continue;
                }
                if (!"persistent-memory".equals(nodeName)) continue;
                this.handlePersistentMemoryConfig(child, pmemConfigBuilder, (ManagedList<BeanDefinition>)directories);
            }
            Node attrPmemDirectory = node.getAttributes().getNamedItem("persistent-memory-directory");
            if (attrPmemDirectory != null) {
                BeanDefinitionBuilder pmemDirConfigBuilder = this.createBeanBuilder(PersistentMemoryDirectoryConfig.class);
                pmemDirConfigBuilder.addConstructorArgValue((Object)this.getTextContent(attrPmemDirectory));
                directories.add((Object)pmemDirConfigBuilder.getBeanDefinition());
            }
            if (!directories.isEmpty()) {
                pmemConfigBuilder.addPropertyValue("directoryConfigs", (Object)directories);
            }
            nativeMemoryConfigBuilder.addPropertyValue("persistentMemoryConfig", (Object)pmemConfigBuilder.getBeanDefinition());
            this.configBuilder.addPropertyValue("nativeMemoryConfig", (Object)beanDefinition);
        }

        private void handlePersistentMemoryConfig(Node pmemNode, BeanDefinitionBuilder pmemConfigBuilder, ManagedList<BeanDefinition> directoriesList) {
            Node enabledNode = pmemNode.getAttributes().getNamedItem("enabled");
            pmemConfigBuilder.addPropertyValue("enabled", (Object)this.getTextContent(enabledNode));
            Node mode = pmemNode.getAttributes().getNamedItem("mode");
            pmemConfigBuilder.addPropertyValue("mode", (Object)this.getTextContent(mode));
            for (Node dirsNode : DomConfigHelper.childElements((Node)pmemNode)) {
                String dirsNodeName = DomConfigHelper.cleanNodeName((Node)dirsNode);
                if (!"directories".equals(dirsNodeName)) continue;
                for (Node dirNode : DomConfigHelper.childElements((Node)dirsNode)) {
                    String dirNodeName = DomConfigHelper.cleanNodeName((Node)dirNode);
                    if (!"directory".equals(dirNodeName)) continue;
                    BeanDefinitionBuilder pmemDirConfigBuilder = this.createBeanBuilder(PersistentMemoryDirectoryConfig.class);
                    NamedNodeMap attributes = dirNode.getAttributes();
                    Node numaNode = attributes.getNamedItem("numa-node");
                    pmemDirConfigBuilder.addConstructorArgValue((Object)this.getTextContent(dirNode));
                    pmemDirConfigBuilder.addConstructorArgValue((Object)this.getTextContent(numaNode));
                    directoriesList.add((Object)pmemDirConfigBuilder.getBeanDefinition());
                }
            }
        }

        private void handleCapacityConfig(Node node, BeanDefinitionBuilder nativeMemoryConfigBuilder) {
            BeanDefinitionBuilder capacityConfigBuilder = this.createBeanBuilder(Capacity.class);
            NamedNodeMap attributes = node.getAttributes();
            Node value = attributes.getNamedItem("value");
            Node unit = attributes.getNamedItem("unit");
            capacityConfigBuilder.addConstructorArgValue((Object)this.getTextContent(value));
            capacityConfigBuilder.addConstructorArgValue((Object)this.getTextContent(unit));
            nativeMemoryConfigBuilder.addPropertyValue("capacity", (Object)capacityConfigBuilder.getBeanDefinition());
        }

        protected void handleDiscoveryStrategies(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder discoveryConfigBuilder = this.createBeanBuilder(DiscoveryConfig.class);
            ManagedList discoveryStrategyConfigs = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("discovery-strategy".equals(name)) {
                    this.handleDiscoveryStrategy(child, (ManagedList<BeanDefinition>)discoveryStrategyConfigs);
                    continue;
                }
                if ("node-filter".equals(name)) {
                    this.handleDiscoveryNodeFilter(child, discoveryConfigBuilder);
                    continue;
                }
                if (!"discovery-service-provider".equals(name)) continue;
                this.handleDiscoveryServiceProvider(child, discoveryConfigBuilder);
            }
            discoveryConfigBuilder.addPropertyValue("discoveryStrategyConfigs", (Object)discoveryStrategyConfigs);
            joinConfigBuilder.addPropertyValue("discoveryConfig", (Object)discoveryConfigBuilder.getBeanDefinition());
        }

        protected void handleAutoDetection(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder autoDetectionConfigBuilder = this.createBeanBuilder(AutoDetectionConfig.class);
            autoDetectionConfigBuilder.addPropertyValue("enabled", (Object)this.getAttribute(node, "enabled"));
            joinConfigBuilder.addPropertyValue("autoDetectionConfig", (Object)autoDetectionConfigBuilder.getBeanDefinition());
        }

        protected void handleIndex(ManagedList<BeanDefinition> indexes, Node indexNode) {
            BeanDefinitionBuilder indexConfBuilder = this.createBeanBuilder(IndexConfig.class);
            NamedNodeMap attributes = indexNode.getAttributes();
            String name = this.getTextContent(attributes.getNamedItem("name"));
            indexConfBuilder.addPropertyValue("name", (Object)(name.isEmpty() ? null : name));
            String typeStr = this.getTextContent(attributes.getNamedItem("type"));
            IndexType type = IndexUtils.getIndexTypeFromXmlName((String)typeStr);
            indexConfBuilder.addPropertyValue("type", (Object)type);
            ArrayList<String> columns = new ArrayList<String>();
            for (Node columnsNode : DomConfigHelper.childElements((Node)indexNode)) {
                if ("attributes".equals(DomConfigHelper.cleanNodeName((Node)columnsNode))) {
                    for (Node columnNode : DomConfigHelper.childElements((Node)columnsNode)) {
                        if (!"attribute".equals(DomConfigHelper.cleanNodeName((Node)columnNode))) continue;
                        columns.add(this.getTextContent(columnNode));
                    }
                    continue;
                }
                if (!"btree-index".equals(DomConfigHelper.cleanNodeName((Node)columnsNode))) continue;
                BTreeIndexConfig treeIndexConfig = new BTreeIndexConfig();
                for (Node columnNode : DomConfigHelper.childElements((Node)columnsNode)) {
                    if ("page-size".equals(DomConfigHelper.cleanNodeName((Node)columnNode))) {
                        treeIndexConfig.setPageSize(this.parseCapacity(columnNode));
                    }
                    if (!"memory-tier".equals(DomConfigHelper.cleanNodeName((Node)columnNode))) continue;
                    Node capacityNode = this.searchForNode(columnNode, "capacity");
                    treeIndexConfig.getMemoryTierConfig().setCapacity(this.parseCapacity(capacityNode));
                }
                indexConfBuilder.addPropertyValue("bTreeIndexConfig", (Object)treeIndexConfig);
            }
            indexConfBuilder.addPropertyValue("attributes", columns);
            indexes.add((Object)indexConfBuilder.getBeanDefinition());
        }

        private Node searchForNode(Node parentNode, String nodeCleanName) {
            for (Node node : DomConfigHelper.childElements((Node)parentNode)) {
                if (!DomConfigHelper.cleanNodeName((Node)node).equals(nodeCleanName)) continue;
                return node;
            }
            throw new IllegalStateException("no node with name " + nodeCleanName + " found");
        }

        private Capacity parseCapacity(Node columnNode) {
            String value = this.getAttribute(columnNode, "value");
            String unit = this.getAttribute(columnNode, "unit");
            return Capacity.of((long)Long.parseLong(value), (MemoryUnit)MemoryUnit.valueOf((String)unit));
        }

        private void handleDiscoveryServiceProvider(Node node, BeanDefinitionBuilder discoveryConfigBuilder) {
            NamedNodeMap attributes = node.getAttributes();
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = this.getTextContent(implNode).trim();
            Assert.isTrue((!implementation.isEmpty() ? 1 : 0) != 0, (String)"'implementation' attribute is required to create DiscoveryServiceProvider!");
            discoveryConfigBuilder.addPropertyReference("discoveryServiceProvider", implementation);
        }

        private void handleDiscoveryNodeFilter(Node node, BeanDefinitionBuilder discoveryConfigBuilder) {
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = this.getTextContent(classNameNode).trim();
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = this.getTextContent(implNode).trim();
            Assert.isTrue((!className.isEmpty() || !implementation.isEmpty() ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create NodeFilter!");
            if (!className.isEmpty()) {
                discoveryConfigBuilder.addPropertyValue("nodeFilterClass", (Object)className);
            }
            if (!implementation.isEmpty()) {
                discoveryConfigBuilder.addPropertyReference("nodeFilter", implementation);
            }
        }

        private void handleDiscoveryStrategy(Node node, ManagedList<BeanDefinition> discoveryStrategyConfigs) {
            BeanDefinitionBuilder discoveryStrategyConfigBuilder = this.createBeanBuilder(DiscoveryStrategyConfig.class);
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = this.getTextContent(classNameNode).trim();
            Node implNode = attributes.getNamedItem("discovery-strategy-factory");
            String implementation = this.getTextContent(implNode).trim();
            Assert.isTrue((!className.isEmpty() || !implementation.isEmpty() ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create DiscoveryStrategyConfig!");
            if (!implementation.isEmpty()) {
                discoveryStrategyConfigBuilder.addConstructorArgReference(implementation);
            } else {
                discoveryStrategyConfigBuilder.addConstructorArgValue((Object)className);
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                ManagedMap properties;
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(name) || (properties = this.parseProperties(child)).isEmpty()) continue;
                discoveryStrategyConfigBuilder.addConstructorArgValue((Object)properties);
            }
            discoveryStrategyConfigs.add((Object)discoveryStrategyConfigBuilder.getBeanDefinition());
        }

        protected void handleJavaSerializationFilter(Node node, BeanDefinitionBuilder configBuilder, String properyName) {
            BeanDefinitionBuilder filterConfigBuilder = this.createBeanBuilder(JavaSerializationFilterConfig.class);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("blacklist".equals(name)) {
                    filterConfigBuilder.addPropertyValue("blacklist", (Object)this.createFilterListBean(child));
                    continue;
                }
                if (!"whitelist".equals(name)) continue;
                filterConfigBuilder.addPropertyValue("whitelist", (Object)this.createFilterListBean(child));
            }
            Node defaultsDisabledAttr = node.getAttributes().getNamedItem("defaults-disabled");
            filterConfigBuilder.addPropertyValue("defaultsDisabled", (Object)this.getTextContent(defaultsDisabledAttr));
            configBuilder.addPropertyValue(properyName, (Object)filterConfigBuilder.getBeanDefinition());
        }

        private AbstractBeanDefinition createFilterListBean(Node node) {
            BeanDefinitionBuilder filterListBuilder = this.createBeanBuilder(ClassFilter.class);
            ManagedSet classes = new ManagedSet();
            ManagedSet packages = new ManagedSet();
            ManagedSet prefixes = new ManagedSet();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("class".equals(name)) {
                    classes.add((Object)this.getTextContent(child));
                    continue;
                }
                if ("package".equals(name)) {
                    packages.add((Object)this.getTextContent(child));
                    continue;
                }
                if (!"prefix".equals(name)) continue;
                prefixes.add((Object)this.getTextContent(child));
            }
            filterListBuilder.addPropertyValue("classes", (Object)classes);
            filterListBuilder.addPropertyValue("packages", (Object)packages);
            filterListBuilder.addPropertyValue("prefixes", (Object)prefixes);
            return filterListBuilder.getBeanDefinition();
        }
    }
}

