/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import java.util.ArrayList;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastClientBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    private static final int INITIAL_CAPACITY = 10;

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        springXmlBuilder.handleClient(element);
        return springXmlBuilder.getBeanDefinition();
    }

    private class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private BeanDefinitionBuilder builder;
        private ManagedMap nearCacheConfigMap;

        public SpringXmlBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(HazelcastClient.class);
            this.builder.setFactoryMethod("newHazelcastClient");
            this.builder.setDestroyMethodName("shutdown");
            this.nearCacheConfigMap = new ManagedMap();
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(ClientConfig.class);
            this.configBuilder.addPropertyValue("nearCacheConfigMap", (Object)this.nearCacheConfigMap);
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.builder.getBeanDefinition();
        }

        public void handleClient(Element element) {
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            this.handleClientAttributes(element);
            this.handleSpringAware(element);
            for (Node node : new AbstractXmlConfigHelper.IterableNodeList((Node)element, 1)) {
                String nodeName = SpringXmlBuilder.cleanNodeName((String)node.getNodeName());
                if ("group".equals(nodeName)) {
                    this.createAndFillBeanBuilder(node, GroupConfig.class, "groupConfig", this.configBuilder, new String[0]);
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(node, this.configBuilder);
                    continue;
                }
                if ("network".equals(nodeName)) {
                    this.handleNetwork(node);
                    continue;
                }
                if ("listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(node, ListenerConfig.class);
                    this.configBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                    continue;
                }
                if ("serialization".equals(nodeName)) {
                    this.handleSerialization(node);
                    continue;
                }
                if ("proxy-factories".equals(nodeName)) {
                    ManagedList list = this.parseProxyFactories(node, ProxyFactoryConfig.class);
                    this.configBuilder.addPropertyValue("proxyFactoryConfigs", (Object)list);
                    continue;
                }
                if ("load-balancer".equals(nodeName)) {
                    this.handleLoadBalancer(node);
                    continue;
                }
                if (!"near-cache".equals(nodeName)) continue;
                this.handleNearCache(node);
            }
            this.builder.addConstructorArgValue((Object)this.configBuilder.getBeanDefinition());
        }

        private void handleClientAttributes(Element element) {
            NamedNodeMap attrs = element.getAttributes();
            if (attrs != null) {
                for (int a = 0; a < attrs.getLength(); ++a) {
                    Node att = attrs.item(a);
                    String name = att.getNodeName();
                    String value = att.getNodeValue();
                    if ("executor-pool-size".equals(name)) {
                        this.configBuilder.addPropertyValue("executorPoolSize", (Object)value);
                        continue;
                    }
                    if (!"credentials-ref".equals(name)) continue;
                    this.configBuilder.addPropertyReference("credentials", value);
                }
            }
        }

        private void handleNetwork(Node node) {
            BeanDefinitionBuilder clientNetworkConfig = this.createBeanBuilder(ClientNetworkConfig.class);
            ArrayList<String> members = new ArrayList<String>(10);
            this.fillAttributeValues(node, clientNetworkConfig, new String[0]);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String nodeName = this.cleanNodeName(child);
                if ("member".equals(nodeName)) {
                    members.add(this.getTextContent(child));
                    continue;
                }
                if ("socket-options".equals(nodeName)) {
                    this.createAndFillBeanBuilder(child, SocketOptions.class, "socketOptions", clientNetworkConfig, new String[0]);
                    continue;
                }
                if ("socket-interceptor".equals(nodeName)) {
                    this.handleSocketInterceptorConfig(child, clientNetworkConfig);
                    continue;
                }
                if ("ssl".equals(nodeName)) {
                    this.handleSSLConfig(child, clientNetworkConfig);
                    continue;
                }
                if (!"aws".equals(nodeName)) continue;
                this.handleAws(child, clientNetworkConfig);
            }
            clientNetworkConfig.addPropertyValue("addresses", members);
            this.configBuilder.addPropertyValue("networkConfig", (Object)clientNetworkConfig.getBeanDefinition());
        }

        private void handleAws(Node node, BeanDefinitionBuilder clientNetworkConfig) {
            this.createAndFillBeanBuilder(node, ClientAwsConfig.class, "awsConfig", clientNetworkConfig, new String[0]);
        }

        private void handleSSLConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder sslConfigBuilder = this.createBeanBuilder(SSLConfig.class);
            String implAttribute = "factory-implementation";
            this.fillAttributeValues(node, sslConfigBuilder, "factory-implementation");
            Node implNode = node.getAttributes().getNamedItem("factory-implementation");
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                sslConfigBuilder.addPropertyReference(this.xmlToJavaName("factory-implementation"), implementation);
            }
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.cleanNodeName(child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, sslConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("SSLConfig", (Object)sslConfigBuilder.getBeanDefinition());
        }

        private void handleLoadBalancer(Node node) {
            String type = this.getAttribute(node, "type");
            if ("random".equals(type)) {
                this.configBuilder.addPropertyValue("loadBalancer", (Object)new RandomLB());
            } else if ("round-robin".equals(type)) {
                this.configBuilder.addPropertyValue("loadBalancer", (Object)new RoundRobinLB());
            }
        }

        private void handleNearCache(Node node) {
            this.createAndFillListedBean(node, NearCacheConfig.class, "name", this.nearCacheConfigMap, "name");
        }
    }
}

