/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.spring.HazelcastConfigBeanDefinitionParser;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HazelcastBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        springXmlBuilder.handle(element);
        return springXmlBuilder.getBeanDefinition();
    }

    private static class SpringXmlBuilder
    extends AbstractXmlConfigHelper {
        private final ParserContext parserContext;
        private BeanDefinitionBuilder builder;

        public SpringXmlBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(Hazelcast.class);
            this.builder.setFactoryMethod("newHazelcastInstance");
            this.builder.setDestroyMethodName("shutdown");
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.builder.getBeanDefinition();
        }

        public void handle(Element element) {
            for (Node node : new AbstractXmlConfigHelper.IterableNodeList((Node)element, 1)) {
                String nodeName = this.cleanNodeName(node.getNodeName());
                if (!"config".equals(nodeName)) continue;
                HazelcastConfigBeanDefinitionParser configParser = new HazelcastConfigBeanDefinitionParser();
                AbstractBeanDefinition configBeanDef = configParser.parseInternal((Element)node, this.parserContext);
                this.builder.addConstructorArgValue((Object)configBeanDef);
            }
        }
    }
}

