/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapstore;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.CalciteSqlDialect;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class MappingHelper {
    private static final SqlDialect DIALECT = CalciteSqlDialect.DEFAULT;
    private final SqlService sqlService;

    MappingHelper(SqlService sqlService) {
        this.sqlService = sqlService;
    }

    public void createMapping(String mappingName, String tableName, List<SqlColumnMetadata> mappingColumns, String dataConnectionRef, String idColumn) {
        this.sqlService.execute(this.createMappingQuery(mappingName, tableName, mappingColumns, dataConnectionRef, idColumn), new Object[0]).close();
    }

    private String createMappingQuery(String mappingName, String tableName, List<SqlColumnMetadata> mappingColumns, String dataConnectionRef, String idColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE MAPPING ");
        DIALECT.quoteIdentifier(sb, mappingName);
        sb.append(" EXTERNAL NAME ");
        MappingHelper.quoteExternalName(sb, tableName);
        if (mappingColumns != null) {
            sb.append(" ( ");
            Iterator<SqlColumnMetadata> iterator = mappingColumns.iterator();
            while (iterator.hasNext()) {
                SqlColumnMetadata mc = iterator.next();
                DIALECT.quoteIdentifier(sb, mc.getName());
                sb.append(' ');
                sb.append(mc.getType());
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(" )");
        }
        sb.append(" DATA CONNECTION ");
        DIALECT.quoteIdentifier(sb, dataConnectionRef);
        sb.append(" OPTIONS (");
        sb.append(" 'idColumn' = ");
        DIALECT.quoteStringLiteral(sb, null, idColumn);
        sb.append(" )");
        return sb.toString();
    }

    static void quoteExternalName(StringBuilder sb, String externalName) {
        List<String> parts = MappingHelper.splitByNonQuotedDots(externalName);
        for (int i = 0; i < parts.size(); ++i) {
            String unescaped = MappingHelper.unescapeQuotes(parts.get(i));
            String unquoted = MappingHelper.unquoteIfQuoted(unescaped);
            DIALECT.quoteIdentifier(sb, unquoted);
            if (i >= parts.size() - 1) continue;
            sb.append(".");
        }
    }

    private static List<String> splitByNonQuotedDots(String input) {
        ArrayList<String> result = new ArrayList<String>();
        int tokenStart = 0;
        boolean inQuotes = false;
        block4: for (int i = 0; i < input.length(); ++i) {
            switch (input.charAt(i)) {
                case '\"': {
                    inQuotes = !inQuotes;
                    continue block4;
                }
                case '.': {
                    if (inQuotes) continue block4;
                    result.add(input.substring(tokenStart, i));
                    tokenStart = i + 1;
                    continue block4;
                }
            }
        }
        result.add(input.substring(tokenStart));
        return result;
    }

    private static String unescapeQuotes(String input) {
        return input.replaceAll("\"\"", "\"");
    }

    private static String unquoteIfQuoted(String input) {
        return input.replaceAll("^\"|\"$", "");
    }

    public void dropMapping(String mappingName) {
        StringBuilder sb = new StringBuilder().append("DROP MAPPING IF EXISTS ");
        DIALECT.quoteIdentifier(sb, mappingName);
        this.sqlService.execute(sb.toString(), new Object[0]).close();
    }

    public List<SqlColumnMetadata> loadColumnMetadataFromMapping(String mapping) {
        String query = "SELECT * FROM information_schema.columns WHERE table_name = ? ORDER BY ordinal_position ASC";
        try (SqlResult result = this.sqlService.execute(query, new Object[]{mapping});){
            List<SqlColumnMetadata> list = StreamSupport.stream(result.spliterator(), false).map(row -> {
                String name = (String)row.getObject("column_name");
                String typeString = ((String)row.getObject("data_type")).replaceAll(" ", "_");
                SqlColumnType type = SqlColumnType.valueOf((String)typeString);
                boolean isNullable = Boolean.parseBoolean((String)row.getObject("is_nullable"));
                return new SqlColumnMetadata(name, type, isNullable);
            }).collect(Collectors.toList());
            return list;
        }
    }
}

