/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapstore;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapLoader;
import com.hazelcast.map.MapLoaderLifecycleSupport;
import com.hazelcast.mapstore.ExistingMappingValidator;
import com.hazelcast.mapstore.FromSqlRowConverter;
import com.hazelcast.mapstore.GenericMapStoreProperties;
import com.hazelcast.mapstore.MappingClosingIterator;
import com.hazelcast.mapstore.MappingHelper;
import com.hazelcast.mapstore.Queries;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GenericMapLoader<K, V>
implements MapLoader<K, V>,
MapLoaderLifecycleSupport {
    public static final String DATA_CONNECTION_REF_PROPERTY = "data-connection-ref";
    public static final String EXTERNAL_NAME_PROPERTY = "external-name";
    public static final String ID_COLUMN_PROPERTY = "id-column";
    public static final String COLUMNS_PROPERTY = "columns";
    public static final String TYPE_NAME_PROPERTY = "type-name";
    public static final String LOAD_ALL_KEYS_PROPERTY = "load-all-keys";
    public static final String SINGLE_COLUMN_AS_VALUE = "single-column-as-value";
    public static final HazelcastProperty MAPSTORE_INIT_TIMEOUT = new HazelcastProperty("hazelcast.mapstore.init.timeout", Integer.valueOf(30), TimeUnit.SECONDS);
    static final String MAPPING_PREFIX = "__map-store.";
    protected SqlService sqlService;
    protected List<SqlColumnMetadata> columnMetadataList;
    GenericMapStoreProperties genericMapStoreProperties;
    Queries queries;
    private ILogger logger;
    private HazelcastInstanceImpl instance;
    private MappingHelper mappingHelper;
    private String mapName;
    private String mappingName;
    private long initTimeoutMillis;
    private Exception initFailure;
    private final CountDownLatch initFinished = new CountDownLatch(1);

    public void init(HazelcastInstance instance, Properties properties, String mapName) {
        this.validateMapStoreConfig(instance, mapName);
        this.logger = instance.getLoggingService().getLogger(GenericMapLoader.class);
        this.instance = Util.getHazelcastInstanceImpl((HazelcastInstance)instance);
        this.genericMapStoreProperties = new GenericMapStoreProperties(properties, mapName);
        this.sqlService = instance.getSql();
        this.mappingHelper = new MappingHelper(this.sqlService);
        this.mapName = mapName;
        this.mappingName = MAPPING_PREFIX + mapName;
        HazelcastProperties hzProperties = this.nodeEngine().getProperties();
        this.initTimeoutMillis = hzProperties.getMillis(MAPSTORE_INIT_TIMEOUT);
        ManagedExecutorService asyncExecutor = this.getMapStoreExecutor();
        asyncExecutor.submit(this::createOrReadMapping);
    }

    private void validateMapStoreConfig(HazelcastInstance instance, String mapName) {
        MapConfig mapConfig = instance.getConfig().findMapConfig(mapName);
        MapStoreConfig mapStoreConfig = mapConfig.getMapStoreConfig();
        if (!mapStoreConfig.isOffload()) {
            throw new HazelcastException("MapStoreConfig for " + mapConfig.getName() + " must have `offload` property set to true");
        }
        if (mapStoreConfig.getProperty(DATA_CONNECTION_REF_PROPERTY) == null) {
            throw new HazelcastException("MapStoreConfig for " + mapConfig.getName() + " must have `data-connection-ref` property set");
        }
        String loadAllKeys = mapStoreConfig.getProperty(LOAD_ALL_KEYS_PROPERTY);
        if (loadAllKeys != null && !StringUtil.isBoolean((String)loadAllKeys)) {
            throw new HazelcastException("MapStoreConfig for " + mapConfig.getName() + " must have `load-all-keys` property set as true or false");
        }
    }

    private ManagedExecutorService getMapStoreExecutor() {
        return this.nodeEngine().getExecutionService().getExecutor("hz:map-store-offloadable");
    }

    private NodeEngineImpl nodeEngine() {
        return this.instance.node.nodeEngine;
    }

    private void createOrReadMapping() {
        this.logger.fine("Initializing for map %s", (Object)this.mapName);
        try {
            List<SqlColumnMetadata> mappingColumns = null;
            if (this.genericMapStoreProperties.hasColumns()) {
                mappingColumns = this.resolveMappingColumns();
                this.logger.fine("Discovered following mapping columns: %s", mappingColumns);
            }
            this.mappingHelper.createMapping(this.mappingName, this.genericMapStoreProperties.tableName, mappingColumns, this.genericMapStoreProperties.dataConnectionRef, this.genericMapStoreProperties.idColumn);
            this.readExistingMapping();
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Mapping or view already exists:")) {
                this.readExistingMapping();
            } else {
                this.logger.severe((Throwable)e);
                this.initFailure = e;
            }
        }
        finally {
            this.initFinished.countDown();
        }
    }

    private List<SqlColumnMetadata> resolveMappingColumns() {
        String tempMapping = "temp_mapping_" + UuidUtil.newUnsecureUuidString();
        this.mappingHelper.createMapping(tempMapping, this.genericMapStoreProperties.tableName, null, this.genericMapStoreProperties.dataConnectionRef, this.genericMapStoreProperties.idColumn);
        List<SqlColumnMetadata> allColumnsMetadataList = this.mappingHelper.loadColumnMetadataFromMapping(tempMapping);
        this.dropMapping(tempMapping);
        Map columnMap = allColumnsMetadataList.stream().collect(Collectors.toMap(SqlColumnMetadata::getName, Function.identity()));
        return this.genericMapStoreProperties.getAllColumns().stream().map(columnName -> ExistingMappingValidator.validateColumn(columnMap, columnName)).collect(Collectors.toList());
    }

    private void readExistingMapping() {
        this.logger.fine("Reading existing mapping for map %s", (Object)this.mapName);
        try {
            List<SqlColumnMetadata> columnMetadata = this.mappingHelper.loadColumnMetadataFromMapping(this.mappingName);
            if (this.genericMapStoreProperties.hasColumns()) {
                columnMetadata.removeIf(c -> !this.genericMapStoreProperties.columns.contains(c.getName()) && !this.genericMapStoreProperties.idColumn.contains(c.getName()));
            }
            Map<String, SqlColumnMetadata> columnMap = columnMetadata.stream().collect(Collectors.toMap(SqlColumnMetadata::getName, Function.identity()));
            ExistingMappingValidator.validateColumnsExist(columnMap, this.genericMapStoreProperties.getAllColumns());
            this.columnMetadataList = columnMetadata;
            this.queries = new Queries(this.mappingName, this.genericMapStoreProperties.idColumn, columnMetadata);
        }
        catch (Exception e) {
            this.initFailure = e;
        }
    }

    public void destroy() {
        ManagedExecutorService asyncExecutor = this.getMapStoreExecutor();
        asyncExecutor.submit(() -> {
            this.awaitInitFinished();
            if (this.instance.isRunning()) {
                this.dropMapping(this.mappingName);
            }
        });
    }

    private void dropMapping(String mappingName) {
        this.logger.info("Dropping mapping " + mappingName);
        try {
            this.mappingHelper.dropMapping(mappingName);
        }
        catch (Exception e) {
            this.logger.warning("Failed to drop mapping " + mappingName, (Throwable)e);
        }
    }

    public V load(K key) {
        this.awaitSuccessfulInit();
        try (SqlResult queryResult = this.sqlService.execute(this.queries.load(), new Object[]{key});){
            Iterator it = queryResult.iterator();
            Object value = null;
            if (it.hasNext()) {
                SqlRow sqlRow = (SqlRow)it.next();
                if (it.hasNext()) {
                    throw new IllegalStateException("multiple matching rows for a key " + String.valueOf(key));
                }
                value = queryResult.getRowMetadata().getColumnCount() == 2 && this.genericMapStoreProperties.singleColumnAsValue ? sqlRow.getObject(1) : FromSqlRowConverter.toGenericRecord(sqlRow, this.genericMapStoreProperties);
            }
            GenericRecord genericRecord = value;
            return (V)genericRecord;
        }
    }

    public Map<K, V> loadAll(Collection<K> keys) {
        this.awaitSuccessfulInit();
        Object[] keysArray = keys.toArray();
        String sql = this.queries.loadAll(keys.size());
        try (SqlResult queryResult = this.sqlService.execute(sql, keysArray);){
            Iterator it = queryResult.iterator();
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            while (it.hasNext()) {
                Object id;
                SqlRow sqlRow = (SqlRow)it.next();
                if (queryResult.getRowMetadata().getColumnCount() == 2 && this.genericMapStoreProperties.singleColumnAsValue) {
                    id = sqlRow.getObject(this.genericMapStoreProperties.idColumn);
                    result.put(id, sqlRow.getObject(1));
                    continue;
                }
                id = sqlRow.getObject(this.genericMapStoreProperties.idColumn);
                GenericRecord record = FromSqlRowConverter.toGenericRecord(sqlRow, this.genericMapStoreProperties);
                result.put(id, record);
            }
            HashMap<Object, Object> hashMap = result;
            return hashMap;
        }
    }

    public Iterable<K> loadAllKeys() {
        if (!this.genericMapStoreProperties.loadAllKeys) {
            return Collections.emptyList();
        }
        this.awaitSuccessfulInit();
        String sql = this.queries.loadAllKeys();
        SqlResult keysResult = this.sqlService.execute(sql, new Object[0]);
        return () -> new MappingClosingIterator<SqlRow, Object>(keysResult.iterator(), row -> row.getObject(this.genericMapStoreProperties.idColumn), () -> ((SqlResult)keysResult).close());
    }

    protected void awaitSuccessfulInit() {
        this.awaitInitFinished();
        if (this.initFailure != null) {
            throw new HazelcastException("MapStore init failed for map: " + this.mapName, (Throwable)this.initFailure);
        }
    }

    void awaitInitFinished() {
        try {
            boolean finished = this.initFinished.await(this.initTimeoutMillis, TimeUnit.MILLISECONDS);
            if (!finished) {
                throw new HazelcastException("MapStore init for map: " + this.mapName + " timed out after " + this.initTimeoutMillis + " ms", (Throwable)this.initFailure);
            }
        }
        catch (InterruptedException e) {
            throw new HazelcastException((Throwable)e);
        }
    }

    boolean initHasFinished() {
        return this.initFinished.getCount() == 0L;
    }
}

