/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.view;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class View
implements IdentifiedDataSerializable,
Versioned {
    private String name;
    private String query;
    private List<String> viewColumnNames;
    private List<QueryDataType> viewColumnTypes;

    public View() {
    }

    public View(String name, String query, List<String> columnNames, List<QueryDataType> columnTypes) {
        this.name = name;
        this.query = query;
        this.viewColumnNames = columnNames;
        this.viewColumnTypes = columnTypes;
    }

    public View(String name, String query, boolean isStream, List<String> columnNames, List<QueryDataType> columnTypes) {
        this.name = name;
        this.query = query;
        this.viewColumnNames = columnNames;
        this.viewColumnTypes = columnTypes;
    }

    public String name() {
        return this.name;
    }

    public String query() {
        return this.query;
    }

    public List<String> viewColumnNames() {
        return this.viewColumnNames;
    }

    public List<QueryDataType> viewColumnTypes() {
        return this.viewColumnTypes;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.query);
        if (out.getVersion().isLessThan(Versions.V5_2)) {
            out.writeBoolean(false);
        }
        SerializationUtil.writeList(this.viewColumnNames, out);
        SerializationUtil.writeList(this.viewColumnTypes, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.query = in.readString();
        if (in.getVersion().isLessThan(Versions.V5_2)) {
            in.readBoolean();
        }
        this.viewColumnNames = SerializationUtil.readList(in);
        this.viewColumnTypes = SerializationUtil.readList(in);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 61;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View view = (View)o;
        return Objects.equals(this.name, view.name) && Objects.equals(this.query, view.query) && Objects.equals(this.viewColumnNames, view.viewColumnNames) && Objects.equals(this.viewColumnTypes, view.viewColumnTypes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.query, this.viewColumnNames, this.viewColumnTypes);
    }
}

