/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.permission;

import com.hazelcast.security.permission.AtomicLongPermission;
import com.hazelcast.security.permission.AtomicReferencePermission;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.security.permission.CardinalityEstimatorPermission;
import com.hazelcast.security.permission.CountDownLatchPermission;
import com.hazelcast.security.permission.DurableExecutorServicePermission;
import com.hazelcast.security.permission.ExecutorServicePermission;
import com.hazelcast.security.permission.FlakeIdGeneratorPermission;
import com.hazelcast.security.permission.JobPermission;
import com.hazelcast.security.permission.ListPermission;
import com.hazelcast.security.permission.LockPermission;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.security.permission.PNCounterPermission;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.security.permission.ReliableTopicPermission;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import com.hazelcast.security.permission.RingBufferPermission;
import com.hazelcast.security.permission.SemaphorePermission;
import com.hazelcast.security.permission.SetPermission;
import com.hazelcast.security.permission.SqlPermission;
import com.hazelcast.security.permission.TopicPermission;
import com.hazelcast.security.permission.UserCodeDeploymentPermission;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;

public final class ActionConstants {
    public static final String ACTION_ALL = "all";
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_DESTROY = "destroy";
    public static final String ACTION_MODIFY = "modify";
    public static final String ACTION_READ = "read";
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_LOCK = "lock";
    public static final String ACTION_LISTEN = "listen";
    public static final String ACTION_RELEASE = "release";
    public static final String ACTION_ACQUIRE = "acquire";
    public static final String ACTION_PUT = "put";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_INDEX = "index";
    public static final String ACTION_INTERCEPT = "intercept";
    public static final String ACTION_PUBLISH = "publish";
    public static final String ACTION_AGGREGATE = "aggregate";
    public static final String ACTION_PROJECTION = "projection";
    public static final String ACTION_USER_CODE_DEPLOY = "deploy";
    public static final String ACTION_SUBMIT = "submit";
    public static final String ACTION_CANCEL = "cancel";
    public static final String ACTION_RESTART = "restart";
    public static final String ACTION_EXPORT_SNAPSHOT = "export-snapshot";
    public static final String ACTION_ADD_RESOURCES = "add-resources";
    public static final String ACTION_WRITE = "write";
    public static final String LISTENER_INSTANCE = "instance";
    public static final String LISTENER_MEMBER = "member";
    public static final String LISTENER_MIGRATION = "migration";
    public static final String ACTION_CREATE_VIEW = "create-view";
    public static final String ACTION_DROP_VIEW = "drop-view";
    public static final String ACTION_CREATE_TYPE = "create-type";
    public static final String ACTION_DROP_TYPE = "drop-type";
    private static final Map<String, PermissionFactory> PERMISSION_FACTORY_MAP = new HashMap<String, PermissionFactory>();

    private ActionConstants() {
    }

    public static Permission getPermission(String name, String serviceName, String ... actions) {
        PermissionFactory permissionFactory = PERMISSION_FACTORY_MAP.get(serviceName);
        if (permissionFactory == null) {
            throw new IllegalArgumentException("No permissions found for service: " + serviceName);
        }
        return permissionFactory.create(name, actions);
    }

    static {
        PERMISSION_FACTORY_MAP.put("hz:impl:queueService", QueuePermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:mapService", MapPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:multiMapService", MultiMapPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:listService", ListPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:setService", SetPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:raft:atomicLongService", AtomicLongPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:raft:countDownLatchService", CountDownLatchPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:raft:semaphoreService", SemaphorePermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:topicService", TopicPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:lockService", LockPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:raft:lockService", LockPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:executorService", ExecutorServicePermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:flakeIdGeneratorService", FlakeIdGeneratorPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:replicatedMapService", ReplicatedMapPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:raft:atomicRefService", AtomicReferencePermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:cacheService", CachePermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:ringbufferService", RingBufferPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:durableExecutorService", DurableExecutorServicePermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:cardinalityEstimatorService", CardinalityEstimatorPermission::new);
        PERMISSION_FACTORY_MAP.put("user-code-deployment-service", (name, actions) -> new UserCodeDeploymentPermission(actions));
        PERMISSION_FACTORY_MAP.put("hz:impl:PNCounterService", PNCounterPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:reliableTopicService", ReliableTopicPermission::new);
        PERMISSION_FACTORY_MAP.put("hz:impl:jetService", (name, actions) -> new JobPermission(actions));
        PERMISSION_FACTORY_MAP.put("hz:impl:sqlService", SqlPermission::new);
    }

    private static interface PermissionFactory {
        public Permission create(String var1, String ... var2);
    }
}

