/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ParameterList {
    private static final Parameter NULL_VALUE = new Parameter(null);
    private final List<Parameter> parameters = new ArrayList<Parameter>(0);

    ParameterList() {
    }

    List<Object> asParameters() throws SQLException {
        if (this.parameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> params = new ArrayList<Object>(this.parameters.size());
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter parameter = this.parameters.get(i);
            if (parameter == null) {
                throw new SQLException("Parameter #" + (i + 1) + " is not set");
            }
            params.add(parameter.value);
        }
        return params;
    }

    void setParameter(int parameterIndex, Object parameter) {
        this.setParameter(parameterIndex, new Parameter(parameter));
    }

    void setNullValue(int parameterIndex) {
        this.setParameter(parameterIndex, NULL_VALUE);
    }

    private void setParameter(int parameterIndex, Parameter parameter) {
        while (parameterIndex > this.parameters.size()) {
            this.parameters.add(null);
        }
        this.parameters.set(parameterIndex - 1, parameter);
    }

    private static final class Parameter {
        private final Object value;

        private Parameter(Object value) {
            this.value = value;
        }
    }
}

