/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jdbc;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class JdbcUrl {
    private static final String PREFIX = "jdbc:hazelcast:";
    private static final Pattern JDBC_URL_PATTERN = Pattern.compile("jdbc:hazelcast://(?<authority>\\S+?)/?(\\?(?<parameters>\\S*))?");
    private final List<String> authorities;
    private final String rawUrl;
    private final Properties properties = new Properties();
    private final String rawAuthority;

    JdbcUrl(String url, Properties properties) {
        String parametersString;
        Matcher matcher = JDBC_URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The URL doesn't match the structure - jdbc:hazelcast://host:port[,host2:port...]/[?prop1=value1&...]");
        }
        this.rawAuthority = JdbcUrl.decodeUrl(matcher.group("authority"));
        this.authorities = Arrays.asList(this.rawAuthority.split(","));
        this.rawUrl = url;
        if (properties != null) {
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)this.properties::put));
        }
        if ((parametersString = matcher.group("parameters")) != null) {
            for (String parameter : parametersString.split("&")) {
                String[] paramAndValue = parameter.split("=", 2);
                if (paramAndValue.length != 2) {
                    paramAndValue = new String[]{paramAndValue[0], ""};
                }
                this.properties.setProperty(JdbcUrl.decodeUrl(paramAndValue[0]), JdbcUrl.decodeUrl(paramAndValue[1]));
            }
        }
    }

    public List<String> getAuthorities() {
        return this.authorities;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getRawUrl() {
        return this.rawUrl;
    }

    public String getRawAuthority() {
        return this.rawAuthority;
    }

    static boolean acceptsUrl(String url) {
        return url.startsWith(PREFIX);
    }

    private static String decodeUrl(String raw) {
        try {
            return URLDecoder.decode(raw, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException impossible) {
            throw new RuntimeException(impossible);
        }
    }
}

