/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jdbc;

import com.hazelcast.jdbc.HazelcastSqlClient;
import com.hazelcast.jdbc.JdbcResultSet;
import com.hazelcast.jdbc.JdbcUtils;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlExpectedResultType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class JdbcStatement
implements Statement {
    long updateCount = -1L;
    ResultSet resultSet;
    private int queryTimeout;
    private int fetchSize;
    private boolean closed;
    private boolean poolable;
    private int fetchDirection = 1000;
    private boolean closeOnCompletion;
    private int maxRows;
    private final HazelcastSqlClient client;
    private final Connection connection;
    private final String schema;

    JdbcStatement(HazelcastSqlClient client, Connection connection) throws SQLException {
        this.client = client;
        this.connection = connection;
        this.schema = connection.getSchema();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.doExecute(sql, Collections.emptyList(), SqlExpectedResultType.ROWS);
        return this.resultSet;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.doExecute(sql, Collections.emptyList(), SqlExpectedResultType.UPDATE_COUNT);
        return this.getLargeUpdateCount();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.executeLargeUpdate(sql);
        return this.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.closeResultSet();
            this.closed = true;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new SQLException("Invalid value for max field size: " + max);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new SQLException("Invalid value for max rows: " + max);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        if (seconds < 0) {
            throw new SQLException("Invalid value for query timeout seconds: " + seconds);
        }
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        throw JdbcUtils.unsupported("Cancellation is not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw JdbcUtils.unsupported("Cursor Name is not supported");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        this.doExecute(sql, Collections.emptyList(), SqlExpectedResultType.ANY);
        return this.resultSet != null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.updateCount != -1L) {
            return null;
        }
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return Math.toIntExact(this.getLargeUpdateCount());
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkClosed();
        return this.updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection = direction;
                break;
            }
            default: {
                throw new SQLException("Invalid fetch direction value: " + direction);
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new SQLException("Invalid value for fetch size: " + rows);
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw this.unsupportedBatch();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw this.unsupportedBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw this.unsupportedBatch();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        throw this.unsupportedBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        if (current == 1 || current == 3) {
            this.closeResultSet();
            this.updateCount = -1L;
        }
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        return JdbcResultSet.EMPTY;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        if (autoGeneratedKeys != 2) {
            throw this.unsupportedAutoGeneratedKeys();
        }
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        if (columnIndexes.length != 0) {
            throw this.unsupportedAutoGeneratedKeys();
        }
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        if (columnNames.length != 0) {
            throw this.unsupportedAutoGeneratedKeys();
        }
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        if (autoGeneratedKeys != 2) {
            throw this.unsupportedAutoGeneratedKeys();
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        if (columnIndexes.length != 0) {
            throw this.unsupportedAutoGeneratedKeys();
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        if (columnNames.length != 0) {
            throw this.unsupportedAutoGeneratedKeys();
        }
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return JdbcUtils.unwrap(this, iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return JdbcUtils.isWrapperFor(this, iface);
    }

    void tryCloseOnCompletion() throws SQLException {
        if (this.closeOnCompletion) {
            this.close();
        }
    }

    void doExecute(String sql, List<Object> parameters, SqlExpectedResultType expectedResult) throws SQLException {
        this.checkClosed();
        SqlStatement query = new SqlStatement(sql).setParameters(parameters).setExpectedResultType(expectedResult).setSchema(this.schema);
        if (this.queryTimeout != 0) {
            query.setTimeoutMillis(TimeUnit.SECONDS.toMillis(this.queryTimeout));
        }
        if (this.fetchSize != 0) {
            query.setCursorBufferSize(this.fetchSize);
        }
        try {
            SqlResult sqlResult = this.client.execute(query);
            if (sqlResult.isRowSet()) {
                this.resultSet = new JdbcResultSet(sqlResult, this);
                this.updateCount = -1L;
            } else {
                this.updateCount = sqlResult.updateCount();
                this.closeResultSet();
            }
        }
        catch (HazelcastSqlException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed");
        }
    }

    SQLException unsupportedBatch() {
        return JdbcUtils.unsupported("Batch updates is not supported");
    }

    private SQLFeatureNotSupportedException unsupportedAutoGeneratedKeys() {
        return JdbcUtils.unsupported("Auto-generated keys are not supported.");
    }

    private void closeResultSet() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }
}

