/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jdbc;

import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.AbstractSqlResult;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.ResultIterator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FixedRowsSqlResult
extends AbstractSqlResult {
    private final List<SqlRow> rows;
    private final QueryId queryId = new QueryId();
    private final SqlRowMetadata sqlRowMetadata;

    FixedRowsSqlResult(SqlRowMetadata sqlRowMetadata, List<SqlRow> rows) {
        this.rows = rows;
        this.sqlRowMetadata = sqlRowMetadata;
    }

    @Override
    public SqlRowMetadata getRowMetadata() {
        return this.sqlRowMetadata;
    }

    @Override
    public long updateCount() {
        return 0L;
    }

    @Override
    public QueryId getQueryId() {
        return this.queryId;
    }

    @Override
    public boolean isInfiniteRows() {
        return false;
    }

    @Override
    public ResultIterator<SqlRow> iterator() {
        return new FixedRowsSqlResultIterator(this.rows.iterator());
    }

    @Override
    public void close(QueryException exception) {
    }

    private static final class FixedRowsSqlResultIterator
    implements ResultIterator<SqlRow> {
        private final Iterator<SqlRow> iterator;

        FixedRowsSqlResultIterator(Iterator<SqlRow> arg0) {
            this.iterator = arg0;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SqlRow next() {
            return this.iterator.next();
        }

        @Override
        public ResultIterator.HasNextResult hasNext(long timeout, TimeUnit timeUnit) {
            return this.iterator.hasNext() ? ResultIterator.HasNextResult.YES : ResultIterator.HasNextResult.DONE;
        }
    }
}

