/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jca;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jca.HazelcastConnection;
import com.hazelcast.jca.HazelcastConnectionImpl;
import com.hazelcast.jca.HazelcastManagedConnectionMetaData;
import com.hazelcast.jca.HazelcastTransaction;
import com.hazelcast.jca.HazelcastTransactionImpl;
import com.hazelcast.jca.HzConnectionEvent;
import com.hazelcast.jca.JcaBase;
import com.hazelcast.jca.ManagedConnectionFactoryImpl;
import com.hazelcast.jca.ResourceAdapterImpl;
import com.hazelcast.transaction.TransactionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ManagedConnectionImpl
extends JcaBase
implements ManagedConnection {
    private static final AtomicInteger ID_GEN = new AtomicInteger();
    private final transient int id;
    private final List<ConnectionEventListener> connectionEventListeners = new ArrayList<ConnectionEventListener>(1);
    private final ManagedConnectionFactoryImpl factory;
    private final ConnectionRequestInfo cxRequestInfo;
    private final HazelcastInstance hazelcastInstance;
    private HazelcastTransactionImpl localTransaction;

    public ManagedConnectionImpl(ConnectionRequestInfo cxRequestInfo, ManagedConnectionFactoryImpl factory) {
        this.id = ID_GEN.incrementAndGet();
        this.factory = factory;
        this.cxRequestInfo = cxRequestInfo;
        ResourceAdapterImpl resourceAdapter = factory.getResourceAdapter();
        this.hazelcastInstance = resourceAdapter.getHazelcastInstance();
        this.setLogWriter(factory.getLogWriter());
        this.log(Level.FINEST, "ManagedConnectionImpl");
        factory.logHzConnectionEvent(this, HzConnectionEvent.CREATE);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.log(Level.FINEST, "addConnectionEventListener: " + listener);
        this.connectionEventListeners.add(listener);
    }

    public void associateConnection(Object arg0) throws ResourceException {
        this.log(Level.FINEST, "associateConnection: " + arg0);
    }

    public void cleanup() throws ResourceException {
        this.log(Level.FINEST, "cleanup");
        this.factory.logHzConnectionEvent(this, HzConnectionEvent.CLEANUP);
    }

    public void destroy() throws ResourceException {
        this.log(Level.FINEST, "destroy");
        this.factory.logHzConnectionEvent(this, HzConnectionEvent.DESTROY);
    }

    void fireConnectionEvent(int event) {
        this.fireConnectionEvent(event, null);
    }

    void fireConnectionEvent(int event, Connection conn) {
        this.log(Level.FINEST, "fireConnectionEvent: " + event);
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, event);
        block6: for (ConnectionEventListener listener : this.connectionEventListeners) {
            switch (event) {
                case 2: {
                    if (!this.isDeliverStartedEvent()) continue block6;
                    listener.localTransactionStarted(connectionEvent);
                    continue block6;
                }
                case 3: {
                    if (!this.isDeliverCommitedEvent()) continue block6;
                    listener.localTransactionCommitted(connectionEvent);
                    continue block6;
                }
                case 4: {
                    if (!this.isDeliverRolledback()) continue block6;
                    listener.localTransactionRolledback(connectionEvent);
                    continue block6;
                }
                case 1: {
                    if (!this.isDeliverClosed()) continue block6;
                    connectionEvent.setConnectionHandle((Object)conn);
                    listener.connectionClosed(connectionEvent);
                    continue block6;
                }
            }
            this.log(Level.WARNING, "Uknown event ignored: " + event);
        }
    }

    public HazelcastConnection getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) {
        this.log(Level.FINEST, "getConnection: " + subject + ", " + connectionRequestInfo);
        return new HazelcastConnectionImpl(this, subject);
    }

    public ConnectionRequestInfo getCxRequestInfo() {
        return this.cxRequestInfo;
    }

    HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public HazelcastTransaction getLocalTransaction() {
        this.log(Level.FINEST, "getLocalTransaction");
        if (this.localTransaction == null) {
            this.localTransaction = new HazelcastTransactionImpl(this.factory, this);
        }
        return this.localTransaction;
    }

    public TransactionContext getTransactionContext() {
        if (this.localTransaction == null) {
            return null;
        }
        return this.localTransaction.getTxContext();
    }

    public HazelcastManagedConnectionMetaData getMetaData() {
        return new HazelcastManagedConnectionMetaData();
    }

    public XAResource getXAResource() throws ResourceException {
        this.log(Level.FINEST, "getXAResource");
        return this.hazelcastInstance.getXAResource();
    }

    protected boolean isDeliverClosed() {
        return true;
    }

    protected boolean isDeliverCommitedEvent() {
        return true;
    }

    protected boolean isDeliverRolledback() {
        return true;
    }

    protected boolean isDeliverStartedEvent() {
        return false;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.log(Level.FINEST, "removeConnectionEventListener: " + listener);
        this.connectionEventListeners.remove(listener);
    }

    public String toString() {
        return "hazelcast.ManagedConnectionImpl [" + this.id + "]";
    }
}

