/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.instance.HazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.internal.util.config.ConfigurationHelper;

class HazelcastClientLoader
implements IHazelcastInstanceLoader {
    private static final ILogger logger = Logger.getLogger(HazelcastInstanceFactory.class);
    private final Properties props = new Properties();
    private HazelcastInstance client;

    HazelcastClientLoader() {
    }

    @Override
    public void configure(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    @Override
    public HazelcastInstance loadInstance() throws CacheException {
        if (this.client != null && this.client.getLifecycleService().isRunning()) {
            logger.warning("Current HazelcastClient is already active! Shutting it down...");
            this.unloadInstance();
        }
        String address = ConfigurationHelper.getString((String)"hibernate.cache.hazelcast.native_client_address", (Map)this.props, null);
        String group = ConfigurationHelper.getString((String)"hibernate.cache.hazelcast.native_client_group", (Map)this.props, null);
        String pass = ConfigurationHelper.getString((String)"hibernate.cache.hazelcast.native_client_password", (Map)this.props, null);
        String configResourcePath = CacheEnvironment.getConfigFilePath(this.props);
        ClientConfig clientConfig = null;
        if (configResourcePath != null) {
            try {
                clientConfig = new XmlClientConfigBuilder(configResourcePath).build();
            }
            catch (IOException e) {
                logger.warning("Could not load client configuration: " + configResourcePath, (Throwable)e);
            }
        }
        if (clientConfig == null) {
            clientConfig = new ClientConfig();
            clientConfig.getNetworkConfig().setConnectionAttemptLimit(10);
        }
        if (group != null) {
            clientConfig.getGroupConfig().setName(group);
        }
        if (pass != null) {
            clientConfig.getGroupConfig().setPassword(pass);
        }
        if (address != null) {
            clientConfig.getNetworkConfig().addAddress(new String[]{address});
        }
        clientConfig.getNetworkConfig().setSmartRouting(true);
        clientConfig.getNetworkConfig().setRedoOperation(true);
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        return this.client;
    }

    @Override
    public void unloadInstance() throws CacheException {
        if (this.client == null) {
            return;
        }
        try {
            this.client.getLifecycleService().shutdown();
            this.client = null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

