/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.entity;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.entity.NonStrictReadWriteAccessStrategy;
import com.hazelcast.hibernate.entity.ReadOnlyAccessStrategy;
import com.hazelcast.hibernate.entity.ReadWriteAccessStrategy;
import com.hazelcast.hibernate.region.AbstractTransactionalDataRegion;
import java.util.Properties;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.EntityRegionAccessStrategy;

public class HazelcastEntityRegion
extends AbstractTransactionalDataRegion
implements EntityRegion {
    public HazelcastEntityRegion(HazelcastInstance instance, String name, Properties props, CacheDataDescription metadata) {
        super(instance, name, props, metadata);
    }

    public EntityRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (null == accessType) {
            throw new CacheException("Got null AccessType while attempting to determine a proper EntityRegionAccessStrategy. This can't happen!");
        }
        if (AccessType.READ_ONLY.equals(accessType)) {
            return new ReadOnlyAccessStrategy(this, this.props);
        }
        if (AccessType.NONSTRICT_READ_WRITE.equals(accessType)) {
            return new NonStrictReadWriteAccessStrategy(this, this.props);
        }
        if (AccessType.READ_WRITE.equals(accessType)) {
            return new ReadWriteAccessStrategy(this, this.props);
        }
        if (AccessType.TRANSACTIONAL.equals(accessType)) {
            throw new CacheException("Transactional access is not currently supported by Hazelcast.");
        }
        throw new CacheException("Got unknown AccessType \"" + accessType + "\" while attempting to build EntityRegionAccessStrategy.");
    }
}

