/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.access;

import com.hazelcast.core.IMap;
import com.hazelcast.hibernate.access.AccessDelegate;
import com.hazelcast.hibernate.region.AbstractTransactionalDataRegion;
import com.hazelcast.hibernate.region.HazelcastRegion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Comparator;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAccessDelegate<T extends HazelcastRegion>
implements AccessDelegate<T> {
    protected final ILogger LOG = Logger.getLogger((String)this.getClass().getName());
    private final T hazelcastRegion;
    protected final Comparator<Object> versionComparator;

    protected AbstractAccessDelegate(T hazelcastRegion, Properties props) {
        this.hazelcastRegion = hazelcastRegion;
        this.versionComparator = hazelcastRegion instanceof AbstractTransactionalDataRegion ? ((AbstractTransactionalDataRegion)hazelcastRegion).getCacheDataDescription().getVersionComparator() : null;
    }

    @Override
    public final T getHazelcastRegion() {
        return this.hazelcastRegion;
    }

    @Override
    public final IMap getCache() {
        return this.hazelcastRegion.getCache();
    }

    protected boolean putInToCache(Object key, Object value) {
        this.getCache().set(key, value, 0L, TimeUnit.SECONDS);
        return true;
    }

    @Override
    public Object get(Object key, long txTimestamp) throws CacheException {
        return this.getCache().get(key);
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.putFromLoad(key, value, txTimestamp, version, true);
    }

    @Override
    public void remove(Object key) throws CacheException {
        this.getCache().remove(key);
    }

    @Override
    public void removeAll() throws CacheException {
        this.hazelcastRegion.clearCache();
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.remove(key);
    }

    @Override
    public void evictAll() throws CacheException {
        this.hazelcastRegion.clearCache();
    }

    @Override
    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    @Override
    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    @Override
    public boolean insert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return false;
    }
}

