/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.commandline;

import com.hazelcast.commandline.ExceptionHandler;
import com.hazelcast.commandline.VersionProvider;
import com.hazelcast.core.server.HazelcastMemberStarter;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.function.RunnableEx;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import picocli.CommandLine;

@CommandLine.Command(name="hz", description={"Command line utility to start Hazelcast server process.%n%nGlobal options are:%n"}, versionProvider=VersionProvider.class, mixinStandardHelpOptions=true, sortOptions=false)
public class HazelcastServerCommandLine {
    private final RunnableEx start;

    public HazelcastServerCommandLine() {
        this.start = (RunnableEx & Serializable)() -> HazelcastMemberStarter.main((String[])new String[0]);
    }

    HazelcastServerCommandLine(RunnableEx start) {
        this.start = start;
    }

    public static void main(String[] args) {
        HazelcastServerCommandLine.runCommandLine(args);
    }

    private static void runCommandLine(String[] args) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        CommandLine cmd = new CommandLine((Object)new HazelcastServerCommandLine()).setOut(HazelcastServerCommandLine.createPrintWriter(out)).setErr(HazelcastServerCommandLine.createPrintWriter(err)).setTrimQuotes(true).setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new ExceptionHandler());
        cmd.execute(args);
        String version = BuildInfoProvider.getBuildInfo().getVersion();
        cmd.getCommandSpec().usageMessage().header(new String[]{"Hazelcast " + version});
        if (args.length == 0) {
            cmd.usage(out);
        }
    }

    static PrintWriter createPrintWriter(PrintStream printStream) {
        return new PrintWriter(new OutputStreamWriter((OutputStream)printStream, StandardCharsets.UTF_8));
    }

    @CommandLine.Command(description={"Starts a new Hazelcast member"}, mixinStandardHelpOptions=true, sortOptions=false)
    void start(@CommandLine.Option(names={"-c", "--config"}, paramLabel="<file>", description={"Use <file> for Hazelcast configuration. Accepted formats are XML and YAML. "}) String configFilePath, @CommandLine.Option(names={"-p", "--port"}, paramLabel="<port>", description={"Bind to the specified <port>. Please note that if the specified port is in use, it will auto-increment to the first free port. (default: 5701)"}) String port, @CommandLine.Option(names={"-i", "--interface"}, paramLabel="<interface>", description={"Bind to the specified <interface>."}) String hzInterface) {
        if (!StringUtil.isNullOrEmpty((String)configFilePath)) {
            System.setProperty("hazelcast.config", configFilePath);
        }
        if (!StringUtil.isNullOrEmpty((String)port)) {
            System.setProperty("hz.network.port.port", port);
        }
        if (!StringUtil.isNullOrEmpty((String)hzInterface)) {
            System.setProperty("hz.network.interfaces.enabled", "true");
            System.setProperty("hz.socket.bind.any", "false");
            System.setProperty("hz.network.interfaces.interfaces.interface1", hzInterface);
        }
        this.start.run();
    }
}

