/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.security;

import com.hazelcast.aws.impl.DescribeInstances;
import com.hazelcast.aws.security.RFC2104HMAC;
import com.hazelcast.aws.utility.AwsURLEncoder;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EC2RequestSigner {
    private static final String HTTP_VERB = "GET\n";
    private static final String HTTP_REQUEST_URI = "/\n";
    private final String secretKey;

    public EC2RequestSigner(String secretKey) {
        if (secretKey == null) {
            throw new IllegalArgumentException("AWS secret key is required!");
        }
        this.secretKey = secretKey;
    }

    public void sign(DescribeInstances request, String endpoint) {
        String canonicalizedQueryString = this.getCanonicalizedQueryString(request);
        String stringToSign = HTTP_VERB + endpoint + "\n" + HTTP_REQUEST_URI + canonicalizedQueryString;
        String signature = this.signTheString(stringToSign);
        request.putSignature(signature);
    }

    private String signTheString(String stringToSign) {
        String signature = null;
        try {
            signature = RFC2104HMAC.calculateRFC2104HMAC(stringToSign, this.secretKey);
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
        return signature;
    }

    private String getCanonicalizedQueryString(DescribeInstances request) {
        List<String> components = this.getListOfEntries(request.getAttributes());
        Collections.sort(components);
        return this.getCanonicalizedQueryString(components);
    }

    private void addComponents(List<String> components, Map<String, String> attributes, String key) {
        components.add(AwsURLEncoder.urlEncode(key) + "=" + AwsURLEncoder.urlEncode(attributes.get(key)));
    }

    private List<String> getListOfEntries(Map<String, String> entries) {
        ArrayList<String> components = new ArrayList<String>();
        for (String key : entries.keySet()) {
            this.addComponents(components, entries, key);
        }
        return components;
    }

    private String getCanonicalizedQueryString(List<String> list) {
        Iterator<String> it = list.iterator();
        StringBuilder result = new StringBuilder(it.next());
        while (it.hasNext()) {
            result.append("&").append(it.next());
        }
        return result.toString();
    }
}

