/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.aws.AWSClient;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.TcpIpJoiner;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpIpJoinerOverAWS
extends TcpIpJoiner {
    final AWSClient aws;
    final ILogger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    final String groupName;

    public TcpIpJoinerOverAWS(Node node) {
        super(node);
        AwsConfig awsConfig = node.getConfig().getNetworkConfig().getJoin().getAwsConfig();
        this.aws = new AWSClient(awsConfig);
        if (awsConfig.getRegion() != null && awsConfig.getRegion().length() > 0) {
            this.aws.setEndpoint("ec2." + awsConfig.getRegion() + ".amazonaws.com");
        }
        this.groupName = awsConfig.getSecurityGroupName();
    }

    protected Collection<String> getMembers() {
        try {
            List<String> list = this.aws.getPrivateIpAddresses(this.config.getNetworkConfig().getJoin().getAwsConfig());
            this.logger.log(Level.FINEST, "The list of possible members are: " + list);
            return list;
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }
}

