/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.ICache;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.cache.impl.ClientCacheStatisticsImpl;
import com.hazelcast.client.cache.impl.OneShotExecutionCallback;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheAddNearCacheInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveEntryListenerCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;

public class NearCachedClientCacheProxy<K, V>
extends ClientCacheProxy<K, V> {
    private final int minConsistentNearCacheSupportingServerVersion = BuildInfo.calculateVersion((String)"3.8");
    private boolean cacheOnUpdate;
    private boolean invalidateOnChange;
    private boolean serializeKeys;
    private NearCacheManager nearCacheManager;
    private NearCache<Object, Object> nearCache;
    private String nearCacheMembershipRegistrationId;

    NearCachedClientCacheProxy(CacheConfig<K, V> cacheConfig, ClientContext context) {
        super(cacheConfig, context);
    }

    public NearCache getNearCache() {
        return this.nearCache;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        ClientConfig clientConfig = this.getContext().getClientConfig();
        NearCacheConfig nearCacheConfig = NearCachedClientCacheProxy.checkNearCacheConfig(clientConfig.getNearCacheConfig(this.name), clientConfig.getNativeMemoryConfig());
        this.cacheOnUpdate = NearCachedClientCacheProxy.isCacheOnUpdate(nearCacheConfig, this.nameWithPrefix, this.logger);
        this.invalidateOnChange = nearCacheConfig.isInvalidateOnChange();
        this.serializeKeys = nearCacheConfig.isSerializeKeys();
        ICacheDataStructureAdapter adapter = new ICacheDataStructureAdapter((ICache)this);
        this.nearCacheManager = this.getContext().getNearCacheManager();
        this.nearCache = this.nearCacheManager.getOrCreateNearCache(this.nameWithPrefix, nearCacheConfig, (DataStructureAdapter)adapter);
        CacheStatistics localCacheStatistics = super.getLocalCacheStatistics();
        ((ClientCacheStatisticsImpl)localCacheStatistics).setNearCacheStats(this.nearCache.getNearCacheStats());
        this.registerInvalidationListener();
    }

    @Override
    protected V getSyncInternal(Object key, ExpiryPolicy expiryPolicy) {
        key = this.serializeKeys ? this.toData(key) : key;
        Object value = this.getCachedValue(key, true);
        if (value != NearCache.NOT_CACHED) {
            return (V)value;
        }
        try {
            Data keyData = this.toData(key);
            long reservationId = this.nearCache.tryReserveForUpdate(key, keyData);
            value = super.getSyncInternal(keyData, expiryPolicy);
            if (reservationId != -1L) {
                value = this.tryPublishReserved(key, value, reservationId);
            }
            return (V)value;
        }
        catch (Throwable throwable) {
            this.invalidateNearCache(key);
            throw ExceptionUtil.rethrow((Throwable)throwable);
        }
    }

    @Override
    protected InternalCompletableFuture<V> getAsyncInternal(Object key, ExpiryPolicy expiryPolicy, ExecutionCallback<V> callback) {
        key = this.serializeKeys ? this.toData(key) : key;
        Object value = this.getCachedValue(key, false);
        if (value != NearCache.NOT_CACHED) {
            return new CompletedFuture(this.getSerializationService(), value, (Executor)this.getContext().getExecutionService().getUserExecutor());
        }
        try {
            Data keyData = this.toData(key);
            long reservationId = this.nearCache.tryReserveForUpdate(key, keyData);
            GetAsyncCallback getAsyncCallback = new GetAsyncCallback(key, reservationId, callback);
            return super.getAsyncInternal(keyData, expiryPolicy, getAsyncCallback);
        }
        catch (Throwable t) {
            this.invalidateNearCache(key);
            throw ExceptionUtil.rethrow((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onPutSyncInternal(K key, V value, Data keyData, Data valueData) {
        try {
            super.onPutSyncInternal(key, value, keyData, valueData);
            this.cacheOrInvalidate(this.serializeKeys ? keyData : key, keyData, value, valueData);
        }
        catch (Throwable throwable) {
            this.cacheOrInvalidate(this.serializeKeys ? keyData : key, keyData, value, valueData);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onPutIfAbsentSyncInternal(K key, V value, Data keyData, Data valueData) {
        try {
            super.onPutIfAbsentSyncInternal(key, value, keyData, valueData);
            this.cacheOrInvalidate(this.serializeKeys ? keyData : key, keyData, value, valueData);
        }
        catch (Throwable throwable) {
            this.cacheOrInvalidate(this.serializeKeys ? keyData : key, keyData, value, valueData);
            throw throwable;
        }
    }

    @Override
    protected void onPutIfAbsentAsyncInternal(K key, V value, Data keyData, Data valueData, ClientDelegatingFuture<Boolean> delegatingFuture, ExecutionCallback<Boolean> callback) {
        Object callbackKey = this.serializeKeys ? keyData : key;
        CacheOrInvalidateCallback<Boolean> wrapped = new CacheOrInvalidateCallback<Boolean>(callbackKey, keyData, value, valueData, callback);
        super.onPutIfAbsentAsyncInternal(key, value, keyData, valueData, delegatingFuture, wrapped);
    }

    @Override
    protected ClientDelegatingFuture<V> wrapPutAsyncFuture(K key, V value, Data keyData, Data valueData, ClientInvocationFuture invocationFuture, OneShotExecutionCallback<V> callback) {
        Object callbackKey = this.serializeKeys ? keyData : key;
        PutAsyncOneShotCallback wrapped = new PutAsyncOneShotCallback(callbackKey, keyData, value, valueData, callback);
        return super.wrapPutAsyncFuture(key, value, keyData, valueData, invocationFuture, wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> void onGetAndRemoveAsyncInternal(K key, Data keyData, ClientDelegatingFuture<T> delegatingFuture, ExecutionCallback<T> callback) {
        try {
            super.onGetAndRemoveAsyncInternal(key, keyData, delegatingFuture, callback);
            this.invalidateNearCache(this.serializeKeys ? keyData : key);
        }
        catch (Throwable throwable) {
            this.invalidateNearCache(this.serializeKeys ? keyData : key);
            throw throwable;
        }
    }

    @Override
    protected <T> void onReplaceInternalAsync(K key, V value, Data keyData, Data valueData, ClientDelegatingFuture<T> delegatingFuture, ExecutionCallback<T> callback) {
        Object callbackKey = this.serializeKeys ? keyData : key;
        CacheOrInvalidateCallback<T> wrapped = new CacheOrInvalidateCallback<T>(callbackKey, keyData, value, valueData, callback);
        super.onReplaceInternalAsync(key, value, keyData, valueData, delegatingFuture, wrapped);
    }

    @Override
    protected <T> void onReplaceAndGetAsync(K key, V value, Data keyData, Data valueData, ClientDelegatingFuture<T> delegatingFuture, ExecutionCallback<T> callback) {
        Object callbackKey = this.serializeKeys ? keyData : key;
        CacheOrInvalidateCallback<T> wrapped = new CacheOrInvalidateCallback<T>(callbackKey, keyData, value, valueData, callback);
        super.onReplaceAndGetAsync(key, value, keyData, valueData, delegatingFuture, wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getAllInternal(Set<? extends K> keys, Collection<Data> dataKeys, ExpiryPolicy expiryPolicy, List<Object> resultingKeyValuePairs, long startNanos) {
        if (this.serializeKeys) {
            this.toDataKeysWithReservations(keys, (Collection<Data>)dataKeys, null, null);
        }
        LinkedList<K> ncKeys = this.serializeKeys ? dataKeys : new LinkedList<K>(keys);
        this.populateResultFromNearCache(ncKeys, resultingKeyValuePairs);
        if (ncKeys.isEmpty()) {
            return;
        }
        Map reservations = MapUtil.createHashMap((int)ncKeys.size());
        Map reverseKeyMap = null;
        if (!this.serializeKeys) {
            reverseKeyMap = MapUtil.createHashMap((int)ncKeys.size());
            this.toDataKeysWithReservations(ncKeys, dataKeys, reservations, reverseKeyMap);
        } else {
            this.createNearCacheReservations(ncKeys, reservations);
        }
        try {
            int currentSize = resultingKeyValuePairs.size();
            super.getAllInternal(keys, dataKeys, expiryPolicy, resultingKeyValuePairs, startNanos);
            this.populateResultFromRemote(currentSize, resultingKeyValuePairs, reservations, reverseKeyMap);
        }
        finally {
            this.releaseRemainingReservedKeys(reservations);
        }
    }

    private void toDataKeysWithReservations(Collection<?> keys, Collection<Data> dataKeys, Map<Object, Long> reservations, Map<Data, Object> reverseKeyMap) {
        for (Object key : keys) {
            long reservationId;
            Data keyData = this.toData(key);
            if (reservations != null && (reservationId = this.tryReserveForUpdate(key, keyData)) != -1L) {
                reservations.put(key, reservationId);
            }
            if (reverseKeyMap != null) {
                reverseKeyMap.put(keyData, key);
            }
            dataKeys.add(keyData);
        }
    }

    private void populateResultFromNearCache(Collection<?> keys, List<Object> resultingKeyValuePairs) {
        Iterator<?> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object cached = this.getCachedValue(key, true);
            if (cached == NearCache.NOT_CACHED) continue;
            resultingKeyValuePairs.add(key);
            resultingKeyValuePairs.add(cached);
            iterator.remove();
        }
    }

    private void createNearCacheReservations(Collection<Data> dataKeys, Map<Object, Long> reservations) {
        for (Data key : dataKeys) {
            long reservationId = this.tryReserveForUpdate(key, key);
            if (reservationId == -1L) continue;
            reservations.put(key, reservationId);
        }
    }

    private void populateResultFromRemote(int currentSize, List<Object> resultingKeyValuePairs, Map<Object, Long> reservations, Map<Data, Object> reverseKeyMap) {
        for (int i = currentSize; i < resultingKeyValuePairs.size(); i += 2) {
            Long reservationId;
            Data ncKey;
            Data keyData = (Data)resultingKeyValuePairs.get(i);
            Data valueData = (Data)resultingKeyValuePairs.get(i + 1);
            Object object = ncKey = this.serializeKeys ? keyData : reverseKeyMap.get(keyData);
            if (!this.serializeKeys) {
                resultingKeyValuePairs.set(i, ncKey);
            }
            if ((reservationId = reservations.get(ncKey)) == null) continue;
            Object cachedValue = this.tryPublishReserved(ncKey, valueData, reservationId);
            resultingKeyValuePairs.set(i + 1, cachedValue);
            reservations.remove(ncKey);
        }
    }

    @Override
    protected void putAllInternal(Map<? extends K, ? extends V> map, ExpiryPolicy expiryPolicy, Map<Object, Data> keyMap, List<Map.Entry<Data, Data>>[] entriesPerPartition, long startNanos) {
        try {
            if (!this.serializeKeys) {
                keyMap = MapUtil.createHashMap((int)map.size());
            }
            super.putAllInternal(map, expiryPolicy, keyMap, entriesPerPartition, startNanos);
            this.cacheOrInvalidate(map, keyMap, entriesPerPartition, true);
        }
        catch (Throwable t) {
            this.cacheOrInvalidate(map, keyMap, entriesPerPartition, false);
            throw ExceptionUtil.rethrow((Throwable)t);
        }
    }

    private void cacheOrInvalidate(Map<? extends K, ? extends V> map, Map<Object, Data> keyMap, List<Map.Entry<Data, Data>>[] entriesPerPartition, boolean isCacheOrInvalidate) {
        if (this.serializeKeys) {
            for (int partitionId = 0; partitionId < entriesPerPartition.length; ++partitionId) {
                List<Map.Entry<Data, Data>> entries = entriesPerPartition[partitionId];
                if (entries == null) continue;
                for (Map.Entry<Data, Data> entry : entries) {
                    Data key = entry.getKey();
                    if (isCacheOrInvalidate) {
                        this.cacheOrInvalidate(key, key, null, entry.getValue());
                        continue;
                    }
                    this.invalidateNearCache(key);
                }
            }
        } else {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K key = entry.getKey();
                if (isCacheOrInvalidate) {
                    this.cacheOrInvalidate(key, keyMap.get(key), entry.getValue(), null);
                    continue;
                }
                this.invalidateNearCache(key);
            }
        }
    }

    @Override
    protected boolean containsKeyInternal(Object key) {
        key = this.serializeKeys ? this.toData(key) : key;
        Object cached = this.getCachedValue(key, false);
        if (cached != NearCache.NOT_CACHED) {
            return true;
        }
        return super.containsKeyInternal(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadAllInternal(Set<? extends K> keys, List<Data> dataKeys, boolean replaceExistingValues, CompletionListener completionListener) {
        try {
            super.loadAllInternal(keys, dataKeys, replaceExistingValues, completionListener);
        }
        finally {
            if (this.serializeKeys) {
                for (Data dataKey : dataKeys) {
                    this.invalidateNearCache(dataKey);
                }
            } else {
                for (K key : keys) {
                    this.invalidateNearCache(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeAllKeysInternal(Set<? extends K> keys, Collection<Data> dataKeys, long startNanos) {
        try {
            super.removeAllKeysInternal(keys, dataKeys, startNanos);
        }
        finally {
            if (this.serializeKeys) {
                for (Data dataKey : dataKeys) {
                    this.invalidateNearCache(dataKey);
                }
            } else {
                for (K key : keys) {
                    this.invalidateNearCache(key);
                }
            }
        }
    }

    @Override
    public void onRemoveSyncInternal(Object key, Data keyData) {
        try {
            super.onRemoveSyncInternal(key, keyData);
            this.invalidateNearCache(this.serializeKeys ? keyData : key);
        }
        catch (Throwable throwable) {
            this.invalidateNearCache(this.serializeKeys ? keyData : key);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRemoveAsyncInternal(Object key, Data keyData, ClientDelegatingFuture future, ExecutionCallback callback) {
        try {
            super.onRemoveAsyncInternal(key, keyData, future, callback);
            this.invalidateNearCache(this.serializeKeys ? keyData : key);
        }
        catch (Throwable throwable) {
            this.invalidateNearCache(this.serializeKeys ? keyData : key);
            throw throwable;
        }
    }

    @Override
    public void removeAll() {
        try {
            super.removeAll();
        }
        finally {
            this.nearCache.clear();
        }
    }

    @Override
    public void clear() {
        try {
            super.clear();
        }
        finally {
            this.nearCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeInternal(Object key, Data epData, Object[] arguments) {
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            Object object = super.invokeInternal(key, epData, arguments);
            return object;
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    @Override
    public void close() {
        this.removeInvalidationListener();
        this.nearCacheManager.clearNearCache(this.nearCache.getName());
        super.close();
    }

    @Override
    protected void onDestroy() {
        this.removeInvalidationListener();
        this.nearCacheManager.destroyNearCache(this.nearCache.getName());
        super.onDestroy();
    }

    private Object getCachedValue(Object key, boolean deserializeValue) {
        Object cached = this.nearCache.get(key);
        assert (cached != NearCache.CACHED_AS_NULL);
        if (cached == null) {
            return NearCache.NOT_CACHED;
        }
        return deserializeValue ? this.toObject(cached) : cached;
    }

    private void cacheOrInvalidate(Object key, Data keyData, V value, Data valueData) {
        if (this.cacheOnUpdate) {
            Object valueToStore = this.nearCache.selectToSave(new Object[]{valueData, value});
            this.nearCache.put(key, keyData, valueToStore);
        } else {
            this.invalidateNearCache(key);
        }
    }

    private void invalidateNearCache(Object key) {
        assert (key != null);
        this.nearCache.remove(key);
    }

    private long tryReserveForUpdate(Object key, Data keyData) {
        return this.nearCache.tryReserveForUpdate(key, keyData);
    }

    private Object tryPublishReserved(Object key, Object remoteValue, long reservationId, boolean deserialize) {
        assert (remoteValue != NearCache.NOT_CACHED);
        if (remoteValue == null) {
            this.invalidateNearCache(key);
            return null;
        }
        Object cachedValue = null;
        if (reservationId != -1L) {
            cachedValue = this.nearCache.tryPublishReserved(key, remoteValue, reservationId, deserialize);
        }
        return cachedValue == null ? remoteValue : cachedValue;
    }

    private Object tryPublishReserved(Object key, Object remoteValue, long reservationId) {
        return this.tryPublishReserved(key, remoteValue, reservationId, true);
    }

    private void releaseRemainingReservedKeys(Map<Object, Long> reservedKeys) {
        for (Object key : reservedKeys.keySet()) {
            this.nearCache.remove(key);
        }
    }

    public String addNearCacheInvalidationListener(EventHandler eventHandler) {
        return this.registerListener(this.createInvalidationListenerCodec(), eventHandler);
    }

    private void registerInvalidationListener() {
        if (!this.invalidateOnChange) {
            return;
        }
        EventHandler eventHandler = this.createInvalidationEventHandler();
        this.nearCacheMembershipRegistrationId = this.addNearCacheInvalidationListener(eventHandler);
    }

    private EventHandler createInvalidationEventHandler() {
        return new ConnectedServerVersionAwareNearCacheEventHandler();
    }

    private ListenerMessageCodec createInvalidationListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                if (NearCachedClientCacheProxy.this.supportsRepairableNearCache()) {
                    return CacheAddNearCacheInvalidationListenerCodec.encodeRequest((String)NearCachedClientCacheProxy.this.nameWithPrefix, (boolean)localOnly);
                }
                return CacheAddInvalidationListenerCodec.encodeRequest((String)NearCachedClientCacheProxy.this.nameWithPrefix, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                if (NearCachedClientCacheProxy.this.supportsRepairableNearCache()) {
                    return CacheAddNearCacheInvalidationListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
                }
                return CacheAddInvalidationListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return CacheRemoveEntryListenerCodec.encodeRequest((String)NearCachedClientCacheProxy.this.nameWithPrefix, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return CacheRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    private int getConnectedServerVersion() {
        HazelcastClientInstanceImpl client = this.getClient();
        ClientConnectionManager connectionManager = client.getConnectionManager();
        ClientConnection connection = connectionManager.getOwnerConnection();
        if (connection == null) {
            this.logger.warning(String.format("No owner connection is available, near cached cache %s will be started in legacy mode", this.name));
            return -1;
        }
        return connection.getConnectedServerVersion();
    }

    private boolean supportsRepairableNearCache() {
        return this.getConnectedServerVersion() >= this.minConsistentNearCacheSupportingServerVersion;
    }

    private void removeInvalidationListener() {
        if (!this.invalidateOnChange) {
            return;
        }
        String registrationId = this.nearCacheMembershipRegistrationId;
        if (registrationId != null) {
            this.getContext().getRepairingTask("hz:impl:cacheService").deregisterHandler(this.name);
            this.getContext().getListenerService().deregisterListener(registrationId);
        }
    }

    static boolean isCacheOnUpdate(NearCacheConfig nearCacheConfig, String cacheName, ILogger logger) {
        NearCacheConfig.LocalUpdatePolicy localUpdatePolicy = nearCacheConfig.getLocalUpdatePolicy();
        if (localUpdatePolicy == NearCacheConfig.LocalUpdatePolicy.CACHE) {
            logger.warning(String.format("Deprecated local update policy is found for cache `%s`. The policy `%s` is subject to remove in further releases. Instead you can use `%s`", cacheName, NearCacheConfig.LocalUpdatePolicy.CACHE, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE));
            return true;
        }
        return localUpdatePolicy == NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE;
    }

    private static NearCacheConfig checkNearCacheConfig(NearCacheConfig nearCacheConfig, NativeMemoryConfig nativeMemoryConfig) {
        InMemoryFormat inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        if (inMemoryFormat != InMemoryFormat.NATIVE) {
            return nearCacheConfig;
        }
        Preconditions.checkTrue((boolean)nativeMemoryConfig.isEnabled(), (String)"Enable native memory config to use NATIVE in-memory-format for Near Cache");
        return nearCacheConfig;
    }

    private final class Pre38NearCacheEventHandler
    extends CacheAddInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private String clientUuid;

        private Pre38NearCacheEventHandler() {
            this.clientUuid = NearCachedClientCacheProxy.this.getContext().getClusterService().getLocalClient().getUuid();
        }

        public void handle(String name, Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            if (this.clientUuid.equals(sourceUuid)) {
                return;
            }
            if (key != null) {
                NearCachedClientCacheProxy.this.nearCache.remove(NearCachedClientCacheProxy.this.serializeKeys ? key : NearCachedClientCacheProxy.this.toObject(key));
            } else {
                NearCachedClientCacheProxy.this.nearCache.clear();
            }
        }

        public void handle(String name, Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            if (sourceUuids != null && !sourceUuids.isEmpty()) {
                Iterator<Data> keysIt = keys.iterator();
                Iterator<String> sourceUuidsIt = sourceUuids.iterator();
                while (keysIt.hasNext() && sourceUuidsIt.hasNext()) {
                    Data key = keysIt.next();
                    String sourceUuid = sourceUuidsIt.next();
                    if (this.clientUuid.equals(sourceUuid)) continue;
                    NearCachedClientCacheProxy.this.nearCache.remove(NearCachedClientCacheProxy.this.serializeKeys ? key : NearCachedClientCacheProxy.this.toObject(key));
                }
            } else {
                for (Data key : keys) {
                    NearCachedClientCacheProxy.this.nearCache.remove(NearCachedClientCacheProxy.this.serializeKeys ? key : NearCachedClientCacheProxy.this.toObject(key));
                }
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
            NearCachedClientCacheProxy.this.nearCache.clear();
        }
    }

    private final class RepairableNearCacheEventHandler
    extends CacheAddNearCacheInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private volatile RepairingHandler repairingHandler;

        private RepairableNearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            NearCachedClientCacheProxy.this.nearCache.clear();
            this.getRepairingTask().deregisterHandler(NearCachedClientCacheProxy.this.nameWithPrefix);
        }

        @Override
        public void onListenerRegister() {
            NearCachedClientCacheProxy.this.nearCache.clear();
            this.repairingHandler = this.getRepairingTask().registerAndGetHandler(NearCachedClientCacheProxy.this.nameWithPrefix, NearCachedClientCacheProxy.this.nearCache);
        }

        public void handle(String name, Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            this.repairingHandler.handle(key, sourceUuid, partitionUuid, sequence);
        }

        public void handle(String name, Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            this.repairingHandler.handle(keys, sourceUuids, partitionUuids, sequences);
        }

        private RepairingTask getRepairingTask() {
            return NearCachedClientCacheProxy.this.getContext().getRepairingTask("hz:impl:cacheService");
        }
    }

    private final class ConnectedServerVersionAwareNearCacheEventHandler
    implements EventHandler<ClientMessage> {
        private final RepairableNearCacheEventHandler repairingEventHandler;
        private final Pre38NearCacheEventHandler pre38EventHandler;
        private volatile boolean supportsRepairableNearCache;

        private ConnectedServerVersionAwareNearCacheEventHandler() {
            this.repairingEventHandler = new RepairableNearCacheEventHandler();
            this.pre38EventHandler = new Pre38NearCacheEventHandler();
        }

        @Override
        public void beforeListenerRegister() {
            this.pre38EventHandler.beforeListenerRegister();
            this.repairingEventHandler.beforeListenerRegister();
        }

        @Override
        public void onListenerRegister() {
            this.supportsRepairableNearCache = NearCachedClientCacheProxy.this.supportsRepairableNearCache();
            if (this.supportsRepairableNearCache) {
                this.repairingEventHandler.onListenerRegister();
            } else {
                this.pre38EventHandler.onListenerRegister();
            }
        }

        @Override
        public void handle(ClientMessage clientMessage) {
            if (this.supportsRepairableNearCache) {
                this.repairingEventHandler.handle(clientMessage);
            } else {
                this.pre38EventHandler.handle(clientMessage);
            }
        }
    }

    private final class CacheOrInvalidateCallback<T>
    implements ExecutionCallback<T> {
        private final Object key;
        private final Data keyData;
        private final V value;
        private final Data valueData;
        private final ExecutionCallback<T> callback;

        CacheOrInvalidateCallback(Object key, Data keyData, V value, Data valueData, ExecutionCallback<T> callback) {
            this.key = key;
            this.keyData = keyData;
            this.value = value;
            this.valueData = valueData;
            this.callback = callback;
        }

        public void onResponse(T response) {
            try {
                if (this.callback != null) {
                    this.callback.onResponse(response);
                }
            }
            finally {
                NearCachedClientCacheProxy.this.cacheOrInvalidate(this.key, this.keyData, this.value, this.valueData);
            }
        }

        public void onFailure(Throwable t) {
            try {
                if (this.callback != null) {
                    this.callback.onFailure(t);
                }
            }
            finally {
                NearCachedClientCacheProxy.this.invalidateNearCache(this.key);
            }
        }
    }

    private final class PutAsyncOneShotCallback
    extends OneShotExecutionCallback<V> {
        private final Object key;
        private final Data keyData;
        private final V newValue;
        private final Data newValueData;
        private final OneShotExecutionCallback<V> statsCallback;

        private PutAsyncOneShotCallback(Object key, Data keyData, V newValue, Data newValueData, OneShotExecutionCallback<V> callback) {
            this.key = key;
            this.keyData = keyData;
            this.newValue = newValue;
            this.newValueData = newValueData;
            this.statsCallback = callback;
        }

        @Override
        protected void onResponseInternal(V response) {
            try {
                if (this.statsCallback != null) {
                    this.statsCallback.onResponseInternal(response);
                }
            }
            finally {
                NearCachedClientCacheProxy.this.cacheOrInvalidate(this.key, this.keyData, this.newValue, this.newValueData);
            }
        }

        @Override
        protected void onFailureInternal(Throwable t) {
            try {
                if (this.statsCallback != null) {
                    this.statsCallback.onFailureInternal(t);
                }
            }
            finally {
                NearCachedClientCacheProxy.this.invalidateNearCache(this.key);
            }
        }
    }

    private final class GetAsyncCallback
    implements ExecutionCallback<V> {
        private final Object key;
        private final long reservationId;
        private final ExecutionCallback<V> callback;

        GetAsyncCallback(Object key, long reservationId, ExecutionCallback<V> callback) {
            this.key = key;
            this.reservationId = reservationId;
            this.callback = callback;
        }

        public void onResponse(V valueData) {
            try {
                if (this.callback != null) {
                    this.callback.onResponse(valueData);
                }
            }
            finally {
                NearCachedClientCacheProxy.this.tryPublishReserved(this.key, valueData, this.reservationId, false);
            }
        }

        public void onFailure(Throwable t) {
            try {
                if (this.callback != null) {
                    this.callback.onFailure(t);
                }
            }
            finally {
                NearCachedClientCacheProxy.this.invalidateNearCache(this.key);
            }
        }
    }
}

