/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache.subscriber;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.Future;

public class ClientInvokerWrapper
implements InvokerWrapper {
    private final QueryCacheContext context;
    private final ClientContext clientContext;

    public ClientInvokerWrapper(QueryCacheContext context, ClientContext clientContext) {
        this.context = context;
        this.clientContext = clientContext;
    }

    public Future invokeOnPartitionOwner(Object request, int partitionId) {
        Preconditions.checkNotNull((Object)request, (String)"request cannot be null");
        Preconditions.checkNotNegative((int)partitionId, (String)"partitionId");
        ClientMessage clientRequest = (ClientMessage)request;
        ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), clientRequest, partitionId);
        return clientInvocation.invoke();
    }

    public Object invokeOnAllPartitions(Object request) {
        try {
            ClientMessage clientRequest = (ClientMessage)request;
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientRequest).invoke();
            Object result = future.get();
            return this.context.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Future invokeOnTarget(Object request, Address address) {
        Preconditions.checkNotNull((Object)request, (String)"request cannot be null");
        Preconditions.checkNotNull((Object)address, (String)"address cannot be null");
        ClientMessage clientRequest = (ClientMessage)request;
        ClientInvocation invocation = new ClientInvocation(this.getClient(), clientRequest, address);
        return invocation.invoke();
    }

    public Object invoke(Object request) {
        Preconditions.checkNotNull((Object)request, (String)"request cannot be null");
        ClientInvocation invocation = new ClientInvocation(this.getClient(), (ClientMessage)request);
        ClientInvocationFuture future = invocation.invoke();
        try {
            Object result = future.get();
            return this.context.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public void executeOperation(Operation op) {
        throw new UnsupportedOperationException();
    }

    protected final HazelcastClientInstanceImpl getClient() {
        return (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
    }
}

