/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache.invalidation;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAssignAndGetUuidsCodec;
import com.hazelcast.client.impl.protocol.codec.MapFetchNearCacheInvalidationMetadataCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Member;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataFetcher;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.operation.MapGetInvalidationMetaDataOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.serialization.SerializationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class ClientMapMetaDataFetcher
extends MetaDataFetcher {
    private final ClientClusterService clusterService;
    private final SerializationService serializationService;
    private final HazelcastClientInstanceImpl clientImpl;

    public ClientMapMetaDataFetcher(ClientContext clientContext) {
        super(Logger.getLogger(ClientMapMetaDataFetcher.class));
        this.clusterService = clientContext.getClusterService();
        this.serializationService = clientContext.getSerializationService();
        this.clientImpl = (HazelcastClientInstanceImpl)clientContext.getHazelcastInstance();
    }

    protected List<InternalCompletableFuture> scanMembers(List<String> names) {
        Collection<Member> members = this.clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        ArrayList<InternalCompletableFuture> futures = new ArrayList<InternalCompletableFuture>(members.size());
        for (Member member : members) {
            Address address = member.getAddress();
            ClientMessage message = MapFetchNearCacheInvalidationMetadataCodec.encodeRequest(names, (Address)address);
            ClientInvocation invocation = new ClientInvocation(this.clientImpl, message, address);
            try {
                futures.add((InternalCompletableFuture)invocation.invoke());
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.WARNING)) continue;
                this.logger.log(Level.WARNING, "Cant fetch invalidation meta-data from address + " + address + " + [" + e.getMessage() + "]");
            }
        }
        return futures;
    }

    protected void process(InternalCompletableFuture future, ConcurrentMap<String, RepairingHandler> handlers) {
        block2: {
            try {
                MapGetInvalidationMetaDataOperation.MetaDataResponse response = this.extractResponse(future);
                this.repairUuids(response.getPartitionUuidList(), handlers);
                this.repairSequences(response.getNamePartitionSequenceList(), handlers);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block2;
                this.logger.log(Level.WARNING, "Cant fetch invalidation meta-data [" + e.getMessage() + "]");
            }
        }
    }

    private MapGetInvalidationMetaDataOperation.MetaDataResponse extractResponse(InternalCompletableFuture future) throws InterruptedException, ExecutionException, TimeoutException {
        ClientMessage message = (ClientMessage)future.get(1L, TimeUnit.MINUTES);
        return (MapGetInvalidationMetaDataOperation.MetaDataResponse)this.serializationService.toObject((Object)MapFetchNearCacheInvalidationMetadataCodec.decodeResponse((ClientMessage)message).response);
    }

    public List<Object> assignAndGetUuids() throws Exception {
        ClientMessage request = MapAssignAndGetUuidsCodec.encodeRequest();
        ClientInvocation invocation = new ClientInvocation(this.clientImpl, request);
        MapAssignAndGetUuidsCodec.ResponseParameters responseParameters = MapAssignAndGetUuidsCodec.decodeResponse((ClientMessage)((ClientMessage)invocation.invoke().get()));
        List response = responseParameters.response;
        ArrayList<Object> objects = new ArrayList<Object>(response.size());
        for (Data data : response) {
            objects.add(this.serializationService.toObject((Object)data));
        }
        return objects;
    }
}

