/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.StringUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.executor.PoolExecutorThreadFactory;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LifecycleServiceImpl
implements LifecycleService {
    private static final long TERMINATE_TIMEOUT_SECONDS = 30L;
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentMap<String, LifecycleListener> lifecycleListeners = new ConcurrentHashMap<String, LifecycleListener>();
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final BuildInfo buildInfo;
    private final ExecutorService executor;

    public LifecycleServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new PoolExecutorThreadFactory(client.getThreadGroup(), client.getName() + ".lifecycle-", client.getClientConfig().getClassLoader()));
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (ListenerConfig listenerConfig : listenerConfigs) {
                if (!(listenerConfig.getImplementation() instanceof LifecycleListener)) continue;
                this.addLifecycleListener((LifecycleListener)listenerConfig.getImplementation());
            }
        }
        this.buildInfo = BuildInfoProvider.getBuildInfo();
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTING);
    }

    private ILogger getLogger() {
        return this.client.getLoggingService().getLogger(LifecycleService.class);
    }

    public String addLifecycleListener(LifecycleListener lifecycleListener) {
        String id = UuidUtil.newUnsecureUuidString();
        this.lifecycleListeners.put(id, lifecycleListener);
        return id;
    }

    public boolean removeLifecycleListener(String registrationId) {
        return this.lifecycleListeners.remove(registrationId) != null;
    }

    public void fireLifecycleEvent(LifecycleEvent.LifecycleState lifecycleState) {
        final LifecycleEvent lifecycleEvent = new LifecycleEvent(lifecycleState);
        String revision = this.buildInfo.getRevision();
        if (StringUtil.isNullOrEmpty((String)revision)) {
            revision = "";
        } else {
            String upstreamRevision;
            revision = " - " + revision;
            BuildInfo upstreamInfo = this.buildInfo.getUpstreamBuildInfo();
            if (upstreamInfo != null && !StringUtil.isNullOrEmpty((String)(upstreamRevision = upstreamInfo.getRevision()))) {
                revision = revision + ", " + upstreamRevision;
            }
        }
        this.getLogger().info("HazelcastClient " + this.buildInfo.getVersion() + " (" + this.buildInfo.getBuild() + revision + ") is " + lifecycleEvent.getState());
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (LifecycleListener lifecycleListener : LifecycleServiceImpl.this.lifecycleListeners.values()) {
                    lifecycleListener.stateChanged(lifecycleEvent);
                }
            }
        });
    }

    public void setStarted() {
        this.active.set(true);
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
    }

    public boolean isRunning() {
        return this.active.get();
    }

    public void shutdown() {
        if (!this.active.compareAndSet(true, false)) {
            return;
        }
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
        HazelcastClient.shutdown(this.client.getName());
        this.client.doShutdown();
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN);
        this.shutdownExecutor();
    }

    public void terminate() {
        this.shutdown();
    }

    private void shutdownExecutor() {
        this.executor.shutdown();
        try {
            boolean success = this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!success) {
                this.getLogger().warning("LifecycleService executor awaitTermination could not completed gracefully in 30 seconds. Terminating forcefully.");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.getLogger().warning("LifecycleService executor awaitTermination is interrupted. Terminating forcefully.", (Throwable)e);
            this.executor.shutdownNow();
        }
    }
}

