/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientRegistrationKey;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class ClientNonSmartListenerService
extends ClientListenerServiceImpl {
    private final Map<ClientRegistrationKey, ClientEventRegistration> registrations = new ConcurrentHashMap<ClientRegistrationKey, ClientEventRegistration>();

    public ClientNonSmartListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
    }

    @Override
    public String registerListener(final ListenerMessageCodec codec, final EventHandler handler) {
        Future<String> future = this.registrationExecutor.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String userRegistrationId = UuidUtil.newUnsecureUuidString();
                ClientRegistrationKey registrationKey = new ClientRegistrationKey(userRegistrationId, handler, codec);
                try {
                    ClientEventRegistration registration = ClientNonSmartListenerService.this.invoke(registrationKey);
                    ClientNonSmartListenerService.this.registrations.put(registrationKey, registration);
                }
                catch (Exception e) {
                    throw new HazelcastException("Listener can not be added", (Throwable)e);
                }
                return userRegistrationId;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private ClientEventRegistration invoke(ClientRegistrationKey registrationKey) throws Exception {
        EventHandler handler = registrationKey.getHandler();
        handler.beforeListenerRegister();
        ClientMessage request = registrationKey.getCodec().encodeAddRequest(false);
        ClientInvocation invocation = new ClientInvocation(this.client, request);
        invocation.setEventHandler(handler);
        ClientInvocationFuture future = invocation.invoke();
        String registrationId = registrationKey.getCodec().decodeAddResponse((ClientMessage)future.get());
        handler.onListenerRegister();
        Address address = future.getInvocation().getSendConnection().getRemoteEndpoint();
        Member member = this.client.getClientClusterService().getMember(address);
        return new ClientEventRegistration(registrationId, request.getCorrelationId(), member, registrationKey.getCodec());
    }

    @Override
    public boolean deregisterListener(final String userRegistrationId) {
        Future<Boolean> future = this.registrationExecutor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ClientRegistrationKey key = new ClientRegistrationKey(userRegistrationId);
                ClientEventRegistration registration = (ClientEventRegistration)ClientNonSmartListenerService.this.registrations.get(key);
                if (registration == null) {
                    return false;
                }
                ClientMessage request = registration.getCodec().encodeRemoveRequest(registration.getServerRegistrationId());
                try {
                    ClientInvocationFuture future = new ClientInvocation(ClientNonSmartListenerService.this.client, request).invoke();
                    future.get();
                    ClientNonSmartListenerService.this.removeEventHandler(registration.getCallId());
                    ClientNonSmartListenerService.this.registrations.remove(key);
                }
                catch (Exception e) {
                    throw new HazelcastException("Listener with id " + userRegistrationId + " could not be removed", (Throwable)e);
                }
                return true;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    @Override
    public void start() {
        ArrayList<Member> allClusterMembers = new ArrayList<Member>(this.client.getCluster().getMembers());
        new ReconnectionHandler(allClusterMembers).run();
    }

    @Override
    public void onClusterConnect(ClientConnection clientConnection) {
        this.registrationExecutor.submit(new ReconnectionHandler(clientConnection.getClientUnregisteredMembers()));
    }

    @Override
    public Collection<ClientEventRegistration> getActiveRegistrations(final String uuid) {
        Future<Collection<ClientEventRegistration>> future = this.registrationExecutor.submit(new Callable<Collection<ClientEventRegistration>>(){

            @Override
            public Collection<ClientEventRegistration> call() throws Exception {
                ClientEventRegistration registration = (ClientEventRegistration)ClientNonSmartListenerService.this.registrations.get(new ClientRegistrationKey(uuid));
                if (registration == null) {
                    return Collections.EMPTY_LIST;
                }
                LinkedList<ClientEventRegistration> activeRegistrations = new LinkedList<ClientEventRegistration>();
                if (ClientNonSmartListenerService.this.getEventHandler(registration.getCallId()) != null) {
                    activeRegistrations.add(registration);
                }
                return activeRegistrations;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private class ReconnectionHandler
    implements Runnable {
        private List<Member> clientUnregisteredMembers;

        public ReconnectionHandler(List<Member> clientUnregisteredMembers) {
            this.clientUnregisteredMembers = clientUnregisteredMembers;
        }

        @Override
        public void run() {
            if (ClientNonSmartListenerService.this.registrations.isEmpty()) {
                return;
            }
            if (this.checkReconnectionToTheSameMember()) {
                return;
            }
            this.reRegisterListeners();
        }

        private void reRegisterListeners() {
            for (Map.Entry existingRegistrationEntry : ClientNonSmartListenerService.this.registrations.entrySet()) {
                ClientRegistrationKey key = null;
                try {
                    ClientEventRegistration existingRegistration = (ClientEventRegistration)existingRegistrationEntry.getValue();
                    ClientNonSmartListenerService.this.removeEventHandler(existingRegistration.getCallId());
                    key = (ClientRegistrationKey)existingRegistrationEntry.getKey();
                    ClientEventRegistration registration = ClientNonSmartListenerService.this.invoke(key);
                    ClientNonSmartListenerService.this.registrations.put(key, registration);
                }
                catch (Exception e) {
                    ClientNonSmartListenerService.this.logger.warning("Listener " + key + " could not be added ");
                }
            }
        }

        private boolean checkReconnectionToTheSameMember() {
            ClientClusterService clientClusterService = ClientNonSmartListenerService.this.client.getClientClusterService();
            Address newOwnerAddress = clientClusterService.getOwnerConnectionAddress();
            Member newOwnerMember = clientClusterService.getMember(newOwnerAddress);
            ClientEventRegistration firstRegistration = (ClientEventRegistration)ClientNonSmartListenerService.this.registrations.values().iterator().next();
            Member oldMember = firstRegistration.getSubscriber();
            String newOwnerMemberUuid = newOwnerMember.getUuid();
            if (newOwnerMemberUuid.equals(oldMember.getUuid())) {
                boolean ownerCleanedup = false;
                for (Member member : this.clientUnregisteredMembers) {
                    if (!newOwnerMemberUuid.equals(member.getUuid())) continue;
                    ownerCleanedup = true;
                    break;
                }
                if (!ownerCleanedup) {
                    return true;
                }
            }
            return false;
        }
    }
}

