/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientRegistrationKey;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ClientSmartListenerService
extends ClientListenerServiceImpl
implements InitialMembershipListener {
    private static final long SMART_LISTENER_MEMBER_ADDED_RESCHEDULE_TIME = 1000L;
    private static final long SMART_LISTENER_CONNECT_ALL_SERVERS_RETRY_WAIT_TIME = 5000L;
    private final Set<Member> members = new HashSet<Member>();
    private final Map<ClientRegistrationKey, Map<Member, ClientEventRegistration>> registrations = new ConcurrentHashMap<ClientRegistrationKey, Map<Member, ClientEventRegistration>>();
    private final ClientClusterService clusterService;
    private final int invocationTimeout;
    private volatile LifecycleEvent.LifecycleState lifecycleState;
    private String membershipListenerId;
    private ScheduledFuture<?> connectionOpener;

    public ClientSmartListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
        this.clusterService = client.getClientClusterService();
        this.invocationTimeout = client.getClientConfig().getNetworkConfig().getConnectionTimeout();
    }

    @Override
    public String registerListener(final ListenerMessageCodec codec, final EventHandler handler) {
        Future<String> future = this.registrationExecutor.submit(new Callable<String>(){

            @Override
            public String call() {
                String userRegistrationId = UuidUtil.newUnsecureUuidString();
                ClientRegistrationKey registrationKey = new ClientRegistrationKey(userRegistrationId, handler, codec);
                return ClientSmartListenerService.this.register(registrationKey);
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private String register(ClientRegistrationKey registrationKey) {
        this.registrations.put(registrationKey, new ConcurrentHashMap());
        for (Member member : this.members) {
            try {
                this.invoke(registrationKey, member);
            }
            catch (Exception e) {
                try {
                    this.deregister(registrationKey, this.getMemberUuids());
                }
                catch (Exception cleanupException) {
                    this.logger.warning("Could not perform appropriate cleanup for " + registrationKey, (Throwable)cleanupException);
                }
                throw new HazelcastException("Listener " + registrationKey + " can not be added to member " + member, (Throwable)e);
            }
        }
        return registrationKey.getUserRegistrationId();
    }

    @Override
    public void onClusterConnect(ClientConnection clientConnection) {
        try {
            this.registrationExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    Collection<Member> newMemberList = ClientSmartListenerService.this.client.getClientClusterService().getMemberList();
                    ClientSmartListenerService.this.members.clear();
                    ClientSmartListenerService.this.members.addAll(newMemberList);
                    if (ClientSmartListenerService.this.registrations.isEmpty()) {
                        return;
                    }
                    ClientSmartListenerService.this.reRegisterAll();
                }
            }).get();
        }
        catch (Exception e) {
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void invoke(ClientRegistrationKey registrationKey, Member member) throws Exception {
        ListenerMessageCodec codec = registrationKey.getCodec();
        ClientMessage request = codec.encodeAddRequest(true);
        EventHandler handler = registrationKey.getHandler();
        handler.beforeListenerRegister();
        Address address = member.getAddress();
        ClientInvocation invocation = new ClientInvocation(this.client, request, address);
        invocation.setEventHandler(handler);
        String serverRegistrationId = codec.decodeAddResponse((ClientMessage)invocation.invoke().get(this.invocationTimeout, TimeUnit.MILLISECONDS));
        handler.onListenerRegister();
        long correlationId = request.getCorrelationId();
        ClientEventRegistration registration = new ClientEventRegistration(serverRegistrationId, correlationId, member, codec);
        Map<Member, ClientEventRegistration> registrationMap = this.registrations.get(registrationKey);
        registrationMap.put(member, registration);
    }

    @Override
    public boolean deregisterListener(final String userRegistrationId) {
        try {
            Future<Boolean> future = this.registrationExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ClientRegistrationKey key = new ClientRegistrationKey(userRegistrationId);
                    return ClientSmartListenerService.this.deregister(key, ClientSmartListenerService.this.getMemberUuids());
                }
            });
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private Boolean deregister(ClientRegistrationKey key, Set<String> memberUuids) {
        Map<Member, ClientEventRegistration> registrationMap = this.registrations.get(key);
        if (registrationMap == null) {
            return false;
        }
        boolean successful = true;
        for (ClientEventRegistration registration : registrationMap.values()) {
            Member subscriber = registration.getSubscriber();
            try {
                if (memberUuids.contains(subscriber.getUuid())) {
                    ClientInvocationFuture invocationFuture = this.getClientInvocationFuture(registration, subscriber);
                    invocationFuture.get(this.invocationTimeout, TimeUnit.MILLISECONDS);
                } else {
                    try {
                        this.getClientInvocationFuture(registration, subscriber);
                    }
                    catch (Exception e) {
                        this.logger.finest("Suppressing the exception during listener deregistration invocation for registration:" + registration + ", since registered member " + subscriber + " is not in the members list " + this.members, (Throwable)e);
                    }
                }
                this.removeEventHandler(registration.getCallId());
                registrationMap.remove(subscriber);
            }
            catch (Exception e) {
                successful = false;
                this.logger.warning("Deregistration of listener with id " + key.getUserRegistrationId() + " has failed to member " + subscriber, (Throwable)e);
            }
        }
        if (successful) {
            this.registrations.remove(key);
        }
        return successful;
    }

    private ClientInvocationFuture getClientInvocationFuture(ClientEventRegistration registration, Member subscriber) {
        ListenerMessageCodec listenerMessageCodec = registration.getCodec();
        String serverRegistrationId = registration.getServerRegistrationId();
        ClientMessage request = listenerMessageCodec.encodeRemoveRequest(serverRegistrationId);
        ClientInvocationFuture invocationFuture = new ClientInvocation(this.client, request, subscriber.getAddress()).invoke();
        this.logger.finest("Invoked deregister listener invocation for " + registration + " to member " + subscriber);
        return invocationFuture;
    }

    private Set<String> getMemberUuids() {
        HashSet<String> memberUuids = new HashSet<String>(this.members.size());
        for (Member m : this.members) {
            memberUuids.add(m.getUuid());
        }
        return memberUuids;
    }

    @Override
    public void start() {
        this.membershipListenerId = this.clusterService.addMembershipListener((MembershipListener)this);
        if (null != this.clusterService.getOwnerConnectionAddress()) {
            this.lifecycleState = LifecycleEvent.LifecycleState.CLIENT_CONNECTED;
        }
        this.client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                ClientSmartListenerService.this.lifecycleState = event.getState();
            }
        });
        this.connectionOpener = this.client.getClientExecutionService().scheduleWithRepetition(new Runnable(){

            @Override
            public void run() {
                ClientSmartListenerService.this.registrationExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        ClientSmartListenerService.this.ensureConnectionsToAllServers();
                    }
                });
            }
        }, 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        if (null != this.connectionOpener) {
            this.connectionOpener.cancel(true);
        }
        super.shutdown();
        if (this.membershipListenerId != null) {
            this.clusterService.removeMembershipListener(this.membershipListenerId);
        }
    }

    public void memberAdded(MembershipEvent membershipEvent) {
        this.registrationExecutor.submit(new MemberAddedHandler(membershipEvent));
    }

    public void memberRemoved(final MembershipEvent membershipEvent) {
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED != ClientSmartListenerService.this.lifecycleState) {
                    ClientSmartListenerService.this.logger.finest("Ignoring member removed event " + membershipEvent + " since the client is disconnected.");
                    return;
                }
                Member member = membershipEvent.getMember();
                ClientSmartListenerService.this.members.remove(member);
                for (Map registrationMap : ClientSmartListenerService.this.registrations.values()) {
                    ClientSmartListenerService.this.removeRegistrationLocally(member, registrationMap);
                }
            }
        });
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    public void init(InitialMembershipEvent event) {
    }

    private void reRegisterAll() {
        for (Map.Entry<ClientRegistrationKey, Map<Member, ClientEventRegistration>> entry : this.registrations.entrySet()) {
            ClientRegistrationKey key = entry.getKey();
            this.logger.finest("Reregistering listener " + key + " to the cluster.");
            this.deregister(key, this.getMemberUuids());
            try {
                this.register(key);
            }
            catch (Exception e) {
                Map<Member, ClientEventRegistration> registrationMap = entry.getValue();
                if (null == registrationMap) {
                    this.registrations.put(key, new ConcurrentHashMap());
                }
                ExceptionUtil.rethrow((Throwable)e);
            }
            this.logger.finest("Reregistered listener " + key + " to the cluster.");
        }
    }

    private void removeRegistrationLocally(Member member, Map<Member, ClientEventRegistration> registrationMap) {
        ClientEventRegistration registration = registrationMap.remove(member);
        if (null != registration) {
            this.removeEventHandler(registration.getCallId());
        }
    }

    private void ensureConnectionsToAllServers() {
        if (this.registrations.isEmpty()) {
            return;
        }
        Address ownerConnectionAddress = this.clusterService.getOwnerConnectionAddress();
        if (null == ownerConnectionAddress) {
            return;
        }
        for (Member member : this.members) {
            try {
                this.getOrConnect(member, ownerConnectionAddress);
            }
            catch (Exception e) {
                this.logger.warning("Could not open connection to member " + member, (Throwable)e);
            }
        }
    }

    private void getOrConnect(Member member, Address ownerConnectionAddress) throws IOException {
        Address memberAddress = member.getAddress();
        this.client.getConnectionManager().getOrConnect(memberAddress, ownerConnectionAddress.equals((Object)memberAddress));
    }

    @Override
    public Collection<ClientEventRegistration> getActiveRegistrations(final String uuid) {
        Future<Collection<ClientEventRegistration>> future = this.registrationExecutor.submit(new Callable<Collection<ClientEventRegistration>>(){

            @Override
            public Collection<ClientEventRegistration> call() {
                ClientRegistrationKey key = new ClientRegistrationKey(uuid);
                Map registrationMap = (Map)ClientSmartListenerService.this.registrations.get(key);
                if (registrationMap == null) {
                    return Collections.EMPTY_LIST;
                }
                LinkedList<ClientEventRegistration> activeRegistrations = new LinkedList<ClientEventRegistration>();
                for (ClientEventRegistration registration : registrationMap.values()) {
                    for (Member member : ClientSmartListenerService.this.members) {
                        if (!member.equals(registration.getSubscriber())) continue;
                        activeRegistrations.add(registration);
                    }
                }
                return activeRegistrations;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private final class MemberAddedHandler
    implements Runnable {
        final MembershipEvent membershipEvent;

        public MemberAddedHandler(MembershipEvent membershipEvent) {
            this.membershipEvent = membershipEvent;
        }

        @Override
        public void run() {
            if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED != ClientSmartListenerService.this.lifecycleState) {
                ClientSmartListenerService.this.logger.finest("Ignoring member added event " + this.membershipEvent + " since the client is disconnected.");
                return;
            }
            Member member = this.membershipEvent.getMember();
            if (ClientSmartListenerService.this.members.contains(member)) {
                ClientSmartListenerService.this.logger.finest("Ignoring member added event " + this.membershipEvent + " since the member is already in the list.");
                return;
            }
            ClientSmartListenerService.this.logger.finest("New member added to the cluster. Registering " + ClientSmartListenerService.this.registrations.size() + " listeners to member " + member);
            try {
                ClientSmartListenerService.this.getOrConnect(member, ClientSmartListenerService.this.client.getClientClusterService().getOwnerConnectionAddress());
            }
            catch (Exception e) {
                ClientSmartListenerService.this.logger.warning("Failed to register listeners to member " + member + " rescheduling the registration in " + 1000L + " msecs", (Throwable)e);
                ClientSmartListenerService.this.client.getClientExecutionService().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ClientSmartListenerService.this.memberAdded(MemberAddedHandler.this.membershipEvent);
                    }
                }, 1000L, TimeUnit.MILLISECONDS);
                return;
            }
            ClientSmartListenerService.this.members.add(member);
            for (Map.Entry entry : ClientSmartListenerService.this.registrations.entrySet()) {
                ClientRegistrationKey registrationKey = (ClientRegistrationKey)entry.getKey();
                Map registrationMap = (Map)entry.getValue();
                if (null != registrationMap.get(member)) continue;
                try {
                    ClientSmartListenerService.this.invoke(registrationKey, member);
                }
                catch (Exception e) {
                    ClientSmartListenerService.this.logger.warning("Listener " + registrationKey + " can not be added to new member " + member + " rescheduling the registration in " + 1000L + " msecs", (Throwable)e);
                    ClientSmartListenerService.this.client.getClientExecutionService().schedule(new Runnable(){

                        @Override
                        public void run() {
                            ClientSmartListenerService.this.memberAdded(MemberAddedHandler.this.membershipEvent);
                        }
                    }, 1000L, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

