/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientRegistrationKey;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class ClientNonSmartListenerService
extends ClientListenerServiceImpl
implements ConnectionListener {
    private final Map<ClientRegistrationKey, ClientEventRegistration> registrations = new ConcurrentHashMap<ClientRegistrationKey, ClientEventRegistration>();

    public ClientNonSmartListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
    }

    @Override
    public String registerListener(final ListenerMessageCodec codec, final EventHandler handler) {
        Future<String> future = this.registrationExecutor.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String userRegistrationId = UuidUtil.newUnsecureUuidString();
                ClientRegistrationKey registrationKey = new ClientRegistrationKey(userRegistrationId, handler, codec);
                try {
                    ClientEventRegistration registration = ClientNonSmartListenerService.this.invoke(registrationKey);
                    ClientNonSmartListenerService.this.registrations.put(registrationKey, registration);
                }
                catch (Exception e) {
                    throw new HazelcastException("Listener can not be added", (Throwable)e);
                }
                return userRegistrationId;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private ClientEventRegistration invoke(ClientRegistrationKey registrationKey) throws Exception {
        EventHandler handler = registrationKey.getHandler();
        handler.beforeListenerRegister();
        ClientMessage request = registrationKey.getCodec().encodeAddRequest(false);
        ClientInvocation invocation = new ClientInvocation(this.client, request);
        invocation.setEventHandler(handler);
        ClientInvocationFuture future = invocation.invoke();
        String registrationId = registrationKey.getCodec().decodeAddResponse((ClientMessage)future.get());
        handler.onListenerRegister();
        Address address = future.getInvocation().getSendConnection().getRemoteEndpoint();
        return new ClientEventRegistration(registrationId, request.getCorrelationId(), address, registrationKey.getCodec());
    }

    @Override
    public boolean deregisterListener(final String userRegistrationId) {
        Future<Boolean> future = this.registrationExecutor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ClientRegistrationKey key = new ClientRegistrationKey(userRegistrationId);
                ClientEventRegistration registration = (ClientEventRegistration)ClientNonSmartListenerService.this.registrations.get(key);
                if (registration == null) {
                    return false;
                }
                ClientMessage request = registration.getCodec().encodeRemoveRequest(registration.getServerRegistrationId());
                try {
                    ClientInvocationFuture future = new ClientInvocation(ClientNonSmartListenerService.this.client, request).invoke();
                    future.get();
                    ClientNonSmartListenerService.this.removeEventHandler(registration.getCallId());
                    ClientNonSmartListenerService.this.registrations.remove(key);
                }
                catch (Exception e) {
                    throw new HazelcastException("Listener with id " + userRegistrationId + " could not be removed", (Throwable)e);
                }
                return true;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    @Override
    public void start() {
        this.client.getConnectionManager().addConnectionListener(this);
    }

    public void connectionAdded(Connection connection) {
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (ClientRegistrationKey registrationKey : ClientNonSmartListenerService.this.registrations.keySet()) {
                    try {
                        ClientEventRegistration registration = ClientNonSmartListenerService.this.invoke(registrationKey);
                        ClientNonSmartListenerService.this.registrations.put(registrationKey, registration);
                    }
                    catch (Exception e) {
                        ClientNonSmartListenerService.this.logger.warning("Listener " + registrationKey + " could not be added ");
                    }
                }
            }
        });
    }

    public void connectionRemoved(Connection connection) {
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : ClientNonSmartListenerService.this.registrations.entrySet()) {
                    ClientNonSmartListenerService.this.removeEventHandler(((ClientEventRegistration)entry.getValue()).getCallId());
                }
            }
        });
    }

    @Override
    public Collection<ClientEventRegistration> getActiveRegistrations(final String uuid) {
        Future<Collection<ClientEventRegistration>> future = this.registrationExecutor.submit(new Callable<Collection<ClientEventRegistration>>(){

            @Override
            public Collection<ClientEventRegistration> call() throws Exception {
                ClientEventRegistration registration = (ClientEventRegistration)ClientNonSmartListenerService.this.registrations.get(new ClientRegistrationKey(uuid));
                if (registration == null) {
                    return Collections.EMPTY_LIST;
                }
                LinkedList<ClientEventRegistration> activeRegistrations = new LinkedList<ClientEventRegistration>();
                if (ClientNonSmartListenerService.this.getEventHandler(registration.getCallId()) != null) {
                    activeRegistrations.add(registration);
                }
                return activeRegistrations;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }
}

