/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.map.impl.nearcache.ClientHeapNearCache;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.nearcache.KeyStateMarker;
import com.hazelcast.map.impl.nearcache.StaleReadPreventerNearCacheWrapper;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class NearCachedClientMapProxy<K, V>
extends ClientMapProxy<K, V> {
    protected NearCache<Data, Object> nearCache;
    protected KeyStateMarker keyStateMarker;
    protected volatile String invalidationListenerId;
    private boolean invalidateOnChange;

    public NearCachedClientMapProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.init();
    }

    protected void init() {
        ClientContext context = this.getContext();
        NearCacheConfig nearCacheConfig = context.getClientConfig().getNearCacheConfig(this.name);
        int partitionCount = context.getPartitionService().getPartitionCount();
        ClientHeapNearCache clientHeapNearCache = new ClientHeapNearCache(this.name, this.getContext(), nearCacheConfig);
        this.nearCache = StaleReadPreventerNearCacheWrapper.wrapAsStaleReadPreventerNearCache(clientHeapNearCache, (int)partitionCount);
        this.keyStateMarker = this.getKeyStateMarker();
        this.invalidateOnChange = this.nearCache.isInvalidateOnChange();
        if (this.invalidateOnChange) {
            this.addNearCacheInvalidateListener();
        }
    }

    @Override
    protected boolean containsKeyInternal(Data keyData) {
        Object cached = this.nearCache.get((Object)keyData);
        if (cached != null) {
            return NearCache.NULL_OBJECT != cached;
        }
        return super.containsKeyInternal(keyData);
    }

    @Override
    protected V getInternal(Data key) {
        Object cached = this.nearCache.get((Object)key);
        if (cached != null) {
            if (NearCache.NULL_OBJECT == cached) {
                return null;
            }
            return (V)cached;
        }
        boolean marked = this.keyStateMarker.tryMark((Object)key);
        V value = null;
        try {
            value = super.getInternal(key);
            if (marked) {
                this.tryToPutNearCache(key, value);
            }
        }
        catch (Throwable t) {
            this.resetToUnmarkedState(key);
            throw ExceptionUtil.rethrow((Throwable)t);
        }
        return value;
    }

    @Override
    protected MapRemoveCodec.ResponseParameters removeInternal(Data keyData) {
        MapRemoveCodec.ResponseParameters responseParameters = super.removeInternal(keyData);
        this.invalidateNearCache(keyData);
        return responseParameters;
    }

    @Override
    protected boolean removeInternal(Data keyData, Data valueData) {
        boolean removed = super.removeInternal(keyData, valueData);
        this.invalidateNearCache(keyData);
        return removed;
    }

    @Override
    protected void deleteInternal(Data keyData) {
        super.deleteInternal(keyData);
        this.invalidateNearCache(keyData);
    }

    @Override
    public ICompletableFuture<V> getAsyncInternal(final Data keyData) {
        ICompletableFuture future;
        Object cached = this.nearCache.get((Object)keyData);
        if (cached != null && NearCache.NULL_OBJECT != cached) {
            return new CompletedFuture(this.getContext().getSerializationService(), cached, this.getContext().getExecutionService().getAsyncExecutor());
        }
        final boolean marked = this.keyStateMarker.tryMark((Object)keyData);
        try {
            future = super.getAsyncInternal(keyData);
        }
        catch (Throwable t) {
            this.resetToUnmarkedState(keyData);
            throw ExceptionUtil.rethrow((Throwable)t);
        }
        ((ClientDelegatingFuture)future).andThenInternal(new ExecutionCallback<Data>(){

            public void onResponse(Data response) {
                if (marked) {
                    NearCachedClientMapProxy.this.tryToPutNearCache(keyData, response);
                }
            }

            public void onFailure(Throwable t) {
                if (marked) {
                    NearCachedClientMapProxy.this.resetToUnmarkedState(keyData);
                }
            }
        });
        return future;
    }

    @Override
    protected Future<V> putAsyncInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        Future future = super.putAsyncInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return future;
    }

    @Override
    protected Future<V> removeAsyncInternal(Data keyData) {
        Future future = super.removeAsyncInternal(keyData);
        this.invalidateNearCache(keyData);
        return future;
    }

    @Override
    protected boolean tryRemoveInternal(long timeout, TimeUnit timeunit, Data keyData) {
        boolean removed = super.tryRemoveInternal(timeout, timeunit, keyData);
        this.invalidateNearCache(keyData);
        return removed;
    }

    @Override
    protected boolean tryPutInternal(long timeout, TimeUnit timeunit, Data keyData, Data valueData) {
        boolean putInternal = super.tryPutInternal(timeout, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return putInternal;
    }

    @Override
    protected V putInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        Object previousValue = super.putInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return previousValue;
    }

    @Override
    protected void putTransientInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        super.putTransientInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
    }

    @Override
    protected V putIfAbsentInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        Object previousValue = super.putIfAbsentInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return previousValue;
    }

    @Override
    protected boolean replaceIfSameInternal(Data keyData, Data oldValueData, Data newValueData) {
        boolean replaceIfSame = super.replaceIfSameInternal(keyData, oldValueData, newValueData);
        this.invalidateNearCache(keyData);
        return replaceIfSame;
    }

    @Override
    protected V replaceInternal(Data keyData, Data valueData) {
        Object v = super.replaceInternal(keyData, valueData);
        this.invalidateNearCache(keyData);
        return v;
    }

    @Override
    protected void setInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        super.setInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
    }

    @Override
    protected boolean evictInternal(Data keyData) {
        boolean evicted = super.evictInternal(keyData);
        this.invalidateNearCache(keyData);
        return evicted;
    }

    @Override
    public void evictAll() {
        super.evictAll();
        this.nearCache.clear();
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        super.loadAll(replaceExistingValues);
        if (replaceExistingValues) {
            this.nearCache.clear();
        }
    }

    @Override
    protected void loadAllInternal(boolean replaceExistingValues, Set<Data> dataKeys) {
        super.loadAllInternal(replaceExistingValues, dataKeys);
        this.invalidateNearCache(dataKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<MapGetAllCodec.ResponseParameters> getAllInternal(Map<Integer, List<Data>> pIdToKeyData, Map<K, V> result) {
        List<MapGetAllCodec.ResponseParameters> responses;
        HashMap<Data, Boolean> markers = Collections.EMPTY_MAP;
        try {
            Data key;
            for (Map.Entry<Integer, List<Data>> partitionKeyEntry : pIdToKeyData.entrySet()) {
                List<Data> keyList = partitionKeyEntry.getValue();
                Iterator<Data> iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    key = iterator.next();
                    Object cached = this.nearCache.get((Object)key);
                    if (cached != null && NearCache.NULL_OBJECT != cached) {
                        result.put(this.toObject(key), cached);
                        iterator.remove();
                        continue;
                    }
                    if (!this.invalidateOnChange) continue;
                    if (markers == Collections.EMPTY_MAP) {
                        markers = new HashMap<Data, Boolean>();
                    }
                    markers.put(key, this.keyStateMarker.tryMark((Object)key));
                }
            }
            responses = super.getAllInternal(pIdToKeyData, result);
            for (MapGetAllCodec.ResponseParameters resultParameters : responses) {
                for (Map.Entry entry : resultParameters.response) {
                    key = (Data)entry.getKey();
                    Data value = (Data)entry.getValue();
                    Boolean marked = (Boolean)markers.remove(key);
                    if (null != marked && marked.booleanValue()) {
                        this.tryToPutNearCache(key, value);
                        continue;
                    }
                    if (this.invalidateOnChange) continue;
                    this.nearCache.put((Object)key, (Object)value);
                }
            }
        }
        finally {
            this.unmarkRemainingMarkedKeys((Map<Data, Boolean>)markers);
        }
        return responses;
    }

    private void unmarkRemainingMarkedKeys(Map<Data, Boolean> markers) {
        for (Map.Entry<Data, Boolean> entry : markers.entrySet()) {
            Boolean marked = entry.getValue();
            if (!marked.booleanValue()) continue;
            this.keyStateMarker.forceUnmark((Object)entry.getKey());
        }
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        LocalMapStats localMapStats = super.getLocalMapStats();
        NearCacheStats nearCacheStats = this.nearCache.getNearCacheStats();
        ((LocalMapStatsImpl)localMapStats).setNearCacheStats(nearCacheStats);
        return localMapStats;
    }

    @Override
    public Object executeOnKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        Object response = super.executeOnKeyInternal(keyData, entryProcessor);
        this.invalidateNearCache(keyData);
        return response;
    }

    @Override
    public Future submitToKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        Future future = super.submitToKeyInternal(keyData, entryProcessor);
        this.invalidateNearCache(keyData);
        return future;
    }

    @Override
    public void submitToKeyInternal(Data keyData, EntryProcessor entryProcessor, ExecutionCallback callback) {
        super.submitToKeyInternal(keyData, entryProcessor, callback);
        this.invalidateNearCache(keyData);
    }

    @Override
    protected Map<K, Object> prepareResult(Collection<Map.Entry<Data, Data>> entrySet) {
        if (CollectionUtil.isEmpty(entrySet)) {
            return Collections.emptyMap();
        }
        Map result = MapUtil.createHashMap((int)entrySet.size());
        for (Map.Entry<Data, Data> entry : entrySet) {
            Data dataKey = entry.getKey();
            this.invalidateNearCache(dataKey);
            Object key = this.toObject(dataKey);
            Object value = this.toObject(entry.getValue());
            result.put(key, value);
        }
        return result;
    }

    @Override
    protected void putAllInternal(Map<Integer, List<Map.Entry<Data, Data>>> entryMap) {
        super.putAllInternal(entryMap);
        for (List<Map.Entry<Data, Data>> entries : entryMap.values()) {
            for (Map.Entry<Data, Data> entry : entries) {
                this.invalidateNearCache(entry.getKey());
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.nearCache.clear();
    }

    @Override
    protected void onDestroy() {
        this.removeNearCacheInvalidationListener();
        this.nearCache.destroy();
        super.onDestroy();
    }

    @Override
    protected void onShutdown() {
        this.removeNearCacheInvalidationListener();
        this.nearCache.destroy();
        super.onShutdown();
    }

    private void tryToPutNearCache(Data key, Object response) {
        try {
            this.nearCache.put((Object)key, response);
        }
        finally {
            this.resetToUnmarkedState(key);
        }
    }

    private void resetToUnmarkedState(Data key) {
        if (!this.keyStateMarker.tryUnmark((Object)key)) {
            this.invalidateNearCache(key);
            this.keyStateMarker.forceUnmark((Object)key);
        }
    }

    public NearCache<Data, Object> getNearCache() {
        return this.nearCache;
    }

    protected void invalidateNearCache(Data key) {
        this.nearCache.remove((Object)key);
    }

    protected void invalidateNearCache(Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (Data key : keys) {
            this.nearCache.remove((Object)key);
        }
    }

    protected void addNearCacheInvalidateListener() {
        ClientMapAddNearCacheEventHandler handler = new ClientMapAddNearCacheEventHandler();
        this.addNearCacheInvalidateListener(handler);
    }

    public void addNearCacheInvalidateListener(EventHandler handler) {
        try {
            this.invalidationListenerId = this.registerListener(this.createNearCacheEntryListenerCodec(), handler);
        }
        catch (Exception e) {
            Logger.getLogger(ClientHeapNearCache.class).severe("-----------------\n Near Cache is not initialized!!! \n-----------------", (Throwable)e);
        }
    }

    private ListenerMessageCodec createNearCacheEntryListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddNearCacheEntryListenerCodec.encodeRequest((String)NearCachedClientMapProxy.this.name, (int)EntryEventType.INVALIDATION.getType(), (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddNearCacheEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest((String)NearCachedClientMapProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    protected void removeNearCacheInvalidationListener() {
        String invalidationListenerId = this.invalidationListenerId;
        if (invalidationListenerId == null) {
            return;
        }
        this.deregisterListener(invalidationListenerId);
    }

    public KeyStateMarker getKeyStateMarker() {
        return ((StaleReadPreventerNearCacheWrapper)this.nearCache).getKeyStateMarker();
    }

    protected class ClientMapAddNearCacheEventHandler
    extends MapAddNearCacheEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        protected ClientMapAddNearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
        }

        @Override
        public void onListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
        }

        @Override
        public void handle(Data key) {
            if (key == null) {
                NearCachedClientMapProxy.this.nearCache.clear();
            } else {
                NearCachedClientMapProxy.this.nearCache.remove((Object)key);
            }
        }

        @Override
        public void handle(Collection<Data> keys) {
            for (Data key : keys) {
                NearCachedClientMapProxy.this.nearCache.remove((Object)key);
            }
        }
    }
}

