/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.executor.CompletableFutureTask;
import com.hazelcast.util.executor.PoolExecutorThreadFactory;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ClientExecutionServiceImpl
implements ClientExecutionService {
    private static final ILogger LOGGER = Logger.getLogger(ClientExecutionService.class);
    private static final long TERMINATE_TIMEOUT_SECONDS = 30L;
    private static final ExecutionCallback FAILURE_LOGGING_EXECUTION_CALLBACK = new ExecutionCallback(){

        public void onResponse(Object response) {
        }

        public void onFailure(Throwable t) {
            LOGGER.warning("Rejected internal execution on scheduledExecutor", t);
        }
    };
    private final ExecutorService userExecutor;
    private final ExecutorService internalExecutor;
    private final ScheduledExecutorService scheduledExecutor;

    public ClientExecutionServiceImpl(String name, ThreadGroup threadGroup, ClassLoader classLoader, int poolSize) {
        int executorPoolSize = poolSize;
        if (executorPoolSize <= 0) {
            executorPoolSize = Runtime.getRuntime().availableProcessors();
        }
        this.internalExecutor = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new PoolExecutorThreadFactory(threadGroup, name + ".internal-", classLoader), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                String message = "Internal executor rejected task: " + r + ", because client is shutting down...";
                LOGGER.finest(message);
                throw new RejectedExecutionException(message);
            }
        });
        this.userExecutor = new ThreadPoolExecutor(executorPoolSize, executorPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new PoolExecutorThreadFactory(threadGroup, name + ".user-", classLoader), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                String message = "Internal executor rejected task: " + r + ", because client is shutting down...";
                LOGGER.finest(message);
                throw new RejectedExecutionException(message);
            }
        });
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new SingleExecutorThreadFactory(threadGroup, classLoader, name + ".scheduled"));
    }

    public void executeInternal(Runnable runnable) {
        this.internalExecutor.execute(runnable);
    }

    public <T> ICompletableFuture<T> submitInternal(Runnable runnable) {
        CompletableFutureTask futureTask = new CompletableFutureTask(runnable, null, this.internalExecutor);
        this.internalExecutor.submit((Runnable)futureTask);
        return futureTask;
    }

    @Override
    public void execute(Runnable command) {
        this.userExecutor.execute(command);
    }

    @Override
    public ICompletableFuture<?> submit(Runnable task) {
        CompletableFutureTask futureTask = new CompletableFutureTask(task, null, this.getAsyncExecutor());
        this.userExecutor.submit((Runnable)futureTask);
        return futureTask;
    }

    @Override
    public <T> ICompletableFuture<T> submit(Callable<T> task) {
        CompletableFutureTask futureTask = new CompletableFutureTask(task, this.getAsyncExecutor());
        this.userExecutor.submit((Runnable)futureTask);
        return futureTask;
    }

    public ScheduledFuture<?> schedule(final Runnable command, long delay, TimeUnit unit, final ExecutionCallback executionCallback) {
        return this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                ClientExecutionServiceImpl.this.executeInternalSafely(command, executionCallback);
            }
        }, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(final Runnable command, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                ClientExecutionServiceImpl.this.executeInternalSafely(command, FAILURE_LOGGING_EXECUTION_CALLBACK);
            }
        }, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(final Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ClientExecutionServiceImpl.this.executeInternalSafely(command, FAILURE_LOGGING_EXECUTION_CALLBACK);
            }
        }, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(final Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ClientExecutionServiceImpl.this.executeInternalSafely(command, FAILURE_LOGGING_EXECUTION_CALLBACK);
            }
        }, initialDelay, period, unit);
    }

    @Override
    public ExecutorService getAsyncExecutor() {
        return this.userExecutor;
    }

    public void shutdown() {
        this.shutdownExecutor("scheduled", this.scheduledExecutor);
        this.shutdownExecutor("user", this.userExecutor);
        this.shutdownExecutor("internal", this.internalExecutor);
    }

    private void executeInternalSafely(Runnable command, ExecutionCallback executionCallback) {
        try {
            this.submitInternal(command).andThen(executionCallback);
        }
        catch (RejectedExecutionException e) {
            executionCallback.onFailure((Throwable)e);
        }
    }

    private void shutdownExecutor(String name, ExecutorService executor) {
        executor.shutdown();
        try {
            boolean success = executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!success) {
                LOGGER.warning(name + " executor awaitTermination could not completed in " + 30L + " seconds");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warning(name + " executor await termination is interrupted", (Throwable)e);
        }
    }

    public ExecutorService getInternalExecutor() {
        return this.internalExecutor;
    }
}

