/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TransactionalMultiMapGetCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMultiMapPutCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMultiMapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMultiMapRemoveEntryCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMultiMapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMultiMapValueCountCodec;
import com.hazelcast.client.proxy.txn.ClientTxnProxy;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.util.ThreadUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClientTxnMultiMapProxy<K, V>
extends ClientTxnProxy
implements TransactionalMultiMap<K, V> {
    public ClientTxnMultiMapProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    public boolean put(K key, V value) throws TransactionException {
        ClientMessage request = TransactionalMultiMapPutCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        ClientMessage response = this.invoke(request);
        return TransactionalMultiMapPutCodec.decodeResponse((ClientMessage)response).response;
    }

    public Collection<V> get(K key) {
        ClientMessage request = TransactionalMultiMapGetCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        List collection = TransactionalMultiMapGetCodec.decodeResponse((ClientMessage)response).list;
        ArrayList<Object> coll = new ArrayList<Object>(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    public boolean remove(Object key, Object value) {
        ClientMessage request = TransactionalMultiMapRemoveEntryCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        ClientMessage response = this.invoke(request);
        return TransactionalMultiMapRemoveEntryCodec.decodeResponse((ClientMessage)response).response;
    }

    public Collection<V> remove(Object key) {
        ClientMessage request = TransactionalMultiMapRemoveCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        List collection = TransactionalMultiMapRemoveCodec.decodeResponse((ClientMessage)response).list;
        ArrayList<Object> coll = new ArrayList<Object>(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    public int valueCount(K key) {
        ClientMessage request = TransactionalMultiMapValueCountCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        return TransactionalMultiMapValueCountCodec.decodeResponse((ClientMessage)response).response;
    }

    public int size() {
        ClientMessage request = TransactionalMultiMapSizeCodec.encodeRequest((String)this.name, (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return TransactionalMultiMapSizeCodec.decodeResponse((ClientMessage)response).response;
    }

    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    void onDestroy() {
    }
}

