/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientReadHandler;
import com.hazelcast.client.connection.nio.ClientWriteHandler;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnection
implements Connection,
Closeable {
    protected final int connectionId;
    private final AtomicBoolean live = new AtomicBoolean(true);
    private final ILogger logger = Logger.getLogger(ClientConnection.class);
    private final AtomicInteger packetCount = new AtomicInteger(0);
    private final ClientWriteHandler writeHandler;
    private final ClientReadHandler readHandler;
    private final SocketChannelWrapper socketChannelWrapper;
    private final ClientConnectionManager connectionManager;
    private final SerializationService serializationService;
    private final LifecycleService lifecycleService;
    private volatile Address remoteEndpoint;
    private volatile boolean heartBeating = true;

    public ClientConnection(HazelcastClientInstanceImpl client, IOSelector in, IOSelector out, int connectionId, SocketChannelWrapper socketChannelWrapper) throws IOException {
        Socket socket = socketChannelWrapper.socket();
        this.connectionManager = client.getConnectionManager();
        this.serializationService = client.getSerializationService();
        this.lifecycleService = client.getLifecycleService();
        this.socketChannelWrapper = socketChannelWrapper;
        this.connectionId = connectionId;
        this.readHandler = new ClientReadHandler(this, in, socket.getReceiveBufferSize());
        this.writeHandler = new ClientWriteHandler(this, out, socket.getSendBufferSize());
    }

    public ClientConnection(HazelcastClientInstanceImpl client, int connectionId) throws IOException {
        this.connectionManager = client.getConnectionManager();
        this.serializationService = client.getSerializationService();
        this.lifecycleService = client.getLifecycleService();
        this.connectionId = connectionId;
        this.writeHandler = null;
        this.readHandler = null;
        this.socketChannelWrapper = null;
    }

    public void incrementPacketCount() {
        this.packetCount.incrementAndGet();
    }

    public void decrementPacketCount() {
        this.packetCount.decrementAndGet();
    }

    public int getPacketCount() {
        return this.packetCount.get();
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public boolean write(SocketWritable packet) {
        if (!this.live.get()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Connection is closed, won't write packet -> " + packet);
            }
            return false;
        }
        this.writeHandler.enqueueSocketWritable(packet);
        return true;
    }

    public void init() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(6);
        buffer.put(StringUtil.stringToBytes((String)"CB1"));
        buffer.put(StringUtil.stringToBytes((String)"JVM"));
        buffer.flip();
        this.socketChannelWrapper.write(buffer);
    }

    public Address getEndPoint() {
        return this.remoteEndpoint;
    }

    public boolean isAlive() {
        return this.live.get();
    }

    public long lastReadTime() {
        return this.readHandler.getLastHandle();
    }

    public long lastWriteTime() {
        return this.writeHandler.getLastHandle();
    }

    @Override
    public void close() {
        this.close(null);
    }

    public ConnectionType getType() {
        return ConnectionType.JAVA_CLIENT;
    }

    public boolean isClient() {
        return true;
    }

    public InetAddress getInetAddress() {
        return this.socketChannelWrapper.socket().getInetAddress();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.socketChannelWrapper.socket().getRemoteSocketAddress();
    }

    public int getPort() {
        return this.socketChannelWrapper.socket().getPort();
    }

    public SocketChannelWrapper getSocketChannelWrapper() {
        return this.socketChannelWrapper;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientReadHandler getReadHandler() {
        return this.readHandler;
    }

    public void setRemoteEndpoint(Address remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public Address getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.socketChannelWrapper.socket().getLocalSocketAddress();
    }

    protected void innerClose() throws IOException {
        if (this.socketChannelWrapper.isOpen()) {
            this.socketChannelWrapper.close();
        }
        this.readHandler.shutdown();
        this.writeHandler.shutdown();
    }

    public void close(Throwable t) {
        if (!this.live.compareAndSet(true, false)) {
            return;
        }
        String message = "Connection [" + this.getRemoteSocketAddress() + "] lost. Reason: ";
        message = t != null ? message + t.getClass().getName() + "[" + t.getMessage() + "]" : message + "Socket explicitly closed";
        try {
            this.innerClose();
        }
        catch (Exception e) {
            this.logger.warning((Throwable)e);
        }
        if (this.lifecycleService.isRunning()) {
            this.logger.warning(message);
        } else {
            this.logger.finest(message);
        }
    }

    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    void heartBeatingFailed() {
        this.heartBeating = false;
    }

    void heartBeatingSucceed() {
        this.heartBeating = true;
    }

    public boolean isHeartBeating() {
        return this.live.get() && this.heartBeating;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientConnection)) {
            return false;
        }
        ClientConnection that = (ClientConnection)o;
        return this.connectionId == that.connectionId;
    }

    public int hashCode() {
        return this.connectionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientConnection{");
        sb.append("live=").append(this.live);
        sb.append(", writeHandler=").append(this.writeHandler);
        sb.append(", readHandler=").append(this.readHandler);
        sb.append(", connectionId=").append(this.connectionId);
        sb.append(", socketChannel=").append(this.socketChannelWrapper);
        sb.append(", remoteEndpoint=").append(this.remoteEndpoint);
        sb.append('}');
        return sb.toString();
    }
}

