/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.AbstractHazelcastCachingProvider;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;

public final class HazelcastClientCachingProvider
extends AbstractHazelcastCachingProvider {
    public static HazelcastClientCachingProvider createCachingProvider(HazelcastInstance hazelcastInstance) {
        HazelcastClientCachingProvider cachingProvider = new HazelcastClientCachingProvider();
        HazelcastClientCachingProvider.hazelcastInstance = hazelcastInstance;
        return cachingProvider;
    }

    protected HazelcastClientCacheManager createHazelcastCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        HazelcastInstance instance;
        if (uri == null || uri.equals(this.getDefaultURI())) {
            if (hazelcastInstance == null) {
                try {
                    hazelcastInstance = this.instanceFromProperties(classLoader, properties, true);
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow((Throwable)e);
                }
            }
            instance = hazelcastInstance;
        } else {
            try {
                instance = this.instanceFromProperties(classLoader, properties, false);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        return new HazelcastClientCacheManager(this, instance, uri, classLoader, properties);
    }

    private HazelcastInstance instanceFromProperties(ClassLoader classLoader, Properties properties, boolean isDefault) throws URISyntaxException, IOException {
        String instanceName;
        ClassLoader theClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        HazelcastInstance instance = null;
        String location = properties.getProperty("hazelcast.config.location");
        if (location != null) {
            URL configURL;
            URI uri = new URI(location);
            String scheme = uri.getScheme();
            if (scheme == null) {
                uri = new URI(System.getProperty(uri.getRawSchemeSpecificPart()));
            }
            if ("classpath".equals(scheme)) {
                configURL = theClassLoader.getResource(uri.getRawSchemeSpecificPart());
            } else if ("file".equals(scheme) || "http".equals(scheme) || "https".equals(scheme)) {
                configURL = uri.toURL();
            } else {
                throw new URISyntaxException(location, "Unsupported protocol in configuration location URL");
            }
            try {
                ClientConfig config = new XmlClientConfigBuilder(configURL).build();
                config.setClassLoader(theClassLoader);
                instance = HazelcastClient.newHazelcastClient(config);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        if ((instanceName = properties.getProperty("hazelcast.instance.name")) != null) {
            instance = HazelcastClient.getHazelcastClientByName(instanceName);
        }
        if (isDefault) {
            instance = HazelcastClient.newHazelcastClient();
        }
        return instance;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HazelcastClientCachingProvider{");
        sb.append("hazelcastInstance=").append(hazelcastInstance);
        sb.append('}');
        return sb.toString();
    }
}

