/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientOutOfMemoryHandler;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OutOfMemoryHandler;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.util.EmptyStatement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class HazelcastClient {
    private static final ConcurrentMap<String, HazelcastClientProxy> CLIENTS;

    private HazelcastClient() {
    }

    public static HazelcastInstance newHazelcastClient() {
        return HazelcastClient.newHazelcastClient(new XmlClientConfigBuilder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HazelcastInstance newHazelcastClient(ClientConfig config) {
        HazelcastClientProxy proxy;
        if (config == null) {
            config = new XmlClientConfigBuilder().build();
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HazelcastClient.class.getClassLoader());
            HazelcastClientInstanceImpl client = new HazelcastClientInstanceImpl(config);
            client.start();
            OutOfMemoryErrorDispatcher.register((HazelcastInstance)client);
            proxy = new HazelcastClientProxy(client);
            CLIENTS.put(client.getName(), proxy);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return proxy;
    }

    public static HazelcastInstance getHazelcastClientByName(String instanceName) {
        return (HazelcastInstance)CLIENTS.get(instanceName);
    }

    public static Collection<HazelcastInstance> getAllHazelcastClients() {
        Collection values = CLIENTS.values();
        return Collections.unmodifiableCollection(new HashSet(values));
    }

    public static void shutdownAll() {
        for (HazelcastClientProxy proxy : CLIENTS.values()) {
            try {
                proxy.client.shutdown();
            }
            catch (Exception ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
            proxy.client = null;
        }
        CLIENTS.clear();
    }

    public static void shutdown(HazelcastInstance instance) {
        if (instance instanceof HazelcastClientProxy) {
            HazelcastClientProxy proxy = (HazelcastClientProxy)instance;
            String instanceName = proxy.client.getName();
            try {
                proxy.client.shutdown();
            }
            catch (Exception ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
            proxy.client = null;
            CLIENTS.remove(instanceName);
        }
    }

    public static void shutdown(String instanceName) {
        HazelcastClientProxy proxy = (HazelcastClientProxy)CLIENTS.remove(instanceName);
        if (proxy != null) {
            try {
                proxy.client.shutdown();
            }
            catch (Exception ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
            proxy.client = null;
        }
    }

    static {
        OutOfMemoryErrorDispatcher.setClientHandler((OutOfMemoryHandler)new ClientOutOfMemoryHandler());
        CLIENTS = new ConcurrentHashMap<String, HazelcastClientProxy>(5);
    }
}

