/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.util.AddressUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedList;

public final class AddressHelper {
    private static final int MAX_PORT_TRIES = 3;

    public static Collection<InetSocketAddress> getSocketAddresses(String address) {
        AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder((String)address, (int)-1);
        String scopedAddress = addressHolder.scopeId != null ? addressHolder.address + "%" + addressHolder.scopeId : addressHolder.address;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(scopedAddress);
        }
        catch (UnknownHostException ignored) {
            // empty catch block
        }
        return AddressHelper.getPossibleSocketAddresses(inetAddress, addressHolder.port, scopedAddress);
    }

    public static Collection<InetSocketAddress> getPossibleSocketAddresses(InetAddress inetAddress, int port, String scopedAddress) {
        LinkedList<InetSocketAddress> socketAddresses;
        block6: {
            int portTryCount;
            block7: {
                block5: {
                    portTryCount = 1;
                    if (port == -1) {
                        portTryCount = 3;
                        port = 5701;
                    }
                    socketAddresses = new LinkedList<InetSocketAddress>();
                    if (inetAddress != null) break block5;
                    for (int i = 0; i < portTryCount; ++i) {
                        socketAddresses.add(new InetSocketAddress(scopedAddress, port + i));
                    }
                    break block6;
                }
                if (!(inetAddress instanceof Inet4Address)) break block7;
                for (int i = 0; i < portTryCount; ++i) {
                    socketAddresses.add(new InetSocketAddress(inetAddress, port + i));
                }
                break block6;
            }
            if (!(inetAddress instanceof Inet6Address)) break block6;
            Collection addresses = AddressUtil.getPossibleInetAddressesFor((Inet6Address)((Inet6Address)inetAddress));
            for (Inet6Address inet6Address : addresses) {
                for (int i = 0; i < portTryCount; ++i) {
                    socketAddresses.add(new InetSocketAddress(inet6Address, port + i));
                }
            }
        }
        return socketAddresses;
    }

    private AddressHelper() {
    }
}

