/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.AuthenticationRequest;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.ClientResponse;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.Authenticator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.Router;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientInSelectorImpl;
import com.hazelcast.client.connection.nio.ClientOutSelectorImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.ClientPacket;
import com.hazelcast.nio.DefaultSocketChannelWrapper;
import com.hazelcast.nio.IOSelector;
import com.hazelcast.nio.SocketChannelWrapper;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationContext;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.ssl.BasicSSLContextFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.nio.ssl.SSLSocketChannelWrapper;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnectionManagerImpl
implements ClientConnectionManager {
    private static final ILogger logger = Logger.getLogger(ClientConnectionManagerImpl.class);
    private static int RETRY_COUNT = 20;
    static final int KILO_BYTE = 1024;
    public static final int BUFFER_SIZE = 16384;
    private final AtomicInteger connectionIdGen = new AtomicInteger();
    private final HazelcastClient client;
    private final Router router;
    private final SocketInterceptor socketInterceptor;
    private final SocketOptions socketOptions;
    private final IOSelector inSelector;
    private final IOSelector outSelector;
    private final boolean smartRouting;
    private volatile Address ownerConnectionAddress = null;
    private final Credentials credentials;
    private volatile ClientPrincipal principal;
    private final AtomicInteger callIdIncrementer = new AtomicInteger();
    private final SocketChannelWrapperFactory socketChannelWrapperFactory;
    private final ConcurrentMap<Address, ClientConnection> connections = new ConcurrentHashMap<Address, ClientConnection>();
    private volatile boolean live = false;

    public ClientConnectionManagerImpl(HazelcastClient client, LoadBalancer loadBalancer) {
        String credentialsClassname;
        this.client = client;
        ClientConfig config = client.getClientConfig();
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        GroupConfig groupConfig = config.getGroupConfig();
        ClientSecurityConfig securityConfig = config.getSecurityConfig();
        Credentials c = securityConfig.getCredentials();
        if (c == null && (credentialsClassname = securityConfig.getCredentialsClassname()) != null) {
            try {
                c = (Credentials)ClassLoaderUtil.newInstance((ClassLoader)config.getClassLoader(), (String)credentialsClassname);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        if (c == null) {
            c = new UsernamePasswordCredentials(groupConfig.getName(), groupConfig.getPassword());
        }
        this.smartRouting = networkConfig.isSmartRouting();
        this.credentials = c;
        this.router = new Router(loadBalancer);
        this.inSelector = new ClientInSelectorImpl(client.getThreadGroup());
        this.outSelector = new ClientOutSelectorImpl(client.getThreadGroup());
        SocketInterceptorConfig sic = networkConfig.getSocketInterceptorConfig();
        SocketInterceptor implementation = null;
        if (sic != null && sic.isEnabled() && (implementation = (SocketInterceptor)sic.getImplementation()) == null && sic.getClassName() != null) {
            try {
                implementation = (SocketInterceptor)Class.forName(sic.getClassName()).newInstance();
            }
            catch (Throwable e) {
                logger.severe("SocketInterceptor class cannot be instantiated!" + sic.getClassName(), e);
            }
        }
        this.socketInterceptor = implementation;
        if (this.socketInterceptor != null) {
            logger.info("SocketInterceptor is enabled");
            this.socketInterceptor.init(sic.getProperties());
        }
        this.socketOptions = networkConfig.getSocketOptions();
        SSLConfig sslConfig = networkConfig.getSSLConfig();
        if (sslConfig != null && sslConfig.isEnabled()) {
            this.socketChannelWrapperFactory = new SSLSocketChannelWrapperFactory(sslConfig);
            logger.info("SSL is enabled");
        } else {
            this.socketChannelWrapperFactory = new DefaultSocketChannelWrapperFactory();
        }
    }

    public boolean isLive() {
        return this.live;
    }

    public SerializationContext getSerializationContext() {
        return this.client.getSerializationService().getSerializationContext();
    }

    public SerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    @Override
    public synchronized void start() {
        if (this.live) {
            return;
        }
        this.live = true;
        this.inSelector.start();
        this.outSelector.start();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.live) {
            return;
        }
        this.live = false;
        for (ClientConnection connection : this.connections.values()) {
            connection.close();
        }
        this.inSelector.shutdown();
        this.outSelector.shutdown();
    }

    @Override
    public ClientConnection ownerConnection(Address address) throws Exception {
        ClientConnection clientConnection = this.connect(address, new ManagerAuthenticator(), true);
        this.ownerConnectionAddress = clientConnection.getRemoteEndpoint();
        return clientConnection;
    }

    @Override
    public ClientConnection tryToConnect(Address target) throws Exception {
        ClusterAuthenticator authenticator = new ClusterAuthenticator();
        IOException lastError = null;
        for (int count = 0; count < RETRY_COUNT; ++count) {
            try {
                if (target == null || !this.isMember(target)) {
                    Address address = this.getAddressFromLoadBalancer();
                    return this.getOrConnect(address, authenticator);
                }
                return this.getOrConnect(target, authenticator);
            }
            catch (IOException e) {
                lastError = e;
                target = null;
                continue;
            }
        }
        throw lastError;
    }

    private Address getAddressFromLoadBalancer() {
        Address address = this.router.next();
        if (address == null) {
            Set members = this.client.getCluster().getMembers();
            String msg = members.isEmpty() ? "No address was return by the LoadBalancer since there are no members in the cluster" : "No address was return by the LoadBalancer. But the cluster contains the following members:" + members;
            throw new IllegalStateException(msg);
        }
        return address;
    }

    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    private boolean isMember(Address target) {
        ClientClusterService clientClusterService = this.client.getClientClusterService();
        return clientClusterService.getMember(target) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnection getOrConnect(Address address, Authenticator authenticator) throws Exception {
        ClientConnection clientConnection;
        if (address == null) {
            throw new NullPointerException("Address is required!");
        }
        if (!this.smartRouting) {
            address = this.ownerConnectionAddress;
        }
        if ((clientConnection = (ClientConnection)this.connections.get(address)) == null) {
            ClientConnectionManagerImpl clientConnectionManagerImpl = this;
            synchronized (clientConnectionManagerImpl) {
                clientConnection = (ClientConnection)this.connections.get(address);
                if (clientConnection == null) {
                    clientConnection = this.connect(address, authenticator, false);
                    this.connections.put(clientConnection.getRemoteEndpoint(), clientConnection);
                }
            }
        }
        return clientConnection;
    }

    private ClientConnection connect(Address address, Authenticator authenticator, boolean isBlock) throws Exception {
        if (!this.live) {
            throw new HazelcastException("ConnectionManager is not active!!!");
        }
        SocketChannel socketChannel = SocketChannel.open();
        Socket socket = socketChannel.socket();
        socket.setKeepAlive(this.socketOptions.isKeepAlive());
        socket.setTcpNoDelay(this.socketOptions.isTcpNoDelay());
        socket.setReuseAddress(this.socketOptions.isReuseAddress());
        if (this.socketOptions.getLingerSeconds() > 0) {
            socket.setSoLinger(true, this.socketOptions.getLingerSeconds());
        }
        socket.setSoTimeout(5000);
        int bufferSize = this.socketOptions.getBufferSize() * 1024;
        if (bufferSize < 0) {
            bufferSize = 16384;
        }
        socket.setSendBufferSize(bufferSize);
        socket.setReceiveBufferSize(bufferSize);
        socketChannel.connect(address.getInetSocketAddress());
        SocketChannelWrapper socketChannelWrapper = this.socketChannelWrapperFactory.wrapSocketChannel(socketChannel, true);
        ClientConnection clientConnection = new ClientConnection(this, this.inSelector, this.outSelector, this.connectionIdGen.incrementAndGet(), socketChannelWrapper);
        socketChannel.configureBlocking(true);
        if (this.socketInterceptor != null) {
            this.socketInterceptor.onConnect(socket);
        }
        authenticator.auth(clientConnection);
        socketChannel.configureBlocking(isBlock);
        socket.setSoTimeout(0);
        if (!isBlock) {
            clientConnection.getReadHandler().register();
        }
        return clientConnection;
    }

    public void destroyConnection(ClientConnection clientConnection) {
        Address endpoint = clientConnection.getRemoteEndpoint();
        if (endpoint != null) {
            this.connections.remove(clientConnection.getRemoteEndpoint());
        }
    }

    @Override
    public boolean removeEventHandler(Integer callId) {
        if (callId != null) {
            for (ClientConnection clientConnection : this.connections.values()) {
                if (clientConnection.deRegisterEventHandler(callId) == null) continue;
                return true;
            }
        }
        return false;
    }

    public void handlePacket(ClientPacket packet) {
        this.client.getClientExecutionService().execute(new ClientPacketProcessor(packet));
    }

    public int newCallId() {
        return this.callIdIncrementer.incrementAndGet();
    }

    private Object authenticate(ClientConnection connection, Credentials credentials, ClientPrincipal principal, boolean reAuth, boolean firstConnection) throws IOException {
        SerializableCollection collectionWrapper;
        SerializationService ss = this.getSerializationService();
        AuthenticationRequest auth = new AuthenticationRequest(credentials, principal);
        connection.init();
        auth.setReAuth(reAuth);
        auth.setFirstConnection(firstConnection);
        try {
            collectionWrapper = (SerializableCollection)this.sendAndReceive((ClientRequest)auth, connection);
        }
        catch (Exception e) {
            throw new RetryableIOException((Throwable)e);
        }
        Iterator iter = collectionWrapper.iterator();
        if (iter.hasNext()) {
            Data addressData = (Data)iter.next();
            Address address = (Address)ss.toObject((Object)addressData);
            connection.setRemoteEndpoint(address);
            if (iter.hasNext()) {
                Data principalData = (Data)iter.next();
                return ss.toObject((Object)principalData);
            }
        }
        throw new AuthenticationException();
    }

    public Object sendAndReceive(ClientRequest request, ClientConnection connection) throws Exception {
        SerializationService ss = this.client.getSerializationService();
        connection.write(ss.toData((Object)request));
        Data data = connection.read();
        ClientResponse clientResponse = (ClientResponse)ss.toObject((Object)data);
        Object response = ss.toObject((Object)clientResponse.getResponse());
        if (response instanceof Throwable) {
            Throwable t = (Throwable)response;
            ExceptionUtil.fixRemoteStackTrace((Throwable)t, (StackTraceElement[])Thread.currentThread().getStackTrace());
            throw new Exception(t);
        }
        return response;
    }

    static class SSLSocketChannelWrapperFactory
    implements SocketChannelWrapperFactory {
        final SSLContextFactory sslContextFactory;

        SSLSocketChannelWrapperFactory(SSLConfig sslConfig) {
            SSLContextFactory sslContextFactoryObject = (SSLContextFactory)sslConfig.getFactoryImplementation();
            try {
                String factoryClassName = sslConfig.getFactoryClassName();
                if (sslContextFactoryObject == null && factoryClassName != null) {
                    sslContextFactoryObject = (SSLContextFactory)Class.forName(factoryClassName).newInstance();
                }
                if (sslContextFactoryObject == null) {
                    sslContextFactoryObject = new BasicSSLContextFactory();
                }
                sslContextFactoryObject.init(sslConfig.getProperties());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.sslContextFactory = sslContextFactoryObject;
        }

        @Override
        public SocketChannelWrapper wrapSocketChannel(SocketChannel socketChannel, boolean client) throws Exception {
            return new SSLSocketChannelWrapper(this.sslContextFactory.getSSLContext(), socketChannel, client);
        }
    }

    static class DefaultSocketChannelWrapperFactory
    implements SocketChannelWrapperFactory {
        DefaultSocketChannelWrapperFactory() {
        }

        @Override
        public SocketChannelWrapper wrapSocketChannel(SocketChannel socketChannel, boolean client) throws Exception {
            return new DefaultSocketChannelWrapper(socketChannel);
        }
    }

    static interface SocketChannelWrapperFactory {
        public SocketChannelWrapper wrapSocketChannel(SocketChannel var1, boolean var2) throws Exception;
    }

    private class ClusterAuthenticator
    implements Authenticator {
        private ClusterAuthenticator() {
        }

        @Override
        public void auth(ClientConnection connection) throws AuthenticationException, IOException {
            ClientConnectionManagerImpl.this.authenticate(connection, ClientConnectionManagerImpl.this.credentials, ClientConnectionManagerImpl.this.principal, false, false);
        }
    }

    public class ManagerAuthenticator
    implements Authenticator {
        @Override
        public void auth(ClientConnection connection) throws AuthenticationException, IOException {
            Object response = ClientConnectionManagerImpl.this.authenticate(connection, ClientConnectionManagerImpl.this.credentials, ClientConnectionManagerImpl.this.principal, true, true);
            ClientConnectionManagerImpl.this.principal = (ClientPrincipal)response;
        }
    }

    class ClientPacketProcessor
    implements Runnable {
        ClientPacket packet;

        ClientPacketProcessor(ClientPacket packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            ClientConnection conn = (ClientConnection)this.packet.getConn();
            ClientResponse clientResponse = (ClientResponse)ClientConnectionManagerImpl.this.getSerializationService().toObject((Object)this.packet.getData());
            int callId = clientResponse.getCallId();
            Data response = clientResponse.getResponse();
            if (clientResponse.isEvent()) {
                this.handleEvent(response, callId, conn);
            } else {
                this.handlePacket(response, clientResponse.isError(), callId, conn);
            }
        }

        private void handlePacket(Object response, boolean isError, int callId, ClientConnection conn) {
            ClientCallFuture future = conn.deRegisterCallId(callId);
            if (future == null) {
                logger.warning("No call for callId: " + callId + ", response: " + response);
                return;
            }
            if (isError) {
                response = ClientConnectionManagerImpl.this.getSerializationService().toObject(response);
            }
            future.notify(response);
        }

        private void handleEvent(Data event, int callId, ClientConnection conn) {
            EventHandler eventHandler = conn.getEventHandler(callId);
            Object eventObject = ClientConnectionManagerImpl.this.getSerializationService().toObject((Object)event);
            if (eventHandler == null) {
                logger.warning("No eventHandler for callId: " + callId + ", event: " + eventObject + ", conn: " + conn);
                return;
            }
            eventHandler.handle(eventObject);
        }
    }
}

