/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.util.ExceptionUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;

public class HazelcastCloudDiscovery {
    public static final HazelcastProperty CLOUD_URL_BASE_PROPERTY = new HazelcastProperty("hazelcast.client.cloud.url", "https://coordinator.hazelcast.cloud");
    private static final String CLOUD_URL_PATH = "/cluster/discovery?token=";
    private static final String PRIVATE_ADDRESS_PROPERTY = "private-address";
    private static final String PUBLIC_ADDRESS_PROPERTY = "public-address";
    private final String endpointUrl;
    private final int connectionTimeoutInMillis;

    HazelcastCloudDiscovery(String endpointUrl, int connectionTimeoutInMillis) {
        this.endpointUrl = endpointUrl;
        this.connectionTimeoutInMillis = connectionTimeoutInMillis;
    }

    Map<Address, Address> discoverNodes() {
        try {
            return this.callService();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private Map<Address, Address> callService() throws IOException, CertificateException {
        URL url = new URL(this.endpointUrl);
        HttpURLConnection httpsConnection = (HttpURLConnection)url.openConnection();
        httpsConnection.setRequestMethod("GET");
        httpsConnection.setConnectTimeout(this.connectionTimeoutInMillis);
        httpsConnection.setReadTimeout(this.connectionTimeoutInMillis);
        httpsConnection.setRequestProperty("Accept-Charset", "UTF-8");
        httpsConnection.connect();
        this.checkCertificate(httpsConnection);
        HazelcastCloudDiscovery.checkError(httpsConnection);
        return this.parseResponse(httpsConnection.getInputStream());
    }

    private void checkCertificate(HttpURLConnection connection) throws IOException, CertificateException {
        if (!(connection instanceof HttpsURLConnection)) {
            return;
        }
        HttpsURLConnection con = (HttpsURLConnection)connection;
        for (Certificate cert : con.getServerCertificates()) {
            if (!(cert instanceof X509Certificate)) {
                throw new CertificateException("Invalid certificate from hazelcast.cloud endpoint");
            }
            ((X509Certificate)cert).checkValidity();
        }
    }

    private Map<Address, Address> parseResponse(InputStream is) throws IOException {
        JsonValue jsonValue = Json.parse((String)HazelcastCloudDiscovery.readInputStream(is));
        List response = jsonValue.asArray().values();
        HashMap<Address, Address> privateToPublicAddresses = new HashMap<Address, Address>();
        for (JsonValue value : response) {
            String privateAddress = value.asObject().get(PRIVATE_ADDRESS_PROPERTY).asString();
            String publicAddress = value.asObject().get(PUBLIC_ADDRESS_PROPERTY).asString();
            Address publicAddr = this.createAddress(publicAddress);
            privateToPublicAddresses.put(new Address(privateAddress, publicAddr.getPort()), publicAddr);
        }
        return privateToPublicAddresses;
    }

    private Address createAddress(String hostname) throws IOException {
        AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder((String)hostname);
        String scopedHostName = AddressHelper.getScopedHostName(addressHolder);
        return new Address(scopedHostName, addressHolder.getPort());
    }

    private static String readInputStream(InputStream is) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        StringBuilder response = new StringBuilder();
        while ((line = in.readLine()) != null) {
            response.append(line);
        }
        in.close();
        return response.toString();
    }

    private static void checkError(HttpURLConnection httpConnection) throws IOException {
        int responseCode = httpConnection.getResponseCode();
        if (responseCode != 200) {
            String errorMessage = HazelcastCloudDiscovery.extractErrorMessage(httpConnection);
            throw new IOException(errorMessage);
        }
    }

    private static String extractErrorMessage(HttpURLConnection httpConnection) {
        InputStream errorStream = httpConnection.getErrorStream();
        return errorStream == null ? "" : HazelcastCloudDiscovery.readFrom(errorStream);
    }

    private static String readFrom(InputStream stream) {
        Scanner scanner = new Scanner(stream, "UTF-8").useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    public static String createUrlEndpoint(String cloudBaseUrl, String cloudToken) {
        return cloudBaseUrl + CLOUD_URL_PATH + cloudToken;
    }
}

