/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.semaphore;

import com.hazelcast.client.cp.internal.session.ClientProxySessionManager;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.impl.protocol.codec.CPSemaphoreAcquireCodec;
import com.hazelcast.client.impl.protocol.codec.CPSemaphoreAvailablePermitsCodec;
import com.hazelcast.client.impl.protocol.codec.CPSemaphoreChangeCodec;
import com.hazelcast.client.impl.protocol.codec.CPSemaphoreDrainCodec;
import com.hazelcast.client.impl.protocol.codec.CPSemaphoreInitCodec;
import com.hazelcast.client.impl.protocol.codec.CPSemaphoreReleaseCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.session.SessionExpiredException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.UuidUtil;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

class RaftSessionAwareSemaphoreProxy
extends ClientProxy
implements ISemaphore {
    private final ClientProxySessionManager sessionManager = this.getClient().getProxySessionManager();
    private final RaftGroupId groupId;
    private final String objectName;

    RaftSessionAwareSemaphoreProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:semaphoreService", proxyName, context);
        this.groupId = groupId;
        this.objectName = objectName;
    }

    public boolean init(int permits) {
        Preconditions.checkNotNegative((int)permits, (String)"Permits must be non-negative!");
        ClientMessage request = CPSemaphoreInitCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (int)permits);
        HazelcastClientInstanceImpl client = this.getClient();
        ClientMessage response = (ClientMessage)new ClientInvocation(client, request, this.objectName).invoke().join();
        return CPSemaphoreInitCodec.decodeResponse((ClientMessage)response).response;
    }

    public void acquire() {
        this.acquire(1);
    }

    public void acquire(int permits) {
        Preconditions.checkPositive((int)permits, (String)"Permits must be positive!");
        long threadId = ThreadUtil.getThreadId();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        while (true) {
            long sessionId = this.sessionManager.acquireSession(this.groupId, permits);
            try {
                ClientMessage request = CPSemaphoreAcquireCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (long)sessionId, (long)threadId, (UUID)invocationUid, (int)permits, (long)-1L);
                HazelcastClientInstanceImpl client = this.getClient();
                new ClientInvocation(client, request, this.objectName).invoke().join();
                return;
            }
            catch (SessionExpiredException e) {
                this.sessionManager.invalidateSession(this.groupId, sessionId);
                continue;
            }
            break;
        }
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    public boolean tryAcquire(int permits) {
        return this.tryAcquire(permits, 0L, TimeUnit.MILLISECONDS);
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return this.tryAcquire(1, timeout, unit);
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        Preconditions.checkPositive((int)permits, (String)"Permits must be positive!");
        long timeoutMs = Math.max(0L, unit.toMillis(timeout));
        long threadId = ThreadUtil.getThreadId();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        while (true) {
            long start = Clock.currentTimeMillis();
            long sessionId = this.sessionManager.acquireSession(this.groupId, permits);
            try {
                ClientMessage request = CPSemaphoreAcquireCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (long)sessionId, (long)threadId, (UUID)invocationUid, (int)permits, (long)timeoutMs);
                HazelcastClientInstanceImpl client = this.getClient();
                ClientMessage response = (ClientMessage)new ClientInvocation(client, request, this.objectName).invoke().join();
                boolean acquired = CPSemaphoreAcquireCodec.decodeResponse((ClientMessage)response).response;
                if (!acquired) {
                    this.sessionManager.releaseSession(this.groupId, sessionId, permits);
                }
                return acquired;
            }
            catch (SessionExpiredException e) {
                this.sessionManager.invalidateSession(this.groupId, sessionId);
                if ((timeoutMs -= Clock.currentTimeMillis() - start) > 0L) continue;
                return false;
            }
            break;
        }
    }

    public void release() {
        this.release(1);
    }

    public void release(int permits) {
        Preconditions.checkPositive((int)permits, (String)"Permits must be positive!");
        long sessionId = this.sessionManager.getSession(this.groupId);
        if (sessionId == -1L) {
            throw this.newIllegalStateException(null);
        }
        long threadId = ThreadUtil.getThreadId();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        try {
            ClientMessage request = CPSemaphoreReleaseCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (long)sessionId, (long)threadId, (UUID)invocationUid, (int)permits);
            HazelcastClientInstanceImpl client = this.getClient();
            new ClientInvocation(client, request, this.objectName).invoke().join();
        }
        catch (SessionExpiredException e) {
            this.sessionManager.invalidateSession(this.groupId, sessionId);
            throw this.newIllegalStateException(e);
        }
        finally {
            this.sessionManager.releaseSession(this.groupId, sessionId, permits);
        }
    }

    public int availablePermits() {
        ClientMessage request = CPSemaphoreAvailablePermitsCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName);
        HazelcastClientInstanceImpl client = this.getClient();
        ClientMessage response = (ClientMessage)new ClientInvocation(client, request, this.objectName).invoke().join();
        return CPSemaphoreAvailablePermitsCodec.decodeResponse((ClientMessage)response).response;
    }

    public int drainPermits() {
        long threadId = ThreadUtil.getThreadId();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        while (true) {
            long sessionId = this.sessionManager.acquireSession(this.groupId, 1024);
            try {
                ClientMessage request = CPSemaphoreDrainCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (long)sessionId, (long)threadId, (UUID)invocationUid);
                HazelcastClientInstanceImpl client = this.getClient();
                ClientMessage response = (ClientMessage)new ClientInvocation(client, request, this.objectName).invoke().join();
                return CPSemaphoreDrainCodec.decodeResponse((ClientMessage)response).response;
            }
            catch (SessionExpiredException e) {
                this.sessionManager.invalidateSession(this.groupId, sessionId);
                continue;
            }
            break;
        }
    }

    public void reducePermits(int reduction) {
        Preconditions.checkNotNegative((int)reduction, (String)"Reduction must be non-negative!");
        if (reduction == 0) {
            return;
        }
        long sessionId = this.sessionManager.acquireSession(this.groupId);
        if (sessionId == -1L) {
            throw this.newIllegalStateException(null);
        }
        long threadId = ThreadUtil.getThreadId();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        try {
            ClientMessage request = CPSemaphoreChangeCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (long)sessionId, (long)threadId, (UUID)invocationUid, (int)(-reduction));
            new ClientInvocation(this.getClient(), request, this.objectName).invoke().join();
        }
        catch (SessionExpiredException e) {
            this.sessionManager.invalidateSession(this.groupId, sessionId);
            throw this.newIllegalStateException(e);
        }
        finally {
            this.sessionManager.releaseSession(this.groupId, sessionId);
        }
    }

    public void increasePermits(int increase) {
        Preconditions.checkNotNegative((int)increase, (String)"Increase must be non-negative!");
        if (increase == 0) {
            return;
        }
        long sessionId = this.sessionManager.acquireSession(this.groupId);
        if (sessionId == -1L) {
            throw this.newIllegalStateException(null);
        }
        long threadId = ThreadUtil.getThreadId();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        try {
            ClientMessage request = CPSemaphoreChangeCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (long)sessionId, (long)threadId, (UUID)invocationUid, (int)increase);
            new ClientInvocation(this.getClient(), request, this.objectName).invoke().join();
        }
        catch (SessionExpiredException e) {
            this.sessionManager.invalidateSession(this.groupId, sessionId);
            throw this.newIllegalStateException(e);
        }
        finally {
            this.sessionManager.releaseSession(this.groupId, sessionId);
        }
    }

    private IllegalStateException newIllegalStateException(SessionExpiredException e) {
        return new IllegalStateException("No valid session!", e);
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.getServiceName(), (String)this.objectName);
        new ClientInvocation(this.getClient(), request, this.name).invoke().join();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }
}

