/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.InputStream;
import java.util.Properties;

public class ClientClasspathYamlConfig
extends ClientConfig {
    private static final ILogger LOGGER = Logger.getLogger(ClientClasspathYamlConfig.class);

    public ClientClasspathYamlConfig(String resource) {
        this(resource, System.getProperties());
    }

    public ClientClasspathYamlConfig(String resource, Properties properties) {
        this(Thread.currentThread().getContextClassLoader(), resource, properties);
    }

    public ClientClasspathYamlConfig(ClassLoader classLoader, String resource, Properties properties) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader can't be null");
        }
        if (resource == null) {
            throw new IllegalArgumentException("resource can't be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties can't be null");
        }
        LOGGER.info("Configuring Hazelcast Client from '" + resource + "'.");
        InputStream in = classLoader.getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException("Specified resource '" + resource + "' could not be found!");
        }
        YamlClientConfigBuilder yamlClientConfigBuilder = new YamlClientConfigBuilder(in);
        yamlClientConfigBuilder.setProperties(properties);
        yamlClientConfigBuilder.build(this, classLoader);
    }
}

