/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddPartitionListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ClientGetPartitionsCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.HashUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public final class ClientPartitionServiceImpl
extends ClientAddPartitionListenerCodec.AbstractEventHandler
implements EventHandler<ClientMessage>,
ClientPartitionService {
    private static final long PERIOD = 10L;
    private static final long INITIAL_DELAY = 10L;
    private final ExecutionCallback<ClientMessage> refreshTaskCallback = new RefreshTaskCallback();
    private final ConcurrentHashMap<Integer, Address> partitions = new ConcurrentHashMap(271, 0.75f, 1);
    private final ClientExecutionServiceImpl clientExecutionService;
    private final HazelcastClientInstanceImpl client;
    private final ILogger logger;
    private volatile int partitionCount;
    private volatile int lastPartitionStateVersion = -1;
    private final Object lock = new Object();

    public ClientPartitionServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.logger = client.getLoggingService().getLogger(ClientPartitionService.class);
        this.clientExecutionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
    }

    public void start() {
        this.clientExecutionService.scheduleWithRepetition(new RefreshTask(), 10L, 10L, TimeUnit.SECONDS);
    }

    public void listenPartitionTable(Connection ownerConnection) throws Exception {
        this.lastPartitionStateVersion = -1;
        if (((ClientConnection)ownerConnection).getConnectedServerVersion() >= BuildInfo.calculateVersion((String)"3.9")) {
            ClientMessage clientMessage = ClientAddPartitionListenerCodec.encodeRequest();
            ClientInvocation invocation = new ClientInvocation(this.client, clientMessage, null, ownerConnection);
            invocation.setEventHandler(this);
            invocation.invokeUrgent().get();
        }
    }

    public void refreshPartitions() {
        try {
            this.clientExecutionService.execute(new RefreshTask());
        }
        catch (RejectedExecutionException ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
    }

    public void handlePartitionsEventV15(Collection<Map.Entry<Address, List<Integer>>> collection, int partitionStateVersion) {
        this.processPartitionResponse(collection, partitionStateVersion, true);
    }

    @Override
    public void beforeListenerRegister() {
    }

    @Override
    public void onListenerRegister() {
    }

    private void waitForPartitionsFetchedOnce() {
        while ((this.partitions.isEmpty() || this.partitionCount == 0) && this.client.getConnectionManager().isAlive()) {
            if (this.isClusterFormedByOnlyLiteMembers()) {
                throw new NoDataMemberInClusterException("Partitions can't be assigned since all nodes in the cluster are lite members");
            }
            ClientMessage requestMessage = ClientGetPartitionsCodec.encodeRequest();
            ClientInvocationFuture future = new ClientInvocation(this.client, requestMessage, null).invokeUrgent();
            try {
                ClientMessage responseMessage = (ClientMessage)future.get();
                ClientGetPartitionsCodec.ResponseParameters response = ClientGetPartitionsCodec.decodeResponse((ClientMessage)responseMessage);
                this.processPartitionResponse(response.partitions, response.partitionStateVersion, response.partitionStateVersionExist);
            }
            catch (Exception e) {
                if (!this.client.getLifecycleService().isRunning()) continue;
                this.logger.warning("Error while fetching cluster partition table!", (Throwable)e);
            }
        }
    }

    private boolean isClusterFormedByOnlyLiteMembers() {
        ClientClusterService clusterService = this.client.getClientClusterService();
        return clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPartitionResponse(Collection<Map.Entry<Address, List<Integer>>> partitions, int partitionStateVersion, boolean partitionStateVersionExist) {
        Object object = this.lock;
        synchronized (object) {
            if (!partitionStateVersionExist || partitionStateVersion > this.lastPartitionStateVersion) {
                for (Map.Entry<Address, List<Integer>> entry : partitions) {
                    Address address = entry.getKey();
                    for (Integer partition : entry.getValue()) {
                        this.partitions.put(partition, address);
                    }
                }
                this.partitionCount = this.partitions.size();
                this.lastPartitionStateVersion = partitionStateVersion;
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Processed partition response. partitionStateVersion : " + (partitionStateVersionExist ? Integer.valueOf(partitionStateVersion) : "NotAvailable") + ", partitionCount :" + this.partitionCount);
                }
            }
        }
        return this.partitionCount > 0;
    }

    public void stop() {
        this.partitions.clear();
    }

    @Override
    public Address getPartitionOwner(int partitionId) {
        this.waitForPartitionsFetchedOnce();
        return this.partitions.get(partitionId);
    }

    @Override
    public int getPartitionId(Data key) {
        int pc = this.getPartitionCount();
        if (pc <= 0) {
            return 0;
        }
        int hash = key.getPartitionHash();
        return HashUtil.hashToIndex((int)hash, (int)pc);
    }

    @Override
    public int getPartitionId(Object key) {
        Data data = this.client.getSerializationService().toData(key);
        return this.getPartitionId(data);
    }

    @Override
    public int getPartitionCount() {
        this.waitForPartitionsFetchedOnce();
        return this.partitionCount;
    }

    @Override
    public Partition getPartition(int partitionId) {
        return new PartitionImpl(partitionId);
    }

    @Override
    public boolean isPartitionCountConsistent(int partitionCount) {
        return this.partitionCount == 0 || partitionCount == this.partitionCount;
    }

    @Override
    public void beforeClusterSwitch(CandidateClusterContext context) {
        this.partitions.clear();
    }

    private class RefreshTaskCallback
    implements ExecutionCallback<ClientMessage> {
        private RefreshTaskCallback() {
        }

        public void onResponse(ClientMessage responseMessage) {
            if (responseMessage == null) {
                return;
            }
            ClientGetPartitionsCodec.ResponseParameters response = ClientGetPartitionsCodec.decodeResponse((ClientMessage)responseMessage);
            ClientPartitionServiceImpl.this.processPartitionResponse(response.partitions, response.partitionStateVersion, response.partitionStateVersionExist);
        }

        public void onFailure(Throwable t) {
            if (ClientPartitionServiceImpl.this.client.getLifecycleService().isRunning()) {
                ClientPartitionServiceImpl.this.logger.warning("Error while fetching cluster partition table!", t);
            }
        }
    }

    private final class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            block3: {
                try {
                    ClientConnectionManager connectionManager = ClientPartitionServiceImpl.this.client.getConnectionManager();
                    ClientConnection connection = connectionManager.getOwnerConnection();
                    if (connection == null) {
                        return;
                    }
                    ClientMessage requestMessage = ClientGetPartitionsCodec.encodeRequest();
                    ClientInvocationFuture future = new ClientInvocation(ClientPartitionServiceImpl.this.client, requestMessage, null).invokeUrgent();
                    future.andThen((ExecutionCallback<ClientMessage>)ClientPartitionServiceImpl.this.refreshTaskCallback);
                }
                catch (Exception e) {
                    if (!ClientPartitionServiceImpl.this.client.getLifecycleService().isRunning()) break block3;
                    ClientPartitionServiceImpl.this.logger.warning("Error while fetching cluster partition table!", (Throwable)e);
                }
            }
        }
    }

    private final class PartitionImpl
    implements Partition {
        private final int partitionId;

        private PartitionImpl(int partitionId) {
            this.partitionId = partitionId;
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public Member getOwner() {
            Address owner = ClientPartitionServiceImpl.this.getPartitionOwner(this.partitionId);
            if (owner != null) {
                return ClientPartitionServiceImpl.this.client.getClientClusterService().getMember(owner);
            }
            return null;
        }

        public String toString() {
            return "PartitionImpl{partitionId=" + this.partitionId + '}';
        }
    }
}

