/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.Addresses;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.util.Preconditions;

public class DiscoveryAddressProvider
implements AddressProvider {
    private final ILogger logger;
    private final DiscoveryService discoveryService;

    public DiscoveryAddressProvider(DiscoveryService discoveryService, LoggingService loggingService) {
        this.discoveryService = discoveryService;
        this.logger = loggingService.getLogger(DiscoveryAddressProvider.class);
    }

    @Override
    public Addresses loadAddresses() {
        Iterable discoveredNodes = (Iterable)Preconditions.checkNotNull((Object)this.discoveryService.discoverNodes(), (String)"Discovered nodes cannot be null!");
        Addresses possibleMembers = new Addresses();
        for (DiscoveryNode discoveryNode : discoveredNodes) {
            possibleMembers.primary().add(discoveryNode.getPrivateAddress());
        }
        return possibleMembers;
    }
}

