/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.logging.AbstractLogger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LogListener;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class ClientLoggingService
implements LoggingService {
    private final ConcurrentMap<String, ILogger> mapLoggers = new ConcurrentHashMap<String, ILogger>(100);
    private final ConstructorFunction<String, ILogger> loggerConstructor = new ConstructorFunction<String, ILogger>(){

        public ILogger createNew(String key) {
            return new DefaultLogger(key);
        }
    };
    private final LoggerFactory loggerFactory;
    private final String versionMessage;

    public ClientLoggingService(String groupName, String loggingType, BuildInfo buildInfo, String clientName) {
        this.loggerFactory = Logger.newLoggerFactory((String)loggingType);
        JetBuildInfo jetBuildInfo = buildInfo.getJetBuildInfo();
        this.versionMessage = clientName + " [" + groupName + "]" + (jetBuildInfo != null ? " [" + jetBuildInfo.getVersion() + "]" : "") + " [" + buildInfo.getVersion() + "] ";
    }

    public void addLogListener(Level level, LogListener logListener) {
        throw new UnsupportedOperationException();
    }

    public void removeLogListener(LogListener logListener) {
        throw new UnsupportedOperationException();
    }

    public ILogger getLogger(String name) {
        return (ILogger)ConcurrencyUtil.getOrPutIfAbsent(this.mapLoggers, (Object)name, this.loggerConstructor);
    }

    public ILogger getLogger(Class clazz) {
        return (ILogger)ConcurrencyUtil.getOrPutIfAbsent(this.mapLoggers, (Object)clazz.getName(), this.loggerConstructor);
    }

    private class DefaultLogger
    extends AbstractLogger {
        final String name;
        final ILogger logger;

        DefaultLogger(String name) {
            this.name = name;
            this.logger = ClientLoggingService.this.loggerFactory.getLogger(name);
        }

        public void log(Level level, String message) {
            this.log(level, message, null);
        }

        public void log(Level level, String message, Throwable thrown) {
            if (this.logger.isLoggable(level)) {
                String logMessage = ClientLoggingService.this.versionMessage + message;
                this.logger.log(level, logMessage, thrown);
            }
        }

        public void log(LogEvent logEvent) {
        }

        public Level getLevel() {
            return this.logger.getLevel();
        }

        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }
    }
}

